/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_ACCESS_H__
#define __CHEROKEE_ACCESS_H__

#include "common.h"
#include "list.h"
#include "socket.h"

typedef struct {
	list_t list_ips;
	list_t list_subnets;
} cherokee_access_t;

ret_t cherokee_access_new  (cherokee_access_t **entry);
ret_t cherokee_access_free (cherokee_access_t  *entry);

ret_t cherokee_access_add_ip     (cherokee_access_t *entry, char *ip);
ret_t cherokee_access_add_subnet (cherokee_access_t *entry, char *subnet);

ret_t cherokee_access_ip_match   (cherokee_access_t *entry, cherokee_socket_t *sock);

ret_t cherokee_access_print_debug (cherokee_access_t *entry);

#endif /* __CHEROKEE_ACCESS_H */
