/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>

#include "handler_table.h"
#include "handler.h"


ret_t
cherokee_handler_table_new  (cherokee_handler_table_t **pt)
{
	CHEROKEE_NEW_STRUCT(n, handler_table);

	/* Init tables 
	 */
	cherokee_table_init (&n->table);
//	cherokee_table_init (&n->handlers);
	
	/* Return the object
	 */
	*pt = n;
	
	return ret_ok;
}


ret_t
cherokee_handler_table_free (cherokee_handler_table_t *pt)
{
	cherokee_table_clean (&pt->table);
//	cherokee_table_clean (&pt->handlers);
	
	free (pt);
	
	return ret_ok;
}


ret_t 
cherokee_handler_table_get (cherokee_handler_table_t *pt, char *requested_url, cherokee_handler_table_entry_t **plugin_entry, cherokee_buffer_t *web_directory)
{
	char *slash;
	cherokee_handler_table_entry_t *entry = NULL;

	cherokee_buffer_add (web_directory, requested_url, strlen(requested_url));

	do {
		entry = cherokee_table_get_val (&pt->table, web_directory->buf);
		
		/* Found
		 */
		if (entry != NULL)
			goto go_out;
 
		if (web_directory->len <= 0)
			goto go_out;


		/* Modify url for next loop:
		 * Find the last / and finish the string there.
		 */
		if (web_directory->buf[web_directory->len-1] == '/') {
			web_directory->buf[web_directory->len-1] = '\0';
			web_directory->len--;
		} else {
			slash = rindex (web_directory->buf, '/');
			if (slash == NULL) goto go_out;

			slash[1] = '\0';
			web_directory->len -= ((web_directory->buf + web_directory->len) - slash -1);
		}

	} while (entry == NULL);


go_out:	
	/* Set the in-out values
	 */
	*plugin_entry = entry;

#if 0
	printf ("ptable::GET - entry %p entry->properties: %p\n", entry, entry->properties);
#endif

	return (entry == NULL) ? ret_error : ret_ok;
}


ret_t inline
cherokee_handler_table_add (cherokee_handler_table_t *pt, char *dir, cherokee_handler_table_entry_t *plugin_entry)
{
#if 0
	printf ("ptable::ADD - entry %p entry->properties: %p ('%s')\n", plugin_entry, plugin_entry->properties, dir);
#endif

	/* Add to "dir <-> plugin_entry" table
	 */
	return cherokee_table_add (TABLE(&pt->table), dir, (void*)plugin_entry);
}


