/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "module.h"
#include "connection.h"
#include "handler_common.h"
#include "handler_file.h"
#include "handler_dirlist.h"
#include "handler_phpcgi.h"
#include "server.h"
#include "list_ext.h"


cherokee_module_info_t cherokee_common_info = {
	cherokee_handler,              /* type     */
	cherokee_handler_common_new    /* new func */
};

ret_t 
cherokee_handler_common_new (cherokee_handler_t **hdl, void *cnt, cherokee_table_t *properties)
{
	struct stat            info;
	cherokee_connection_t *conn = CONN(cnt);
	cherokee_server_t     *srv  = CONN_SRV(cnt);

#if 0
	PRINT_DEBUG ("request: '%s'\n", conn->request->buf);
	PRINT_DEBUG ("local:   '%s'\n", conn->local_directory->buf);
#endif

	cherokee_buffer_add_buffer (conn->local_directory, conn->request);

	/* Request is a directory
	 */
	if ((stat (conn->local_directory->buf, &info) == 0) && S_ISDIR(info.st_mode)) {
		list_t *i;

		/* Have an index file inside?
		 */
		list_for_each (i, &srv->index_list) {
			int   is_file, exists;
			char *index     = LIST_ITEM_INFO(i);
			int   index_len = strlen (index);
			
			/* Add the index file
			 */
			cherokee_buffer_add (conn->local_directory, index, index_len);

			/* stat() it
			 */
			exists = (stat (conn->local_directory->buf, &info) == 0);
			
			/* Drop the index filename
			 */
			cherokee_buffer_drop_endding (conn->local_directory, index_len);

			/* If the file doesn't exist, go and try with the next one
			 */
			if (! exists) {
				continue;
			}

			cherokee_buffer_drop_endding (conn->local_directory, conn->request->len);
			
			is_file = S_ISREG(info.st_mode);
			if (! is_file) {
				continue;
			}

			/* Add the index file to the request
			 */
			cherokee_buffer_add (conn->request, index, index_len);
			
			if ((index_len > 4) && (strcasecmp(".php", index+index_len-4) == 0)) {
				return cherokee_handler_phpcgi_new (hdl, cnt, properties);		
			} else {
				return cherokee_handler_file_new (hdl, cnt, properties);
			}
		} 

		/* If the dir hasn't a index file, it uses dirlist
		 */
		cherokee_buffer_drop_endding (conn->local_directory, conn->request->len);
		return cherokee_handler_dirlist_new (hdl, cnt, properties);
	}

	if ((conn->local_directory->len > 5) &&
	    (strcasecmp(".php", conn->local_directory->buf + conn->local_directory->len -4) == 0))
	{
		/* PHP Handler
		 */
		cherokee_buffer_drop_endding (conn->local_directory, conn->request->len);
		return cherokee_handler_phpcgi_new (hdl, cnt, properties);		
	} else {
		/* File handler
		 */
		cherokee_buffer_drop_endding (conn->local_directory, conn->request->len);
		return cherokee_handler_file_new (hdl, cnt, properties);
	}
}



/* Library init function
 */

static int _common_is_init = 0;

void
common_init (void)
{
	if (_common_is_init)
		return;

	/* Init the dependences
	 */
	file_init();
	dirlist_init();

	_common_is_init = 1;
}
