/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_HEADER_H__
#define __CHEROKEE_HEADER_H__

#include "common.h"
#include "buffer.h"
#include "http.h"



typedef struct {
	char *info;
	int   info_len;
} cherokee_header_entry_t;

typedef struct {
	char *header;
	char *header_info;
	int   header_info_len;
} cherokee_header_unknown_entry_t;

typedef enum {
	   header_connection,
	   header_range,
	   header_keepalive,
	   header_accept,
	   header_host,
	   header_accept_encoding,
	   header_user_agent,
	   header_keep_alive,
	   header_referer,
	   header_location,
	   header_content_length,
	   HEADER_LENGTH
} cherokee_common_header_t;

typedef struct {
	/* Known headers
	 */
	cherokee_header_entry_t header[HEADER_LENGTH];
	
	/* Unknown headers
	 */
	cherokee_header_unknown_entry_t *unknowns;
	int                              unknowns_len;

	/* Properties
	 */
	cherokee_http_version_t version;
	cherokee_http_method_t  method;

	/* Request
	 */
	char *request;
	int   request_len;

	/* Query string
	 */
	char *query_string;
	int   query_string_len;

} cherokee_header_t;


#define HDR(h)        ((cherokee_header_t *)(h))
#define HDR_METHOD(h) ((cherokee_header_t *)(h))->method

ret_t cherokee_header_new          (cherokee_header_t **hdr);
ret_t cherokee_header_free         (cherokee_header_t  *hdr);
ret_t cherokee_header_clean        (cherokee_header_t  *hdr);

ret_t cherokee_header_parse        (cherokee_header_t  *hdr, cherokee_buffer_t *buffer, int http_request);
ret_t cherokee_header_copy_request (cherokee_header_t  *hdr, cherokee_buffer_t *request);

ret_t cherokee_header_has_known    (cherokee_header_t  *hdr, cherokee_common_header_t header);
ret_t cherokee_header_get_known    (cherokee_header_t  *hdr, cherokee_common_header_t header, char **info, int *info_len);
ret_t cherokee_header_get_unknown  (cherokee_header_t  *hdr, char *name, int name_len, char **header, int *header_len);

ret_t cherokee_header_copy_known   (cherokee_header_t  *hdr, cherokee_common_header_t header, cherokee_buffer_t *buf);
ret_t cherokee_header_copy_unknown (cherokee_header_t  *hdr, char *name, int name_len, cherokee_buffer_t *buf);


#endif /* __CHEROKEE_HEADER_H__  */
