/* Cherokee
 *
 * Based on the common handler
 */


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "handler_phpcgi.h"
#include "handler_common.h"
#include "handler_phpsite.h"
#include "server.h"


cherokee_module_info_t cherokee_phpsite_info = {
	cherokee_handler,               /* type     */
	cherokee_handler_phpsite_new    /* new func */
};

ret_t 
cherokee_handler_phpsite_new (cherokee_handler_t **hdl, void *cnt, cherokee_table_t *properties)
{
	ret_t r;
	cherokee_connection_t *conn = CONN(cnt);
	cherokee_server_t     *srv  = CONN_SRV(cnt);

	/* File  */
	if((conn->request->len > 5) && 
		(strcasecmp(".php", conn->request->buf + conn->request->len - 4) == 0)) 
	{
		r = cherokee_handler_phpcgi_new(hdl, cnt, properties);
	} else	
	{
		r = cherokee_handler_common_new(hdl, cnt, properties);
	}

	return r;
}



/* Library init function
 */

static int _me_is_init = 0;

void
phpsite_init (void)
{
	if (_me_is_init)
		return;

	/* Init the dependences
	 */
	phpcgi_init();
	common_init();

	_me_is_init = 1;
}
