/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * This piece of code by:
 *      Ricardo Cardenes Medina <ricardo@conysis.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_SOCKET_H__
#define __CHEROKEE_SOCKET_H__

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else 
#include <time.h>
#endif

#include <sys/types.h>	

#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif

#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif

#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif

#ifdef HAVE_TLS
# include <gnutls/extra.h>
# include <gnutls/gnutls.h>
#endif

#include "list.h"
#include "http.h"
#include "common.h"
#include "buffer.h"
#include "handler.h"
#include "handler_table.h"
#include "virtual_server.h"
#include "encoder_table.h"
#include "handler_table_entry.h"


typedef enum {
	socket_reading,
	socket_writing,
	socket_closed
} cherokee_socket_status_t;

typedef struct {
	int                       socket;
	struct sockaddr           addr_in;
	int                       addr_len;
	cherokee_socket_status_t  status;
	int                       is_tls;

#ifdef HAVE_TLS	
	gnutls_session session;
#endif
} cherokee_socket_t;

#define SOCKET(s)        ((cherokee_socket_t *)(s))
#define SOCKET_FD(s)     (SOCKET(s)->socket)
#define SOCKET_AF(s)     (SOCKET(s)->addr_in.sa_family)
#define SOCKET_ADDR(s)   (SOCKET(s)->addr_in)
#define SOCKET_STATUS(s) (SOCKET(s)->status)


ret_t       cherokee_socket_new        (cherokee_socket_t **socket);
ret_t       cherokee_socket_free       (cherokee_socket_t  *socket);

ret_t       cherokee_socket_init_tls   (cherokee_socket_t  *socket, cherokee_virtual_server_t *vserver);
ret_t       cherokee_socket_close      (cherokee_socket_t  *socket);
ret_t       cherokee_socket_accept     (cherokee_socket_t  *socket, int server_socket);
ret_t       cherokee_socket_write      (cherokee_socket_t  *socket, cherokee_buffer_t *buf);
ret_t       cherokee_socket_read       (cherokee_socket_t  *socket, cherokee_buffer_t *buf);

const char *cherokee_socket_ntop       (cherokee_socket_t  *socket, char*, size_t);
ret_t       cherokee_socket_set_status (cherokee_socket_t  *socket, cherokee_socket_status_t);

#endif /* __CHEROKEE_SOCKET_H__ */
