/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_MODULE_LOADER_H__
#define __CHEROKEE_MODULE_LOADER_H__

#include "common.h"
#include "module.h"
#include "table.h"
#include "handler_table.h"
#include "encoder_table.h"
#include "logger_table.h"


typedef struct {
	   cherokee_table_t *table;
} cherokee_module_loader_t;

#define MODINFO(x)   ((cherokee_module_info_t *) (x))
#define MODLOADER(x) ((cherokee_module_loader_t *) (x))

ret_t cherokee_module_loader_new  (cherokee_module_loader_t **loader);
ret_t cherokee_module_loader_free (cherokee_module_loader_t  *loader);

ret_t cherokee_module_loader_load (cherokee_module_loader_t  *loader, const char *modname);
ret_t cherokee_module_loader_get  (cherokee_module_loader_t  *loader, const char *modname, cherokee_module_info_t **info);

#endif /* __CHEROKEE_MODULE_LOADER_H__ */
