/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "handler_php4.h"
#include "connection.h"

#include "php_main.h"
#include "php_variables.h"

/*
  php-4.3.0RC4 $ ./configure --enable-embed=static
*/

static zend_module_entry php_cherokee_module = {
	STANDARD_MODULE_HEADER,
	"Cherokee",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	VERSION,
	STANDARD_MODULE_PROPERTIES
};


static int 
php_cherokee_startup (sapi_module_struct *sapi_module)
{
	if (php_module_startup(sapi_module, &php_cherokee_module, 1) == FAILURE)  {
                return FAILURE;
	}

	return SUCCESS;
}


static sapi_module_struct cherokee_sapi_module =  {
	   "cherokee", /* name */
	   "cherokee", /* pretty_name */

	   php_cherokee_startup, /* startup */
	   NULL,                 /* shout_down */

	   NULL,       /* activate */
	   NULL,       /* deactivate */

	   NULL,       /* deactivate */
	   NULL,       /* flush */
	   NULL,       /* get_stat */
	   NULL,       /* getenv */

	   NULL,       /* api_error */

	   NULL,       /* header_handler */
	   NULL,       /* send_headers */
	   NULL,       /* send_header */
	   
	   NULL,       /* read_post */
	   NULL,       /* read_cookies */

	   NULL,       /* register_server_variables */
	   NULL,       /* log_message */

/* 	   NULL,       /\* php_ini_path_override *\/ */

	   NULL,       /* block_interruptions */
	   NULL,       /* unblock_interruptions */

	   NULL,       /* default_post_reader */
	   NULL,       /* treat_data */
	   
/* 	   NULL,       /\* executable_location *\/ */
	   
	   STANDARD_SAPI_MODULE_PROPERTIES
};




ret_t 
cherokee_handler_php4_new (cherokee_handler_t **hdl, void *cnt, cherokee_table_t *properties)
{
	cherokee_handler_php4_t *n = (cherokee_handler_php4_t *)malloc(sizeof(cherokee_handler_php4_t));
	return_if_fail (n != NULL, ret_nomem);
	
	/* Init the base class object
	 */
	cherokee_handler_init_base(HANDLER(n), cnt);
	HANDLER(n)->connection  = cnt;

//	HANDLER(n)->support = hsupport_length | hsupport_range;

	HANDLER(n)->init        = (handler_func_init_t) cherokee_handler_php4_init;
	HANDLER(n)->free        = (handler_func_free_t) cherokee_handler_php4_free;
	HANDLER(n)->step        = (handler_func_step_t) cherokee_handler_php4_step;
	HANDLER(n)->add_headers = (handler_func_add_headers_t) cherokee_handler_php4_add_headers;

	*hdl = HANDLER(n);
	
	/* Init
	 */
	n->file_handle = (zend_file_handle *) malloc (sizeof(zend_file_handle));
	return_if_fail (n->file_handle != NULL, ret_nomem);

	n->global_vars = (zend_llist *) malloc (sizeof(zend_llist));
	return_if_fail (n->global_vars != NULL, ret_nomem);

	return ret_ok;
}



/* virtual methods implementation
 */
static void 
init_request_info (void)
{
	/* GET (or HEAD? or POST?, or..)  */
	sapi_globals.request_info.request_method = "GET";
	
	/* .. */
}


ret_t 
cherokee_handler_php4_init (cherokee_handler_php4_t *hdl)
{
	cherokee_connection_t *conn;

	conn = CONN(HANDLER(hdl)->connection);

	/* PHP init 
	 */

	init_request_info();

	zend_llist_init(hdl->global_vars, sizeof(char *), NULL, 0);

	hdl->file_handle->type = ZEND_HANDLE_FILENAME;
	hdl->file_handle->filename = conn->local_directory->buf;
	hdl->file_handle->free_filename = 0;
	hdl->file_handle->opened_path = NULL;

	if (php_request_startup(TSRMLS_C) == FAILURE) {
		php_module_shutdown();
		return ret_error;
	}

	return ret_ok;
}


ret_t 
cherokee_handler_php4_free (cherokee_handler_php4_t *hdl)
{
	/* PHP free
	 */
	php_request_shutdown(NULL);

	if (hdl->file_handle != NULL) {
		free (hdl->file_handle);
		hdl->file_handle = NULL;
	}

	if (hdl->global_vars != NULL) {
		free (hdl->global_vars);
		hdl->global_vars = NULL;
	}


	free (hdl);	

	return ret_ok;
}


ret_t 
cherokee_handler_php4_step (cherokee_handler_php4_t *hdl, cherokee_buffer_t *buffer)
{

}


ret_t 
cherokee_handler_php4_add_headers (cherokee_handler_php4_t *hdl, cherokee_buffer_t *buffer)
{

}



/*   Library init function
 */

static int _php4_is_init = 0;

void 
php4_init ()
{
	/* Init flag
	 */
	if (_php4_is_init) {
		return;
	}
	_php4_is_init = 1;

	sapi_startup(&cherokee_sapi_module);
	cherokee_sapi_module.startup(&cherokee_sapi_module);

	/* FIXME: what's this? 
	 */
	SG(server_context) = (void *) 1;
}
