#include <stdio.h>
#include <getopt.h>
#include <stdlib.h>

#include "module_loader.h"

static void
print_help (void)
{
	printf ("Cherokee module\n"
		   "Usage: cherokee_module [options] module\n\n"
		   "  -h,  --help                   Print this help\n"
		   "  -V,  --version                Print version and exit\n"
		   "  -t,  --type                   Print the type of module and exit\n"
		   "Report bugs to alvaro@alobbs.com\n");
}

static void
print_usage (void)
{
	   printf ("Cherokee module\n"
			 "Usage: cherokee_module [options] module\n\n"
			 "Try `cherokee_module --help' for more options.\n");
}

ret_t
print_type (const char *module)
{
	   ret_t ret;
	   cherokee_module_info_t *info;
	   CHEROKEE_NEW(loader,module_loader);

	   ret = cherokee_module_loader_load (loader, module);
	   if (ret < ret_ok) return ret;

	   ret = cherokee_module_loader_get (loader, module, &info);
	   if (ret < ret_ok) return ret;

	   switch (info->type) {
	   case cherokee_handler:
			 printf ("handler\n");
			 break;
	   case cherokee_logger:
			 printf ("logger\n");
			 break;
	   case cherokee_encoder:
			 printf ("encoder\n");
			 break;
	   case cherokee_validator:
			 printf ("validator\n");
			 break;
	   default:
			 SHOULDNT_HAPPEN;
	   }

	   return ret_ok;
}


int
main (int argc, char **argv)
{
 	   char show_type = 0;

	   struct option long_options[] = {
			 /* Options without arguments */
			 {"help",    no_argument, NULL, 'h'},
			 {"version", no_argument, NULL, 'V'},
			 {"type",    no_argument, NULL, 't'},
	   };

	   int   val;
	   char *module;

	   cherokee_module_info_t *info;
	   CHEROKEE_NEW(loader,module_loader);

	   /* Process parameters
	    */
	   while ((val = getopt_long (argc, argv, "tVh", long_options, NULL)) != -1) {
			 switch (val) {
			 case 'V':
				    printf ("Cherokee module %s\n"
						  "Written by Alvaro Lopez Ortega <alvaro@alobbs.com>\n\n"
						  "Copyright (C) 2001-2003 Alvaro Lopez Ortega.\n"
						  "This is free software; see the source for copying conditions.  There is NO\n"
						  "warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n",
						  VERSION);
				    exit(0);
				    break;
			 case 't':
				    show_type = 1;
				    break;
			 case 'h':
			 case '?':
			 default:
				    print_help();
				    exit(0);
				    break;
			 }
	   }
			   
	   if (optind >= argc) {
			 print_usage();
			 exit(0);
	   }
	   module = argv[optind];


	   if (show_type) {
			 print_type (module);
	   }

	   return 0;
}
