#include <stdio.h>
#include "common.h"
#include "buffer.h"

int
main (int argc, char **argv)
{
	   cherokee_buffer_t *buffer, *buffer2;

	   if (argc < 2) {
			 PRINT_ERROR ("%s \"Base64 encoded string\"\n", argv[0]);
			 exit(1);
	   }

	   cherokee_buffer_new (&buffer);
	   cherokee_buffer_new (&buffer2);

	   cherokee_buffer_add_va (buffer, "%s", argv[1]);
	   cherokee_buffer_add_va (buffer2, "%s", argv[1]);

	   cherokee_buffer_decode_base64 (buffer);
	   printf ("base64: %s\n", buffer->buf);

	   cherokee_buffer_encode_md5 (buffer2);
	   printf ("md5: %s\n", buffer2->buf);

	   cherokee_buffer_free (buffer);
	   cherokee_buffer_free (buffer2);

	   return 0;
}
