/* A Bison parser, made by GNU Bison 1.875a.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     T_QUOTE = 258,
     T_DENY = 259,
     T_THREAD_NUM = 260,
     T_SSL_CERT_KEY_FILE = 261,
     T_SSL_CERT_FILE = 262,
     T_KEEPALIVE_MAX_REQUESTS = 263,
     T_ERROR_DOCUMENT = 264,
     T_TIMEOUT = 265,
     T_KEEPALIVE = 266,
     T_DOCUMENT_ROOT = 267,
     T_LOG = 268,
     T_MIME_FILE = 269,
     T_DIRECTORY = 270,
     T_HANDLER = 271,
     T_USER = 272,
     T_GROUP = 273,
     T_SERVER = 274,
     T_USERDIR = 275,
     T_URL = 276,
     T_PIDFILE = 277,
     T_LISTEN = 278,
     T_FILEDIR = 279,
     T_HIDE_VERSION = 280,
     T_HIDE_SERVER_NAME = 281,
     T_ENCODER = 282,
     T_ALLOW = 283,
     T_BGCOLOR = 284,
     T_TEXT = 285,
     T_LINK = 286,
     T_ALINK = 287,
     T_VLINK = 288,
     T_BACKGROUND = 289,
     T_DIRECTORYINDEX = 290,
     T_IPV6 = 291,
     T_SHOW = 292,
     T_CHROOT = 293,
     T_HEADER_FILE = 294,
     T_NUMBER = 295,
     T_PORT = 296,
     T_QSTRING = 297,
     T_FULLDIR = 298,
     T_ID = 299,
     T_HTTP_URL = 300,
     T_HOSTNAME = 301,
     T_IP = 302
   };
#endif
#define T_QUOTE 258
#define T_DENY 259
#define T_THREAD_NUM 260
#define T_SSL_CERT_KEY_FILE 261
#define T_SSL_CERT_FILE 262
#define T_KEEPALIVE_MAX_REQUESTS 263
#define T_ERROR_DOCUMENT 264
#define T_TIMEOUT 265
#define T_KEEPALIVE 266
#define T_DOCUMENT_ROOT 267
#define T_LOG 268
#define T_MIME_FILE 269
#define T_DIRECTORY 270
#define T_HANDLER 271
#define T_USER 272
#define T_GROUP 273
#define T_SERVER 274
#define T_USERDIR 275
#define T_URL 276
#define T_PIDFILE 277
#define T_LISTEN 278
#define T_FILEDIR 279
#define T_HIDE_VERSION 280
#define T_HIDE_SERVER_NAME 281
#define T_ENCODER 282
#define T_ALLOW 283
#define T_BGCOLOR 284
#define T_TEXT 285
#define T_LINK 286
#define T_ALINK 287
#define T_VLINK 288
#define T_BACKGROUND 289
#define T_DIRECTORYINDEX 290
#define T_IPV6 291
#define T_SHOW 292
#define T_CHROOT 293
#define T_HEADER_FILE 294
#define T_NUMBER 295
#define T_PORT 296
#define T_QSTRING 297
#define T_FULLDIR 298
#define T_ID 299
#define T_HTTP_URL 300
#define T_HOSTNAME 301
#define T_IP 302




/* Copy the first part of user declarations.  */
#line 1 "read_config_grammar.y"

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <pwd.h>
#include <grp.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>

#include "mime.h"
#include "common.h"
#include "server.h"
#include "table.h"
#include "virtual_server.h"
#include "handler_table_entry.h"
#include "encoder.h"
#include "logger_table.h"


/* Define the parameter name of the yyparse() argument
 */
#define YYPARSE_PARAM server



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 48 "read_config_grammar.y"
typedef union YYSTYPE {
	   int   number;
	   char *string;
	   void *ptr;

	   struct {
			 char *name;
			 void *ptr;
	   } name_ptr;

	   void *id_list;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 229 "read_config_grammar.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 62 "read_config_grammar.y"

/* What is the right way to import this prototipe?
 */
extern int yylex(void);


extern char *yytext;
extern int   yylineno;

cherokee_virtual_server_t      *current_virtual_server      = NULL;
cherokee_handler_table_entry_t *current_handler_table_entry = NULL;
cherokee_encoder_table_entry_t *current_encoder_entry       = NULL;
cherokee_module_info_t         *current_module_info         = NULL;
list_t                         *current_list                = NULL;

struct {
	   char                          *handler_name;
	   cherokee_handler_table_entry_t *entry;
	   cherokee_virtual_server_t     *vserver;
	   char                          *document_root;
	   char                          *directory_name;
} directory_content_tmp;

typedef struct {
	   void *next;
	   char *string;
} linked_list_t;


#define auto_virtual_server ((current_virtual_server) ? current_virtual_server : SRV(server)->vserver_default)


static void
free_linked_list (linked_list_t *list, void (*free_func) (void *))
{
	   linked_list_t *i = list;

	   while (i != NULL) {
			 linked_list_t *prev = i;

			 if ((free_func) && (i->string)) {
				    free_func (i->string);
			 }

			 prev = i;
			 i = i->next;
			 free (prev);
	   }	   
}

static char *
make_finish_with_slash (char *string, int *len)
{
	   char *new;

	   if (string[(*len)-1] == '/') {
			 return string;
	   }

	   new = (char*) malloc ((*len)+2);
	   memcpy (new, string, *len);
	   new[(*len)] = '/';
	   new[(*len)+1] = '\0';
	   free (string);

	   (*len)++;

	   return new;
}


cherokee_handler_table_entry_t *
handler_table_entry_new (void)
{
	   cherokee_handler_table_entry_t *entry;

	   cherokee_handler_table_entry_new (&entry);
	   current_handler_table_entry = entry;

	   return entry;
}


char *
new_string_to_lowercase (const char *in)
{
	   int   i;
	   char *tmp;
	   
	   i = strlen(in);
	   tmp = (char *) malloc (i+1);
	   tmp[i] = '\0';

	   while (i--) {
			 tmp[i] = tolower(in[i]);
	   }

	   return tmp;
}


void
yyerror(char* msg)
{
        PRINT_ERROR ("Error parsing configuration: '%s', line %d, symbol '%s'\n", 
				 msg, yylineno, yytext);
}



/* Line 214 of yacc.c.  */
#line 350 "read_config_grammar.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  85
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   112

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  51
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  49
/* YYNRULES -- Number of rules. */
#define YYNRULES  97
/* YYNRULES -- Number of states. */
#define YYNSTATES  149

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   302

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    48,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    49,     2,    50,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     4,     6,     8,    11,    13,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    73,    76,    77,
      80,    81,    84,    86,    90,    93,    96,    99,   100,   105,
     106,   110,   111,   114,   117,   120,   123,   126,   129,   132,
     135,   138,   141,   144,   145,   152,   155,   158,   161,   164,
     167,   170,   173,   176,   179,   182,   188,   191,   194,   197,
     200,   203,   206,   209,   212,   215,   218,   220,   222,   223,
     230,   231,   238,   240,   243,   249,   252,   256
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      52,     0,    -1,    -1,    53,    -1,    55,    -1,    53,    55,
      -1,    57,    -1,    54,    57,    -1,    57,    -1,    56,    -1,
      92,    -1,    62,    -1,    63,    -1,    70,    -1,    71,    -1,
      72,    -1,    73,    -1,    74,    -1,    75,    -1,    81,    -1,
      85,    -1,    86,    -1,    87,    -1,    88,    -1,    97,    -1,
      82,    -1,    83,    -1,    84,    -1,    98,    -1,    99,    -1,
      94,    -1,    64,    -1,    65,    -1,    78,    -1,    76,    -1,
      77,    -1,    -1,    58,    90,    -1,    -1,    59,    96,    -1,
      -1,    60,    80,    -1,    44,    -1,    44,    48,    61,    -1,
      41,    40,    -1,    23,    91,    -1,    12,    43,    -1,    -1,
      13,    44,    66,    67,    -1,    -1,    49,    68,    50,    -1,
      -1,    68,    69,    -1,    44,    43,    -1,    25,    40,    -1,
      26,    40,    -1,    14,    43,    -1,    10,    40,    -1,    11,
      40,    -1,     8,    40,    -1,     7,    43,    -1,     6,    43,
      -1,    27,    44,    -1,    -1,    27,    44,    49,    79,    60,
      50,    -1,    28,    61,    -1,     4,    61,    -1,    22,    43,
      -1,    38,    43,    -1,     5,    40,    -1,    36,    40,    -1,
      17,    44,    -1,    17,    40,    -1,    18,    44,    -1,    18,
      40,    -1,    16,    44,    49,    58,    50,    -1,    16,    44,
      -1,    21,    45,    -1,    24,    43,    -1,    29,    44,    -1,
      30,    44,    -1,    31,    44,    -1,    33,    44,    -1,    32,
      44,    -1,    39,    44,    -1,    37,    61,    -1,    44,    -1,
      47,    -1,    -1,    19,    91,    49,    93,    54,    50,    -1,
      -1,    15,    43,    49,    95,    59,    50,    -1,    89,    -1,
      12,    43,    -1,    20,    44,    49,    89,    50,    -1,    35,
      61,    -1,     9,    40,    43,    -1,     9,    40,    45,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   189,   189,   190,   193,   194,   197,   198,   201,   202,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     227,   228,   229,   230,   231,   232,   235,   236,   239,   240,
     243,   244,   247,   256,   266,   271,   276,   291,   290,   309,
     310,   312,   313,   316,   329,   334,   339,   347,   352,   357,
     362,   380,   414,   420,   419,   444,   465,   486,   503,   508,
     513,   518,   533,   538,   553,   558,   564,   571,   576,   581,
     584,   587,   590,   593,   596,   600,   629,   630,   636,   635,
     650,   649,   717,   723,   735,   760,   772,   784
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "T_QUOTE", "T_DENY", "T_THREAD_NUM", 
  "T_SSL_CERT_KEY_FILE", "T_SSL_CERT_FILE", "T_KEEPALIVE_MAX_REQUESTS", 
  "T_ERROR_DOCUMENT", "T_TIMEOUT", "T_KEEPALIVE", "T_DOCUMENT_ROOT", 
  "T_LOG", "T_MIME_FILE", "T_DIRECTORY", "T_HANDLER", "T_USER", "T_GROUP", 
  "T_SERVER", "T_USERDIR", "T_URL", "T_PIDFILE", "T_LISTEN", "T_FILEDIR", 
  "T_HIDE_VERSION", "T_HIDE_SERVER_NAME", "T_ENCODER", "T_ALLOW", 
  "T_BGCOLOR", "T_TEXT", "T_LINK", "T_ALINK", "T_VLINK", "T_BACKGROUND", 
  "T_DIRECTORYINDEX", "T_IPV6", "T_SHOW", "T_CHROOT", "T_HEADER_FILE", 
  "T_NUMBER", "T_PORT", "T_QSTRING", "T_FULLDIR", "T_ID", "T_HTTP_URL", 
  "T_HOSTNAME", "T_IP", "','", "'{'", "'}'", "$accept", "conffile", 
  "lines", "server_lines", "line", "common_line", "server_line", 
  "handler_options", "directory_options", "encoder_options", "id_list", 
  "port", "listen", "document_root", "log", "@1", "log_optional", 
  "tuple_list", "tuple", "hideversion", "hideservername", "mime", 
  "timeout", "keepalive", "keepalive_max_requests", "ssl_file", 
  "ssl_key_file", "encoder", "@2", "encoder_option", "pidfile", "chroot", 
  "thread_number", "ipv6", "user1", "user2", "group1", "group2", 
  "handler", "handler_option", "host_name", "server", "@3", "directory", 
  "@4", "directory_option", "userdir", "directoryindex", "errordocument", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,    44,   123,
     125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    51,    52,    52,    53,    53,    54,    54,    55,    55,
      56,    56,    56,    56,    56,    56,    56,    56,    56,    56,
      56,    56,    56,    56,    56,    56,    56,    56,    56,    56,
      57,    57,    57,    57,    57,    57,    58,    58,    59,    59,
      60,    60,    61,    61,    62,    63,    64,    66,    65,    67,
      67,    68,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    78,    80,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    89,    90,    90,    90,
      90,    90,    90,    90,    90,    90,    91,    91,    93,    92,
      95,    94,    96,    96,    97,    98,    99,    99
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     1,     1,     2,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     2,     0,     2,
       0,     2,     1,     3,     2,     2,     2,     0,     4,     0,
       3,     0,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     0,     6,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     5,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     1,     0,     6,
       0,     6,     1,     2,     5,     2,     3,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     3,     4,     9,     8,
      11,    12,    31,    32,    13,    14,    15,    16,    17,    18,
      34,    35,    33,    19,    25,    26,    27,    20,    21,    22,
      23,    10,    30,    24,    28,    29,    69,    61,    60,    59,
       0,    57,    58,    46,    47,    56,     0,    72,    71,    74,
      73,    86,    87,     0,     0,    67,    45,    54,    55,    62,
      42,    95,    70,    68,    44,     1,     5,    96,    97,    49,
      90,    88,     0,    63,     0,    51,    48,    38,     0,     0,
       0,    40,    43,     0,     0,     0,     6,    76,    94,     0,
       0,    50,    52,     0,    91,    92,    39,    89,     7,    36,
       0,     0,    64,    41,    53,    93,     0,    66,    65,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    75,    37,
      77,    78,    79,    80,    81,    83,    82,    85,    84
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,    25,    26,   105,    27,    28,    29,   126,   104,   109,
      81,    30,    31,    32,    33,    89,    96,   103,   112,    34,
      35,    36,    37,    38,    39,    40,    41,    42,   101,   123,
      43,    44,    45,    46,    47,    48,    49,    50,   100,   139,
      73,    51,    98,    52,    97,   116,    53,    54,    55
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -93
static const yysigned_char yypact[] =
{
      45,   -37,   -39,   -15,    -6,     0,     1,     2,     5,    -9,
      18,    23,   -14,    -7,    -8,    25,    30,    -8,     3,     4,
      31,    32,    34,    39,    37,    88,    45,   -93,   -93,   -93,
     -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,
     -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,
     -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,
     -29,   -93,   -93,   -93,   -93,   -93,    40,   -93,   -93,   -93,
     -93,   -93,   -93,    41,    42,   -93,   -93,   -93,   -93,    43,
      46,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,    44,
     -93,   -93,    79,   -93,    32,   -93,   -93,   -93,    72,    52,
      47,   -93,   -93,   -21,    -1,    -5,   -93,    49,   -93,    -4,
      57,   -93,   -93,    58,   -93,   -93,   -93,   -93,   -93,   -93,
      32,    32,   -93,   -93,   -93,   -93,   -12,   -93,   -93,    59,
      60,    61,    62,    63,    64,    65,    32,    66,   -93,   -93,
     -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -93,   -93,   -93,   -93,    76,   -93,   -92,   -93,   -93,   -93,
     -89,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,
     -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,
     -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93,     7,   -93,
      95,   -93,   -93,   -93,   -93,   -93,   -93,   -93,   -93
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
     120,     2,     3,    56,    57,   102,   106,     8,     9,   129,
      11,   113,   130,   118,    87,    99,    88,   131,   132,   133,
     134,   135,    20,   110,   121,   136,    67,   137,    58,   111,
      68,   127,   128,    69,    59,    64,    71,    70,   138,    72,
      60,    61,    62,    77,    78,   117,   122,   147,    63,   114,
       1,     2,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    65,    12,    13,    14,    15,    66,    16,    17,    74,
      18,    19,    20,    75,    82,    79,    80,    84,     2,     3,
      21,    22,    83,    23,     8,     9,    24,    11,    85,    90,
      91,    92,    93,    95,    94,    99,   107,   108,   119,    20,
     124,   125,    86,   141,   140,   142,   143,   144,   145,   146,
     148,   115,    76
};

static const unsigned char yycheck[] =
{
       4,     6,     7,    40,    43,    94,    98,    12,    13,    21,
      15,    12,    24,   105,    43,    16,    45,    29,    30,    31,
      32,    33,    27,    44,    28,    37,    40,    39,    43,    50,
      44,   120,   121,    40,    40,    44,    44,    44,    50,    47,
      40,    40,    40,    40,    40,    50,    50,   136,    43,    50,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    43,    17,    18,    19,    20,    43,    22,    23,    44,
      25,    26,    27,    43,    40,    44,    44,    40,     6,     7,
      35,    36,    43,    38,    12,    13,    41,    15,     0,    49,
      49,    49,    49,    49,    48,    16,    44,    50,    49,    27,
      43,    43,    26,    43,    45,    44,    44,    44,    44,    44,
      44,   104,    17
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    17,    18,    19,    20,    22,    23,    25,    26,
      27,    35,    36,    38,    41,    52,    53,    55,    56,    57,
      62,    63,    64,    65,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    81,    82,    83,    84,    85,    86,    87,
      88,    92,    94,    97,    98,    99,    40,    43,    43,    40,
      40,    40,    40,    43,    44,    43,    43,    40,    44,    40,
      44,    44,    47,    91,    44,    43,    91,    40,    40,    44,
      44,    61,    40,    43,    40,     0,    55,    43,    45,    66,
      49,    49,    49,    49,    48,    49,    67,    95,    93,    16,
      89,    79,    61,    68,    59,    54,    57,    44,    50,    60,
      44,    50,    69,    12,    50,    89,    96,    50,    57,    49,
       4,    28,    50,    80,    43,    43,    58,    61,    61,    21,
      24,    29,    30,    31,    32,    33,    37,    39,    50,    90,
      45,    43,    44,    44,    44,    44,    44,    61,    44
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 42:
#line 248 "read_config_grammar.y"
    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;

	   yyval.id_list = n;
}
    break;

  case 43:
#line 257 "read_config_grammar.y"
    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));

	   n->next = yyvsp[0].id_list;
	   n->string = yyvsp[-2].string;

	   yyval.id_list = n;
}
    break;

  case 44:
#line 267 "read_config_grammar.y"
    {
	   SRV(server)->port = yyvsp[0].number;
}
    break;

  case 45:
#line 272 "read_config_grammar.y"
    {
	   SRV(server)->listen_to = yyvsp[0].string;
}
    break;

  case 46:
#line 277 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vserver;

	   vserver = auto_virtual_server;
	   vserver->root = yyvsp[0].string;
	   vserver->root_len = strlen (yyvsp[0].string);

	   /* Check for the endding slash
	    */
	   vserver->root = make_finish_with_slash (vserver->root, &(vserver->root_len));
}
    break;

  case 47:
#line 291 "read_config_grammar.y"
    {
	   /* Maybe load the module
	    */
	   cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[0].string, &current_module_info);
}
    break;

  case 48:
#line 298 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   /* Instance the logger object
	    */
	   cherokee_logger_table_new_logger (SRV(server)->loggers, yyvsp[-2].string, current_module_info,
								  vserver->logger_props, &vserver->logger);
	   current_module_info = NULL;
}
    break;

  case 53:
#line 317 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   if (vserver->logger_props == NULL) {
			 cherokee_table_new (&vserver->logger_props);
	   }

	   cherokee_table_add (vserver->logger_props, yyvsp[-1].string, yyvsp[0].string);
}
    break;

  case 54:
#line 330 "read_config_grammar.y"
    {
	   SRV(server)->hideversion = yyvsp[0].number;
}
    break;

  case 55:
#line 335 "read_config_grammar.y"
    {
	   SRV(server)->hideservername = yyvsp[0].number;
}
    break;

  case 56:
#line 340 "read_config_grammar.y"
    {
	   cherokee_mime_t *mime;

	   cherokee_mime_init_with_file (&mime, (char *)yyvsp[0].string);
	   free (yyvsp[0].string);
}
    break;

  case 57:
#line 348 "read_config_grammar.y"
    {
	   SRV(server)->timeout = yyvsp[0].number;
}
    break;

  case 58:
#line 353 "read_config_grammar.y"
    {
	   SRV(server)->keepalive = yyvsp[0].number;
}
    break;

  case 59:
#line 358 "read_config_grammar.y"
    {
	   SRV(server)->keepalive_max = yyvsp[0].number;
}
    break;

  case 60:
#line 363 "read_config_grammar.y"
    {
#ifdef HAVE_LIBGNUTLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_cert != NULL) {
			 fprintf (stderr, "T_SSL_CERT_FILE overlap: '%s' <- '%s'\n", vsrv->server_cert, yyvsp[0].string);
			 free (vsrv->server_cert);
	   }

	   vsrv->server_cert = yyvsp[0].string;

#else
	   PRINT_ERROR ("Ignoring SSL configuration entry: T_SSL_CERT\n");
	   return 1;
#endif
}
    break;

  case 61:
#line 381 "read_config_grammar.y"
    {
#ifdef HAVE_LIBGNUTLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_key != NULL) {
			 fprintf (stderr, "T_SSL_CERT_KEY_FILE overlap: '%s' <- '%s'\n", vsrv->server_key, yyvsp[0].string);
			 free (vsrv->server_key);
	   }

	   vsrv->server_key = yyvsp[0].string;

#else
	   PRINT_ERROR ("Ignoring SSL configuration entry: T_SSL_KEY_CERT\n");
	   return 1;
#endif
}
    break;

  case 62:
#line 415 "read_config_grammar.y"
    {
	   cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
}
    break;

  case 63:
#line 420 "read_config_grammar.y"
    {
	   cherokee_module_info_t *info;
	   cherokee_encoder_table_entry_t *enc;

	   /* Load the module
	    */
	   cherokee_module_loader_load (SRV(server)->loader, yyvsp[-1].string);
	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[-1].string, &info);

	   /* Set the info in the new entry
	    */
	   cherokee_encoder_table_entry_new (&enc);
	   cherokee_encoder_table_entry_get_info (enc, info);

	   /* Set in the encoders table
	    */
	   cherokee_encoder_table_set (SRV(server)->encoders, yyvsp[-1].string, enc);
	   current_encoder_entry = enc;
}
    break;

  case 64:
#line 440 "read_config_grammar.y"
    {
	   current_encoder_entry = NULL;
}
    break;

  case 65:
#line 445 "read_config_grammar.y"
    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = yyvsp[0].id_list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_allow (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 66:
#line 466 "read_config_grammar.y"
    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = yyvsp[0].id_list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_deny (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 67:
#line 487 "read_config_grammar.y"
    {
	   FILE *file;

	   file = fopen (yyvsp[0].string, "w");
	   if (file == NULL) {
			 PRINT_ERROR ("Can't write PID file '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   snprintf (gbl_buffer, gbl_buffer_size, "%d\n", getpid());
	   fwrite (gbl_buffer, 1, strlen(gbl_buffer), file);
	   fclose (file);

	   free (yyvsp[0].string);
}
    break;

  case 68:
#line 504 "read_config_grammar.y"
    {
	   SRV(server)->chroot = yyvsp[0].string;
}
    break;

  case 69:
#line 509 "read_config_grammar.y"
    {
	   SRV(server)->ncpus = yyvsp[0].number;
}
    break;

  case 70:
#line 514 "read_config_grammar.y"
    {
	   SRV(server)->ipv6 = yyvsp[0].number;
}
    break;

  case 71:
#line 519 "read_config_grammar.y"
    {
	   struct passwd *pwd;
	   
	   pwd = (struct passwd *) getpwnam (yyvsp[0].string);
	   if (pwd == NULL) {
			 PRINT_ERROR ("User '%s' not found in the system", yyvsp[0].string);
			 return 1;
	   }

	   SRV(server)->user = pwd->pw_uid;

	   free (yyvsp[0].string);
}
    break;

  case 72:
#line 534 "read_config_grammar.y"
    {
	   SRV(server)->user = yyvsp[0].number;
}
    break;

  case 73:
#line 539 "read_config_grammar.y"
    {
	   struct group *grp;

	   grp = (struct group *) getgrnam (yyvsp[0].string);
	   if (grp == NULL) {
			 PRINT_ERROR ("Group '%s' not found in the system", yyvsp[0].string);
			 return 1;
	   }

	   SRV(server)->group = grp->gr_gid;

	   free (yyvsp[0].string);
}
    break;

  case 74:
#line 554 "read_config_grammar.y"
    {
	   SRV(server)->group = yyvsp[0].number;
}
    break;

  case 75:
#line 559 "read_config_grammar.y"
    {
	   yyval.name_ptr.name = yyvsp[-3].string;
	   yyval.name_ptr.ptr = current_handler_table_entry;
}
    break;

  case 76:
#line 565 "read_config_grammar.y"
    {
	   yyval.name_ptr.name = yyvsp[0].string;
	   yyval.name_ptr.ptr = current_handler_table_entry;
}
    break;

  case 77:
#line 572 "read_config_grammar.y"
    {
	   cherokee_handler_table_entry_set (current_handler_table_entry, "url", yyvsp[0].string);
}
    break;

  case 78:
#line 577 "read_config_grammar.y"
    {
	   cherokee_handler_table_entry_set (current_handler_table_entry, "filedir", yyvsp[0].string);
}
    break;

  case 79:
#line 582 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "bgcolor", yyvsp[0].string); }
    break;

  case 80:
#line 585 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "text", yyvsp[0].string); }
    break;

  case 81:
#line 588 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "link", yyvsp[0].string); }
    break;

  case 82:
#line 591 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "vlink", yyvsp[0].string); }
    break;

  case 83:
#line 594 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "alink", yyvsp[0].string); }
    break;

  case 84:
#line 597 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "headerfile", yyvsp[0].string); }
    break;

  case 85:
#line 601 "read_config_grammar.y"
    {
	   linked_list_t *i;

	   i = yyvsp[0].id_list;
	   while (i != NULL) {
			 if ((!strncasecmp (i->string, "date",  4)) ||
				(!strncasecmp (i->string, "size",  4)) ||
				(!strncasecmp (i->string, "group", 5)) ||
				(!strncasecmp (i->string, "owner", 5)))
			 {
				    char *lower;

				    lower = new_string_to_lowercase (i->string);
				    free (i->string);
				    i->string = lower;

				    cherokee_handler_table_entry_set (current_handler_table_entry, i->string, i->string);				    
			 } else {
				    PRINT_ERROR ("Unknown parameter '%s' for \"Show\"", i->string);
			 }
				
			 i = i->next;
	   }

	   free_linked_list (yyvsp[0].id_list, free);
}
    break;

  case 87:
#line 631 "read_config_grammar.y"
    {
	   yyval.string = yyvsp[0].string;
}
    break;

  case 88:
#line 636 "read_config_grammar.y"
    {
	   CHEROKEE_NEW(vsrv, virtual_server);
	   current_virtual_server = vsrv;

	   vsrv->domain = yyvsp[-1].string;
	   cherokee_table_add (SRV(server)->vservers, yyvsp[-1].string, vsrv);

}
    break;

  case 89:
#line 643 "read_config_grammar.y"
    {

	   current_virtual_server = NULL;
}
    break;

  case 90:
#line 650 "read_config_grammar.y"
    {
	   int name_len;

	   name_len = strlen(yyvsp[-1].string);

	   /* Fill the tmp struct
	    */
	   directory_content_tmp.vserver        = auto_virtual_server;
	   directory_content_tmp.entry          = handler_table_entry_new ();       /* new! */
	   directory_content_tmp.directory_name = make_finish_with_slash (yyvsp[-1].string, &name_len);
	   directory_content_tmp.handler_name   = NULL;
	   directory_content_tmp.document_root  = NULL;
}
    break;

  case 91:
#line 664 "read_config_grammar.y"
    {
	   /* Basic checks
	    */
	   if (directory_content_tmp.handler_name == NULL) {
			 PRINT_ERROR ("Directory %s needs a handler; this directory entry is ignored.\n", directory_content_tmp.directory_name);
			 goto out;
	   }

	   /* Set the document_root in the entry
	    */
	   if (directory_content_tmp.document_root != NULL) {
			 cherokee_buffer_make_empty(directory_content_tmp.entry->document_root);
			 cherokee_buffer_add (directory_content_tmp.entry->document_root,
							  directory_content_tmp.document_root,
							  strlen (directory_content_tmp.document_root));
	   }

	   /* Load the module 
	    */
	   {
			 cherokee_module_info_t *info;

			 cherokee_module_loader_load (SRV(server)->loader, directory_content_tmp.handler_name);
			 cherokee_module_loader_get  (SRV(server)->loader, directory_content_tmp.handler_name, &info);

			 cherokee_handler_table_enty_get_info (directory_content_tmp.entry, info);
			 cherokee_handler_table_add (directory_content_tmp.vserver->plugins,
								    directory_content_tmp.handler_name, 
								    directory_content_tmp.entry);
	   }

	   /* Add to the virtual server "web_dir -> entry" table
	    */
 	   cherokee_virtual_server_set (directory_content_tmp.vserver, 
							  directory_content_tmp.directory_name, 
							  directory_content_tmp.handler_name,
							  directory_content_tmp.entry);

	   /* Clean
	    */
out:
	   if (directory_content_tmp.document_root != NULL) {
			 free (directory_content_tmp.document_root);
			 directory_content_tmp.document_root = NULL;
	   }
	   directory_content_tmp.vserver       = NULL;
	   directory_content_tmp.entry         = NULL;
	   directory_content_tmp.handler_name  = NULL;

	   current_handler_table_entry = NULL;
}
    break;

  case 92:
#line 718 "read_config_grammar.y"
    {	   
	   directory_content_tmp.handler_name = yyvsp[0].name_ptr.name;
}
    break;

  case 93:
#line 724 "read_config_grammar.y"
    {
	   int len;
	   char *new_fdir;

	   len = strlen(yyvsp[0].string);
	   new_fdir = make_finish_with_slash (yyvsp[0].string, &len);

	   directory_content_tmp.document_root = new_fdir;
}
    break;

  case 94:
#line 736 "read_config_grammar.y"
    {
	   int len;
	   cherokee_module_info_t         *info;
	   cherokee_handler_table_entry_t *dir;

	   /* Set the users public directory
	    */
	   len = strlen(yyvsp[-3].string);
	   SRV(server)->userdir = make_finish_with_slash (yyvsp[-3].string, &len);

	   /* Build the handler
	    */
	   dir = handler_table_entry_new ();

	   cherokee_module_loader_load (SRV(server)->loader, yyvsp[-1].name_ptr.name);
	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[-1].name_ptr.name, &info);

	   cherokee_handler_table_enty_get_info (dir, info);
	   SRV(server)->userdir_handler = dir;

	   free (yyvsp[-1].name_ptr.name);
}
    break;

  case 95:
#line 761 "read_config_grammar.y"
    {
	   linked_list_t *i = yyvsp[0].id_list;

	   while (i != NULL) {
			 cherokee_list_add (&SRV(server)->index_list, i->string);
			 i = i->next;
	   }

	   free_linked_list (yyvsp[0].id_list, NULL);
}
    break;

  case 96:
#line 773 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;
	   
	   if ((yyvsp[-1].number < 400) || (yyvsp[-1].number > 417))
	   {
			 PRINT_ERROR ("Error: Ignoring incorrect error code. Valid: 400..417. '%s'\n", yyvsp[0].string);
	   }

	   vsrv->error_document400[yyvsp[-1].number-400].file = yyvsp[0].string;
}
    break;

  case 97:
#line 785 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;
	   
	   if ((yyvsp[-1].number < 400) || (yyvsp[-1].number > 417))
	   {
			 PRINT_ERROR ("Error: Ignoring incorrect error code. Valid: 400..417. '%s'\n", yyvsp[0].string);
	   }

	   vsrv->error_document400[yyvsp[-1].number-400].url = yyvsp[0].string;
}
    break;


    }

/* Line 999 of yacc.c.  */
#line 1994 "read_config_grammar.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 796 "read_config_grammar.y"



