/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_MACHING_LIST_H__
#define __CHEROKEE_MACHING_LIST_H__

#include "common.h"
#include "list.h"


typedef enum {
	   default_allow,
	   default_deny,
	   deny_allow,
	   allow_deny
} cherokee_matching_t;


typedef struct {
	   struct list_head   list;
	   char              *string;
} cherokee_matching_list_entry_t;


typedef struct {

	   /* Lists
	    */
	   list_t list_allow;
	   list_t list_deny;

	   cherokee_matching_t type;

} cherokee_matching_list_t;

#define MLIST(x)       ((cherokee_matching_list_t *)(x))
#define MLIST_ENTRY(x) ((cherokee_matching_list_entry_t *)(x))


ret_t cherokee_matching_list_new       (cherokee_matching_list_t **mlist);
ret_t cherokee_matching_list_free      (cherokee_matching_list_t  *mlist);

ret_t cherokee_matching_list_add_allow (cherokee_matching_list_t *mlist, const char *item);
ret_t cherokee_matching_list_add_deny  (cherokee_matching_list_t *mlist, const char *item);

ret_t cherokee_matching_list_set_type  (cherokee_matching_list_t *mlist, cherokee_matching_t type);
int   cherokee_matching_list_match     (cherokee_matching_list_t *mlist, char *match);

#endif /* __CHEROKEE_MACHING_LIST_H__ */
