/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <signal.h>
#include <getopt.h>

#include "server.c"

cherokee_server_t *srv         = NULL;
char              *config_file = CHEROKEE_CONFDIR"/cherokee.conf";


static void
restart_server (int code)
{	
	cherokee_server_handle_HUP (srv);
	printf ("Cherokee reloaded\n");
}

static void
process_parameters (int argc, char **argv)
{
	int c;

	while ((c = getopt(argc, argv, "C:")) != -1) {
		switch(c) {
		case 'C':
			config_file = strdup(optarg);
			break;

		default:
			fprintf (stderr, "Usage: %s [-C configfile]\n");
			exit(1);
		}
	}
}


int
main (int argc, char **argv)
{
	ret_t ret;
	
	ret = cherokee_server_new (&srv);
	if (ret != ret_ok) return 1;
	
	process_parameters (argc, argv);

	ret = cherokee_server_read_config_file (srv, config_file);
	if (ret != ret_ok) return 2;
	
	signal (SIGPIPE, SIG_IGN);
	signal (SIGHUP, restart_server);
	
	ret = cherokee_server_init (srv);
	if (ret != ret_ok) return 3;

	for (;;) {
		cherokee_server_step(srv);
	}
	
	cherokee_server_free (srv);

	return 0;
}
