/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common.h"
#include "plugin_table_entry.h"


ret_t 
cherokee_plugin_table_entry_new (cherokee_plugin_table_entry_t **entry)
{
	CHEROKEE_NEW_STRUCT (n, plugin_table_entry);
	
	n->properties       = NULL;
	n->handler_new_func = NULL;
	
	cherokee_buffer_new (&n->document_root);
	
	*entry = n;
	
	return ret_ok;
}


ret_t 
cherokee_plugin_table_entry_free (cherokee_plugin_table_entry_t *entry) 
{
	if (entry->properties) {
		cherokee_table_free (entry->properties);
		entry->properties = NULL;
	}
	
	cherokee_buffer_free (entry->document_root);

	free (entry);
	
	return ret_ok;
}


ret_t 
cherokee_plugin_table_entry_set (cherokee_plugin_table_entry_t *entry, char *prop_name, char *prop_value)
{
	   ret_t ret;

	   /* Create the table on demand to save memory
	    */
	   if (entry->properties == NULL) {
		   ret = cherokee_table_new (&entry->properties);
		   if (ret != ret_ok) return ret;
	   }

	   /* Add the property
	    */
	   return cherokee_table_add (entry->properties, prop_name, prop_value);
}
