/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * This piece of code by:
 *      Miguel Angel Ajo Pelayo <ajo@godsmaze.org>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_LOGGER_H__
#define __CHEROKEE_LOGGER_H__

#include "common.h"
#include "buffer.h"
#include "table.h"
#include "http.h"


/* Callback function definitions
 */
typedef ret_t (* logger_func_new_t)          (void **logger, cherokee_table_t *properties);
typedef ret_t (* logger_func_init_t)         (void  *logger);
typedef ret_t (* logger_func_free_t)         (void  *logger);
typedef ret_t (* logger_func_write_access_t) (void  *logger, void *conn);
typedef ret_t (* logger_func_write_error_t)  (void  *logger, const char *format, ...);
typedef ret_t (* logger_func_write_string_t) (void  *logger, const char *format, ...);


typedef struct {

	/* Pure virtual methods
	 */
	logger_func_init_t         init;
	logger_func_free_t         free;
	logger_func_write_access_t write_access;
	logger_func_write_error_t  write_error;
	logger_func_write_error_t  write_string;
	   
} cherokee_logger_t;

#define LOGGER(x)       ((cherokee_logger_t *)(x))

ret_t cherokee_logger_init_base    (cherokee_logger_t *logger);

ret_t cherokee_logger_init         (cherokee_logger_t *logger);
ret_t cherokee_logger_free         (cherokee_logger_t *logger);
ret_t cherokee_logger_write_access (cherokee_logger_t *logger, void *conn);
ret_t cherokee_logger_write_error  (cherokee_logger_t *logger, const char *format, ...);
ret_t cherokee_logger_write_string (cherokee_logger_t *logger, const char *format, ...);


#endif /* __CHEROKEE_LOGGER_H__ */
