/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * This piece of code by:
 *      Miguel Angel Ajo Pelayo <ajo@godsmaze.org>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <stdlib.h>
#include <string.h>

#include "logger.h"


ret_t
cherokee_logger_init_base (cherokee_logger_t *logger)
{
	/* Pure virtual methods
	 */
	logger->init         = NULL;
	logger->free         = NULL;
	logger->write_access = NULL;
	logger->write_error  = NULL;
	
	return ret_ok;
}




/* Virtual method hidding layer
 */

ret_t
cherokee_logger_free (cherokee_logger_t *logger)
{
	if (logger->free)
		return logger->free (logger);
	
	return ret_error;
}


ret_t
cherokee_logger_init (cherokee_logger_t *logger)
{
	if (logger->init)
		return logger->init (logger);
	
	return ret_error;
}


inline ret_t
cherokee_logger_write_access (cherokee_logger_t *logger, void *conn)
{
	if (logger->write_access)
		return logger->write_access (logger, conn);
	
	return ret_error;
}


ret_t 
cherokee_logger_write_error (cherokee_logger_t *logger, const char *format, ...)
{
	if (logger->write_error)
		// FIXME !!
		return logger->write_error (logger, format);
	
	return ret_error;
}


ret_t 
cherokee_logger_write_string (cherokee_logger_t *logger, const char *format, ...)
{

	return ret_ok;
}
