/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_FD_POLL_H__
#define __CHEROKEE_FD_POLL_H__

#ifdef USE_POOL_EMULATION
# include "poll_emu.h"
#else
# ifdef HAVE_SYS_POLL_H
#   include <sys/poll.h>
# else
#   include <poll.h>
# endif
#endif

#ifdef HAVE_PTHREAD
#include <pthread.h>
#endif

#include "common.h"


typedef enum {
	   fdp_read  = 0,
	   fdp_write = 1
} cherokee_fdpoll_rw_t;

typedef struct {
	int            nfiles;
	struct pollfd *pollfds;
	int            npollfds;
	int           *fdidx;
	
#ifdef HAVE_PTHREAD
	pthread_rwlock_t rwlock;
#endif

} cherokee_fdpoll_t;

ret_t cherokee_fdpoll_new      (cherokee_fdpoll_t **fdp);
ret_t cherokee_fdpoll_free     (cherokee_fdpoll_t  *fdp);

ret_t cherokee_fdpoll_add      (cherokee_fdpoll_t  *fdp, int fd, int rw);
ret_t cherokee_fdpoll_del      (cherokee_fdpoll_t  *fdp, int fd);
void  cherokee_fdpoll_set_mode (cherokee_fdpoll_t  *fdp, int fd, int rw);
int   cherokee_fdpoll_check    (cherokee_fdpoll_t  *fdp, int fd, int rw);
int   cherokee_fdpoll_watch    (cherokee_fdpoll_t  *fdp, int timeout_msecs);

#endif /* __CHEROKEE_FD_POLL_H__ */
