/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "virtual_server.h"


ret_t 
cherokee_virtual_server_new (cherokee_virtual_server_t **vserver)
{
       	CHEROKEE_NEW_STRUCT (vsrv, virtual_server);

	vsrv->domain = NULL;
	vsrv->root   = NULL;
	
	cherokee_plugin_table_new (&vsrv->plugins);
	return_if_fail (vsrv->plugins!=NULL, ret_nomem);	   
	
	*vserver = vsrv;
	
	return ret_ok;
}


ret_t 
cherokee_virtual_server_free (cherokee_virtual_server_t *vserver)
{
	if (vserver->domain != NULL) {
		free (vserver->domain);
		vserver->domain = NULL;
	}
	
	if (vserver->root != NULL) {
		free (vserver->root);
		vserver->root = NULL;
	}
	
	cherokee_plugin_table_free (vserver->plugins);
	vserver->plugins = NULL;

	free (vserver);
	
	return ret_ok;
}


ret_t 
cherokee_virtual_server_clean (cherokee_virtual_server_t *vserver)
{
	if (vserver->domain != NULL) {
		free (vserver->domain);
		vserver->domain = NULL;
	}
	
	if (vserver->root != NULL) {
		free (vserver->root);
		vserver->root = NULL;
	}
	
	return ret_ok;
}


ret_t 
cherokee_virtual_server_set (cherokee_virtual_server_t *vserver, char *web_dir,  char *handler_name, cherokee_plugin_table_entry_t *plugin_entry)
{
	ret_t ret;

	ret = cherokee_plugin_table_add (vserver->plugins, web_dir, plugin_entry);
	if (ret != ret_ok) {
		switch (ret) {
		case ret_file_not_found:
			PRINT_ERROR ("Can't load handler '%s': File not found\n", handler_name);
			break;
		default:
			PRINT_ERROR ("Can't load handler '%s': Unknown error\n", handler_name);
		}
	}
	
	return ret;

}
