/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_BUFFER_H__
#define __CHEROKEE_BUFFER_H__

#include "common.h"
#include "crc32.h"

typedef struct {
	   char *buf;
	   int   size;    /* total amount of memory */
	   int   len;     /* strlen (buf) */
} cherokee_buffer_t;

#define BUF(x) ((cherokee_buffer_t *)(x))


ret_t cherokee_buffer_new           (cherokee_buffer_t **buf);
ret_t cherokee_buffer_free          (cherokee_buffer_t  *buf);
ret_t cherokee_buffer_clean         (cherokee_buffer_t  *buf);

ret_t cherokee_buffer_add           (cherokee_buffer_t  *buf, char *txt, int size);
ret_t cherokee_buffer_prepend       (cherokee_buffer_t  *buf, char *txt, int size);

ret_t cherokee_buffer_move_to_begin (cherokee_buffer_t  *buf, int pos);
ret_t cherokee_buffer_drop_endding  (cherokee_buffer_t  *buf, int num_chars);
void  cherokee_buffer_swap_chars    (cherokee_buffer_t  *buf, char a, char b);

ret_t cherokee_buffer_ensure_size   (cherokee_buffer_t  *buf, int size);
int   cherokee_buffer_is_empty      (cherokee_buffer_t  *buf);
ret_t cherokee_buffer_make_empty    (cherokee_buffer_t  *buf);

void  cherokee_buffer_decode        (cherokee_buffer_t  *buf);
crc_t cherokee_buffer_crc32         (cherokee_buffer_t  *buf);

ret_t  cherokee_buffer_print_debug  (cherokee_buffer_t  *buf, int length);

#endif /* __CHEROKEE_BUFFER_H__ */
