/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "connection.h"
#include "handler_redir.h"


ret_t 
cherokee_handler_redir_new (cherokee_handler_t **hdl, void *cnt, cherokee_table_t *properties)
{
	cherokee_handler_redir_t *n = (cherokee_handler_redir_t *)malloc(sizeof(cherokee_handler_redir_t));
	return_if_fail (n != NULL, ret_nomem);
	
	/* Init the base class object
	 */
	cherokee_handler_init_base(HANDLER(n), cnt);
	HANDLER(n)->connection  = cnt;

	HANDLER(n)->support = 0;

	HANDLER(n)->init        = (handler_func_init_t) cherokee_handler_redir_init;
	HANDLER(n)->free        = (handler_func_free_t) cherokee_handler_redir_free;
	HANDLER(n)->step        = NULL;
	HANDLER(n)->add_headers = (handler_func_add_headers_t) cherokee_handler_redir_add_headers;
	
	if (properties) {
		n->target_url = cherokee_table_get (properties, "url");
		n->target_url_len = strlen(n->target_url);
	}

	*hdl = HANDLER(n);
	
	return ret_ok;	   
}


ret_t 
cherokee_handler_redir_init (cherokee_handler_redir_t *n)
{
	int                    request_end;
	char                  *request_endding;
	cherokee_connection_t *conn;

	conn = CONN(HANDLER(n)->connection);
	
	request_end = (conn->request->len - conn->web_directory->len);
	request_endding = conn->request->buf + conn->web_directory->len;

	HANDLER(n)->redirect = (char *) malloc (request_end + n->target_url_len +1);

	memcpy (HANDLER(n)->redirect, n->target_url, n->target_url_len);
	memcpy (HANDLER(n)->redirect + n->target_url_len, request_endding, request_end);
	HANDLER(n)->redirect[request_end + n->target_url_len] = '\0';

	CONN(HANDLER(n)->connection)->error_code = http_moved_permanently;
	return ret_error;
}


ret_t 
cherokee_handler_redir_free (cherokee_handler_redir_t *rehdl)
{
	free (rehdl);	
	return ret_ok;
}


ret_t 
cherokee_handler_redir_add_headers (cherokee_handler_redir_t *rehdl, cherokee_buffer_t *buffer)
{
	if (HANDLER(rehdl)->redirect) {
		cherokee_buffer_add (buffer, "Location: ", 10);
		cherokee_buffer_add (buffer, HANDLER(rehdl)->redirect, strlen(HANDLER(rehdl)->redirect));
		cherokee_buffer_add (buffer, CRLF, 2);
	}

	return ret_ok;
}



/* Library init function
 */

void 
redir_init (void)
{

}
