# Workaround for a change in RPM 4.1.x; needs proper fixing soon!
%define _unpackaged_files_terminate_build 0
%define version 0.4.4

Summary: Cherokee is an extremely fast and tiny web server.
Name: cherokee
Version: %{version}
Release: %{release}
Copyright: GPL
URL: ftp://alobbs.com/cherokee
Group: Utilities
Packager: Pablo Neira <pneira@optimat.com>
Source: ftp://alobbs.com/cherokee/cherokee-%{version}.tar.gz
#Requires: blau

%description
Cherokee is an extremely fast and tiny web server.
- FAST and tiny
- Embedable
- Extensible with plug-ins
- Handler-to-path support
- Virtual servers support
- Dynamic / Static plug-in compilation
- Streaming support
- Common tasks:
    * Can work as a daemon
    * Mime types
    * Log via syslog
    * Keep-alive connections
    * Runs under a chroot enviroment
- Clean code ;-)

%changelog
* Tue Apr 8 2003  Pablo Neira <pneira@optimat.com>
+ Version 0.4.2:
  + A new version of cherokee released.

* Sun Apr 6 2003  Pablo Neira <pneira@optimat.com>
+ Version 0.4.1:
  + I just generated a cherokee RPM file.

###########################################################
%prep
###########################################################
%setup

###########################################################
%build
###########################################################
./configure
make
make install

###########################################################
%install
###########################################################

###########################################################
%files
###########################################################
%defattr(-,root,root)
/usr/local/bin/cherokee
/usr/local/bin/cherokee_static
/usr/local/etc/cherokee
/usr/local/etc/cherokee/cherokee.conf
%dir /usr/local/include/cherokee
/usr/local/include/cherokee/avl.h
/usr/local/include/cherokee/buffer.h
/usr/local/include/cherokee/common.h
/usr/local/include/cherokee/connection.h
/usr/local/include/cherokee/fdpoll.h
/usr/local/include/cherokee/handler.h
/usr/local/include/cherokee/http.h
/usr/local/include/cherokee/list.h
/usr/local/include/cherokee/log.h
/usr/local/include/cherokee/plugin_table.h
/usr/local/include/cherokee/server.h
/usr/local/include/cherokee/table.h
%dir /usr/local/lib/cherokee
/usr/local/lib/cherokee/libcherokee_common.a
/usr/local/lib/cherokee/libcherokee_common.la
/usr/local/lib/cherokee/libcherokee_common.so
/usr/local/lib/cherokee/libcherokee_common.so.0
/usr/local/lib/cherokee/libcherokee_common.so.0.0.0
/usr/local/lib/cherokee/libcherokee_dirlist.a
/usr/local/lib/cherokee/libcherokee_dirlist.la
/usr/local/lib/cherokee/libcherokee_dirlist.so
/usr/local/lib/cherokee/libcherokee_dirlist.so.0
/usr/local/lib/cherokee/libcherokee_dirlist.so.0.0.0
/usr/local/lib/cherokee/libcherokee_file.a
/usr/local/lib/cherokee/libcherokee_file.la
/usr/local/lib/cherokee/libcherokee_file.so
/usr/local/lib/cherokee/libcherokee_file.so.0
/usr/local/lib/cherokee/libcherokee_file.so.0.0.0
/usr/local/lib/libcherokee.a
/usr/local/lib/libcherokee.la
/usr/local/lib/libcherokee.so
/usr/local/lib/libcherokee.so.0
/usr/local/lib/libcherokee.so.0.0.0
%dir /usr/local/share/cherokee
/usr/local/share/cherokee/mime_types.txt

###########################################################
%clean
###########################################################
if
  [ -z "${RPM_BUILD_ROOT}"  -a "${RPM_BUILD_ROOT}" != "/" ]
then
  rm -rf $RPM_BUILD_ROOT
fi
rm -rf $RPM_BUILD_DIR/cherokee-%{version}

###########################################################
%pre
###########################################################

###########################################################
%post
###########################################################

# There's already a group with gid 65534 so
# I decided to choose the gid 65533 which is free.
# It seems Cherokee works also fine by using this gid.
#
found=0
for line in `cat /etc/group`
do
        GR=`echo $line | cut -f1 -d':'`
        if [ "$GR" == "nogroup" ]
        then
                found=1
        fi
done

if [ $found -eq 0 ]
then
	echo "Creating group nogroup(65533)"
	groupadd -g 65533 nogroup
fi

###########################################################
%preun
###########################################################
found=0
for line in `cat /etc/group`
do
        GR=`echo $line | cut -f1 -d':'`
        if [ "$GR" == "nogroup" ]
        then
                found=1
        fi
done

if [ $found -eq 1 ]
then
	echo "Deleting group nogroup(65533)"
	groupdel nogroup
fi
