 /* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "encoder_gzip.h"


ret_t 
cherokee_encoder_gzip_new (cherokee_encoder_gzip_t **encoder)
{
	cherokee_encoder_gzip_t *n = (cherokee_encoder_gzip_t *) malloc (sizeof(cherokee_encoder_gzip_t));

	cherokee_encoder_init_base (ENCODER(n));

	ENCODER(n)->free   = (encoder_func_free_t) cherokee_encoder_gzip_free;
	ENCODER(n)->encode = (encoder_func_encode_t) cherokee_encoder_gzip_encode;

	/* Return the object
	 */
	*encoder = n;

	return ret_ok;
}


ret_t 
cherokee_encoder_gzip_free (cherokee_encoder_gzip_t *encoder)
{
	free (encoder);
	return ret_ok;
}


ret_t 
cherokee_encoder_gzip_add_headers (cherokee_encoder_gzip_t *encoder,
				   cherokee_buffer_t       *buf)
{
	cherokee_buffer_add (buf, "Content-Encoding: gzip\r\n", 24);
	return ret_ok;
}


ret_t 
cherokee_encoder_gzip_encode (cherokee_encoder_gzip_t *encoder, 
			      cherokee_buffer_t       *in, 
			      cherokee_buffer_t       *out)
{
	z_stream z;
	int result;

	/* Init the struct
	 */
	z.zalloc = Z_NULL;
	z.zfree = Z_NULL;
	z.opaque = Z_NULL;

	result = deflateInit (&z, Z_DEFAULT_COMPRESSION);
	if( result != Z_OK ) {
		return ret_error;
	}

	/* Buffers
	 */
	cherokee_buffer_ensure_size (out, in->len);

	z.next_in  = in->buf;
	z.next_out = out->buf;
	z.avail_in  = in->len;
	z.avail_out = out->size;

	/* Encode it!
	 */
	result = deflate (&z, Z_NO_FLUSH);
	if (result != Z_OK && result != Z_STREAM_END) {
		fprintf (stderr, "zlib error: %d: %s\n", result, z.msg);
		deflateEnd (&z);
		return ret_error;
	}

	deflateEnd (&z);

	return ret_ok;
}
