/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_COMMON_H__
#define __CHEROKEE_COMMON_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define DEFAULT_PAGE                  "index.html"
#define DEFAULT_RECV_SIZE             1024
#define DEFAULT_READ_SIZE             8192
#define MAX_HEADER_LEN                4096
#define MAX_KEEP_ALIVE                100
#define MAX_NEW_CONNECTIONS_PER_STEP  16


#define CRLF "\r\n"

#define NEW(type_) (type_ *) malloc (sizeof(type_))


/* Global mini-buffer:
 * for quick usage
 */
#define gbl_buffer_size 512
extern char gbl_buffer[gbl_buffer_size];


typedef enum {
	ret_ok,
	ret_error,
	ret_nomem,
	ret_eof,
	ret_eof_have_data,
	ret_file_not_found,
	ret_eagain
} ret_t;

#if 1
#define return_if_fail(expr,ret) \
	if (!(expr)) {                                                    \
		fprintf (stderr,                                          \
       		         "file %s: line %d (%s): assertion `%s' failed\n",\
                          __FILE__,                                       \
                          __LINE__,                                       \
                          __PRETTY_FUNCTION__,                            \
                          #expr);                                         \
	        return (ret);                                             \
	};
#else
#define return_if_fail(expr,ret)
#endif

#define SHOULDNT_HAPPEN \
	do { fprintf (stderr, "file %s: line %d (%s): this shouldn't happend\n", \
			            __FILE__, __LINE__, __PRETTY_FUNCTION__);          \
	} while (0);


void PRINT_ERROR (const char *format, ...);


int  hexit (char c);

/*                            0        1         2         3         4         5         6         7
						1234567890123456789012345678901234567890123456789012345678901234567890 */


#endif /* __CHEROKEE_COMMON_H__ */
