/* A Bison parser, made by GNU Bison 2.1.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     T_QUOTE = 258,
     T_DENY = 259,
     T_THREAD_NUM = 260,
     T_SSL_CERT_KEY_FILE = 261,
     T_SSL_CERT_FILE = 262,
     T_KEEPALIVE_MAX_REQUESTS = 263,
     T_ERROR_HANDLER = 264,
     T_TIMEOUT = 265,
     T_KEEPALIVE = 266,
     T_DOCUMENT_ROOT = 267,
     T_LOG = 268,
     T_MIME_FILE = 269,
     T_DIRECTORY = 270,
     T_HANDLER = 271,
     T_USER = 272,
     T_GROUP = 273,
     T_POLICY = 274,
     T_SERVER = 275,
     T_USERDIR = 276,
     T_PIDFILE = 277,
     T_LISTEN = 278,
     T_SERVER_TOKENS = 279,
     T_ENCODER = 280,
     T_ALLOW = 281,
     T_DIRECTORYINDEX = 282,
     T_ICONS = 283,
     T_AUTH = 284,
     T_NAME = 285,
     T_METHOD = 286,
     T_PASSWDFILE = 287,
     T_SSL_CA_LIST_FILE = 288,
     T_FROM = 289,
     T_SOCKET = 290,
     T_LOG_FLUSH_INTERVAL = 291,
     T_HEADERFILE = 292,
     T_PANIC_ACTION = 293,
     T_JUST_ABOUT = 294,
     T_LISTEN_QUEUE_SIZE = 295,
     T_SENDFILE = 296,
     T_MINSIZE = 297,
     T_MAXSIZE = 298,
     T_MAX_FDS = 299,
     T_SHOW = 300,
     T_CHROOT = 301,
     T_ONLY_SECURE = 302,
     T_MAX_CONNECTION_REUSE = 303,
     T_REWRITE = 304,
     T_POLL_METHOD = 305,
     T_EXTENSION = 306,
     T_IPV6 = 307,
     T_ENV = 308,
     T_REQUEST = 309,
     T_MIMETYPE = 310,
     T_MAX_AGE = 311,
     T_NUMBER = 312,
     T_PORT = 313,
     T_PORT_TLS = 314,
     T_QSTRING = 315,
     T_FULLDIR = 316,
     T_ID = 317,
     T_HTTP_URL = 318,
     T_HTTPS_URL = 319,
     T_HOSTNAME = 320,
     T_IP = 321,
     T_DOMAIN_NAME = 322,
     T_ADDRESS_PORT = 323,
     T_MIMETYPE_ID = 324
   };
#endif
/* Tokens.  */
#define T_QUOTE 258
#define T_DENY 259
#define T_THREAD_NUM 260
#define T_SSL_CERT_KEY_FILE 261
#define T_SSL_CERT_FILE 262
#define T_KEEPALIVE_MAX_REQUESTS 263
#define T_ERROR_HANDLER 264
#define T_TIMEOUT 265
#define T_KEEPALIVE 266
#define T_DOCUMENT_ROOT 267
#define T_LOG 268
#define T_MIME_FILE 269
#define T_DIRECTORY 270
#define T_HANDLER 271
#define T_USER 272
#define T_GROUP 273
#define T_POLICY 274
#define T_SERVER 275
#define T_USERDIR 276
#define T_PIDFILE 277
#define T_LISTEN 278
#define T_SERVER_TOKENS 279
#define T_ENCODER 280
#define T_ALLOW 281
#define T_DIRECTORYINDEX 282
#define T_ICONS 283
#define T_AUTH 284
#define T_NAME 285
#define T_METHOD 286
#define T_PASSWDFILE 287
#define T_SSL_CA_LIST_FILE 288
#define T_FROM 289
#define T_SOCKET 290
#define T_LOG_FLUSH_INTERVAL 291
#define T_HEADERFILE 292
#define T_PANIC_ACTION 293
#define T_JUST_ABOUT 294
#define T_LISTEN_QUEUE_SIZE 295
#define T_SENDFILE 296
#define T_MINSIZE 297
#define T_MAXSIZE 298
#define T_MAX_FDS 299
#define T_SHOW 300
#define T_CHROOT 301
#define T_ONLY_SECURE 302
#define T_MAX_CONNECTION_REUSE 303
#define T_REWRITE 304
#define T_POLL_METHOD 305
#define T_EXTENSION 306
#define T_IPV6 307
#define T_ENV 308
#define T_REQUEST 309
#define T_MIMETYPE 310
#define T_MAX_AGE 311
#define T_NUMBER 312
#define T_PORT 313
#define T_PORT_TLS 314
#define T_QSTRING 315
#define T_FULLDIR 316
#define T_ID 317
#define T_HTTP_URL 318
#define T_HTTPS_URL 319
#define T_HOSTNAME 320
#define T_IP 321
#define T_DOMAIN_NAME 322
#define T_ADDRESS_PORT 323
#define T_MIMETYPE_ID 324




/* Copy the first part of user declarations.  */


/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2006 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common-internal.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <ctype.h>
#include <strings.h>

#ifdef HAVE_PWD_H
# include <pwd.h>
#endif

#ifdef HAVE_GRP_H
# include <grp.h>
#endif

#include "table.h"
#include "mime.h"
#include "server.h"
#include "server-protected.h"
#include "virtual_server.h"
#include "config_entry.h"
#include "encoder.h"
#include "logger_table.h"
#include "access.h"
#include "list.h"
#include "list_ext.h"
#include "reqs_list.h"
#include "reqs_list_entry.h"
#include "fastcgi-common.h"


/* Define the parameter name of the yyparse() argument
 */
#define YYPARSE_PARAM server



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)

typedef union YYSTYPE {
	   int   number;
	   char *string;
	   void *ptr;

	   struct {
			 char *name;
			 void *ptr;
	   } name_ptr;

	   void *list;
} YYSTYPE;
/* Line 196 of yacc.c.  */

# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* What is the right way to import this prototipe?
 */
extern int yylex (void);


extern char *yytext;
extern int   yylineno;

char                                   *current_yacc_file           = NULL;
static cherokee_dirs_table_t           *current_dirs_table          = NULL;
static cherokee_config_entry_t         *current_config_entry        = NULL;
static list_t                          *current_reqs_list           = NULL;
static cherokee_virtual_server_t       *current_virtual_server      = NULL;
static cherokee_encoder_table_entry_t  *current_encoder_entry       = NULL;
static cherokee_module_info_t          *current_module_info         = NULL;
static cherokee_fcgi_server_t          *current_fastcgi_server      = NULL;
static cherokee_mime_entry_t           *current_mime_entry          = NULL;
static cuint_t                          priority_counter            = 1;

typedef struct {
	   void *next;
	   char *string;
} linked_list_t;

struct {
	   char                           *handler_name;
	   cherokee_config_entry_t        *entry;
	   cherokee_virtual_server_t      *vserver;
	   cherokee_dirs_table_t          *dirs;
	   char                           *document_root;
	   char                           *directory_name;
} directory_content_tmp;

struct {
	   char                           *handler_name;
	   cherokee_config_entry_t        *entry;
	   cherokee_virtual_server_t      *vserver;
	   cherokee_exts_table_t          *exts;
	   char                           *document_root;
	   linked_list_t                  *exts_list;
} extension_content_tmp;

struct {
	   char                           *handler_name;
	   cherokee_reqs_list_entry_t     *entry;
	   cherokee_virtual_server_t      *vserver;
	   list_t                         *reqs;
	   char                           *document_root;
} request_content_tmp;


#define auto_virtual_server ((current_virtual_server) ? current_virtual_server : SRV(server)->vserver_default)
#define auto_dirs_table     ((current_dirs_table) ? current_dirs_table : &(auto_virtual_server)->dirs)
#define auto_reqs_table     ((current_reqs_list) ? current_reqs_list : &(auto_virtual_server)->reqs)

static void
free_linked_list (linked_list_t *list, void (*free_func) (void *))
{
	   linked_list_t *i = list;

	   while (i != NULL) {
			 linked_list_t *prev = i;

			 if ((free_func) && (i->string)) {
				    free_func (i->string);
			 }

			 prev = i;
			 i = i->next;
			 free (prev);
	   }	   
}

static char *
make_finish_with_slash (char *string, int *len)
{
	   char *new_entry;
	   int   new_len;

	   if (string[(*len)-1] == '/') {
			 return string;
	   }

	   new_len = (*len) + 2;
	   new_entry  = (char*) malloc (new_len);

	   *len = snprintf (new_entry, new_len, "%s/", string);

	   free (string);
	   return new_entry;
}

static char *
make_slash_end (char *string)
{
	   int len = strlen(string);
	   return make_finish_with_slash (string, &len);
}

static cherokee_config_entry_t *
config_entry_new (void)
{
	   cherokee_config_entry_t *entry;

	   cherokee_config_entry_new (&entry);
	   current_config_entry = entry;

	   /* Assign the priority
	    */
	   entry->priority = priority_counter;
	   priority_counter++;

	   return entry;
}

static cherokee_reqs_list_entry_t *
reqs_list_entry_new (void)
{
	   cherokee_reqs_list_entry_t *entry;

	   cherokee_reqs_list_entry_new (&entry);
	   current_config_entry = (cherokee_config_entry_t *)entry;      /* It is okay! */

	   entry->base_entry.priority = priority_counter;
	   priority_counter++;

	   return entry;
}

static char *
new_string_to_lowercase (const char *in)
{
	   int   i;
	   char *tmp;
	   
	   i = strlen(in);
	   tmp = (char *) malloc (i+1);
	   tmp[i] = '\0';

	   while (i--) {
			 tmp[i] = tolower(in[i]);
	   }

	   return tmp;
}

static int
load_module (cherokee_module_loader_t *loader, char *name, cherokee_module_info_t **info)
{
	   ret_t ret;

	   ret = cherokee_module_loader_load (loader, name);
	   if (ret < ret_ok) {
			 PRINT_MSG("ERROR: Loading module '%s'\n", name);
			 return 1;
	   }
	   
	   ret = cherokee_module_loader_get_info (loader, name, info);
	   if (ret < ret_ok) {
			 PRINT_MSG("ERROR: Loading module '%s'\n", name);
			 return 1;
	   }

	   return 0;
}


static void
handler_redir_add_property (cherokee_config_entry_t *entry, char *regex, char *subs, int show)
{
	   char   *p;
	   char   *serialized;
	   int     regex_len    = 0;
	   int     subs_len     = 0;
	   list_t *plist        = NULL;
	   list_t  nlist        = LIST_HEAD_INIT(nlist);

	   /* Build the string:
	    * [1]show [s]regex \0 [s]subs \0
	    */
	   subs_len = strlen(subs);

	   if (regex != NULL)
			 regex_len = strlen(regex);

	   serialized = (char *) malloc (1 + regex_len + 1 + subs_len + 1);
	   memset (serialized, 0, regex_len + subs_len + 3);

	   p = serialized;

	   *p = show;
	   p++;

	   strncpy (p, regex, regex_len);
	   p += regex_len + 1;
	   
	   strncpy (p, subs, subs_len);
	   
	   /* Add it to the list
	    */
	   if (entry->handler_properties != NULL) {
			 cherokee_typed_table_get_list (entry->handler_properties, "regex_list", &plist);
	   }

	   if (plist == NULL) {
			 cherokee_list_add (&nlist, serialized);
			 cherokee_config_entry_set_handler_prop (entry, "regex_list", typed_list, &nlist, 
												(cherokee_typed_free_func_t) cherokee_list_free_item_simple);
	   } else {
			 cherokee_list_add_tail (plist, serialized);
	   }
}

static void
handler_redir_add_property_simple (cherokee_config_entry_t *entry, char *subs, int show)
{
	   handler_redir_add_property (entry, NULL, subs, show);
}


static void
dirs_table_set_handler_prop (cherokee_config_entry_t *dir_entry, char *prop, char *value)
{
	   cherokee_config_entry_set_handler_prop (dir_entry, prop, typed_str, value, NULL);
}

static void
dirs_table_set_validator_prop (cherokee_config_entry_t *dir_entry, char *prop, char *value)
{
	   cherokee_config_entry_set_validator_prop (dir_entry, prop, typed_str, value, NULL);
}

static int
add_key_val_entry_in_property (cherokee_table_t *properties, char *prop_name, char *key, char *val)
{
	   cuint_t           new_len;
	   char             *new_str;
	   list_t           *plist       = NULL;
	   list_t            nlist       = LIST_HEAD_INIT(nlist);
	   
	   /* Build the string:
	    * VAR \0 VAL \0
	    */
	   new_len = strlen(key) + strlen(val) + 2;
	   new_str = malloc (new_len);
	   if (new_str == NULL) return 1;
	   
	   memset (new_str, 0, new_len);
	   memcpy (new_str, key, strlen(key));
	   memcpy (new_str + strlen(key) + 1, val, strlen(val));

	   /* Add it to the list
	    */
	   if (properties != NULL) {
			 cherokee_typed_table_get_list (properties, prop_name, &plist);
	   }
	   
	   if (plist == NULL) {
			 cherokee_list_add (&nlist, new_str);
			 cherokee_config_entry_set_handler_prop (current_config_entry, prop_name, typed_list, &nlist, 
											 (cherokee_typed_free_func_t) cherokee_list_free_item_simple);
	   } else {
			 cherokee_list_add_tail (plist, new_str);			 
	   }

	   return 0;
}

void
yyerror (char* msg)
{
	   char *config;

	   config = (current_yacc_file) ? current_yacc_file : "";

        PRINT_MSG("Error parsing file %s:%d '%s', symbol '%s'\n", 
			   config, yylineno, msg, yytext);
}



/* Line 219 of yacc.c.  */


#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T) && (defined (__STDC__) || defined (__cplusplus))
# include <stddef.h> /* INFRINGES ON USER NAME SPACE */
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if defined (__STDC__) || defined (__cplusplus)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     define YYINCLUDED_STDLIB_H
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2005 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM ((YYSIZE_T) -1)
#  endif
#  ifdef __cplusplus
extern "C" {
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if (! defined (malloc) && ! defined (YYINCLUDED_STDLIB_H) \
	&& (defined (__STDC__) || defined (__cplusplus)))
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if (! defined (free) && ! defined (YYINCLUDED_STDLIB_H) \
	&& (defined (__STDC__) || defined (__cplusplus)))
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifdef __cplusplus
}
#  endif
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  126
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   249

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  73
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  92
/* YYNRULES -- Number of rules. */
#define YYNRULES  188
/* YYNRULES -- Number of states. */
#define YYNSTATES  288

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   324

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    70,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    71,     2,    72,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     4,     6,     8,    11,    13,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    97,
     100,   101,   104,   105,   108,   109,   112,   113,   116,   117,
     120,   121,   124,   125,   128,   130,   132,   134,   138,   140,
     144,   146,   150,   152,   154,   156,   160,   163,   166,   169,
     172,   175,   178,   179,   184,   185,   189,   190,   193,   196,
     199,   202,   203,   210,   213,   216,   219,   222,   225,   228,
     231,   234,   237,   238,   243,   247,   248,   251,   254,   257,
     260,   263,   268,   271,   274,   277,   280,   283,   287,   291,
     292,   295,   298,   301,   304,   307,   310,   316,   319,   321,
     323,   328,   332,   336,   339,   341,   343,   345,   347,   349,
     351,   354,   357,   360,   364,   367,   371,   374,   376,   377,
     382,   384,   386,   387,   391,   395,   398,   401,   404,   406,
     408,   410,   411,   418,   419,   426,   427,   434,   435,   442,
     444,   447,   453,   457,   459,   462,   465,   469,   473,   474,
     475,   478,   481,   482,   489,   492,   493,   497,   498
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
      74,     0,    -1,    -1,    75,    -1,    77,    -1,    75,    77,
      -1,    79,    -1,    76,    79,    -1,    79,    -1,    78,    -1,
     146,    -1,    94,    -1,    95,    -1,    96,    -1,   105,    -1,
     106,    -1,   107,    -1,   110,    -1,   111,    -1,   112,    -1,
     113,    -1,   121,    -1,   133,    -1,   134,    -1,   135,    -1,
     136,    -1,   128,    -1,   129,    -1,   132,    -1,    97,    -1,
      98,    -1,   122,    -1,   123,    -1,   124,    -1,   126,    -1,
     127,    -1,   150,    -1,   148,    -1,   152,    -1,   163,    -1,
      99,    -1,   161,    -1,   100,    -1,   117,    -1,   114,    -1,
     115,    -1,   116,    -1,   159,    -1,    -1,    80,   144,    -1,
      -1,    81,   154,    -1,    -1,    82,   125,    -1,    -1,    83,
     139,    -1,    -1,    84,   120,    -1,    -1,    85,   131,    -1,
      -1,    86,   155,    -1,    -1,    87,   150,    -1,    62,    -1,
      61,    -1,    88,    -1,    88,    70,    89,    -1,    62,    -1,
      62,    70,    90,    -1,   145,    -1,   145,    70,    91,    -1,
      66,    -1,    62,    -1,    92,    -1,    92,    70,    93,    -1,
      58,    57,    -1,    59,    57,    -1,    23,   145,    -1,    36,
      57,    -1,    50,    62,    -1,    12,    61,    -1,    -1,    13,
      62,   101,   102,    -1,    -1,    71,   103,    72,    -1,    -1,
     103,   104,    -1,    62,    61,    -1,    24,    62,    -1,    14,
      61,    -1,    -1,    55,    69,    71,   108,   109,    72,    -1,
      56,    57,    -1,    51,    90,    -1,    28,    61,    -1,    10,
      57,    -1,    11,    57,    -1,     8,    57,    -1,     7,    61,
      -1,     6,    61,    -1,    33,    61,    -1,    -1,    25,    62,
     118,   119,    -1,    71,    84,    72,    -1,    -1,    26,    90,
      -1,     4,    90,    -1,    22,    61,    -1,    38,    61,    -1,
      40,    57,    -1,    41,    71,    82,    72,    -1,    42,    57,
      -1,    43,    57,    -1,    44,    57,    -1,    48,    57,    -1,
      46,    61,    -1,     5,    57,   130,    -1,    71,    85,    72,
      -1,    -1,    19,    62,    -1,    52,    57,    -1,    17,    62,
      -1,    17,    57,    -1,    18,    62,    -1,    18,    57,    -1,
      16,    62,    71,    83,    72,    -1,    16,    62,    -1,    63,
      -1,    64,    -1,    45,    49,    60,    60,    -1,    49,    60,
      60,    -1,    45,    49,    60,    -1,    49,    60,    -1,    62,
      -1,    61,    -1,    68,    -1,    60,    -1,    63,    -1,    64,
      -1,    62,   140,    -1,    62,    57,    -1,     9,    57,    -1,
      45,    37,    57,    -1,    37,    89,    -1,    53,    62,   140,
      -1,    35,    61,    -1,    39,    -1,    -1,    20,   142,   141,
     143,    -1,    68,    -1,    61,    -1,    -1,    71,    80,    72,
      -1,    53,    62,   140,    -1,    62,   140,    -1,    57,   138,
      -1,    45,    90,    -1,    62,    -1,    66,    -1,    67,    -1,
      -1,    20,    91,    71,   147,    76,    72,    -1,    -1,    51,
      90,    71,   149,    81,    72,    -1,    -1,    15,    61,    71,
     151,    81,    72,    -1,    -1,    54,    60,    71,   153,    81,
      72,    -1,   137,    -1,    12,    61,    -1,    29,    90,    71,
      86,    72,    -1,    26,    34,    93,    -1,    47,    -1,    30,
      60,    -1,    17,    90,    -1,    31,    62,   156,    -1,    71,
     157,    72,    -1,    -1,    -1,   157,   158,    -1,    32,    61,
      -1,    -1,    21,    62,   160,    71,    87,    72,    -1,    27,
      89,    -1,    -1,    71,    83,    72,    -1,    -1,     9,    62,
     164,   162,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   381,   381,   382,   385,   386,   389,   390,   393,   394,
     397,   398,   399,   400,   401,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   425,   426,   427,   428,
     429,   430,   431,   432,   433,   434,   435,   436,   439,   440,
     442,   443,   445,   446,   448,   449,   451,   452,   454,   455,
     457,   458,   460,   461,   466,   467,   469,   478,   490,   499,
     511,   520,   532,   532,   534,   543,   552,   557,   562,   567,
     572,   590,   612,   611,   637,   638,   640,   641,   644,   657,
     675,   681,   680,   703,   708,   723,   728,   736,   741,   746,
     763,   780,   799,   798,   829,   830,   832,   853,   874,   893,
     903,   908,   910,   915,   920,   925,   930,   935,   942,   943,
     945,   961,   966,   981,   986,  1001,  1006,  1012,  1018,  1019,
    1023,  1028,  1033,  1038,  1044,  1045,  1046,  1047,  1048,  1049,
    1054,  1084,  1095,  1100,  1106,  1126,  1134,  1137,  1141,  1140,
    1177,  1178,  1180,  1181,  1183,  1191,  1197,  1210,  1240,  1241,
    1242,  1248,  1247,  1285,  1284,  1371,  1370,  1443,  1442,  1488,
    1496,  1509,  1533,  1553,  1562,  1576,  1597,  1618,  1619,  1622,
    1623,  1626,  1631,  1630,  1659,  1673,  1674,  1677,  1676
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "T_QUOTE", "T_DENY", "T_THREAD_NUM",
  "T_SSL_CERT_KEY_FILE", "T_SSL_CERT_FILE", "T_KEEPALIVE_MAX_REQUESTS",
  "T_ERROR_HANDLER", "T_TIMEOUT", "T_KEEPALIVE", "T_DOCUMENT_ROOT",
  "T_LOG", "T_MIME_FILE", "T_DIRECTORY", "T_HANDLER", "T_USER", "T_GROUP",
  "T_POLICY", "T_SERVER", "T_USERDIR", "T_PIDFILE", "T_LISTEN",
  "T_SERVER_TOKENS", "T_ENCODER", "T_ALLOW", "T_DIRECTORYINDEX", "T_ICONS",
  "T_AUTH", "T_NAME", "T_METHOD", "T_PASSWDFILE", "T_SSL_CA_LIST_FILE",
  "T_FROM", "T_SOCKET", "T_LOG_FLUSH_INTERVAL", "T_HEADERFILE",
  "T_PANIC_ACTION", "T_JUST_ABOUT", "T_LISTEN_QUEUE_SIZE", "T_SENDFILE",
  "T_MINSIZE", "T_MAXSIZE", "T_MAX_FDS", "T_SHOW", "T_CHROOT",
  "T_ONLY_SECURE", "T_MAX_CONNECTION_REUSE", "T_REWRITE", "T_POLL_METHOD",
  "T_EXTENSION", "T_IPV6", "T_ENV", "T_REQUEST", "T_MIMETYPE", "T_MAX_AGE",
  "T_NUMBER", "T_PORT", "T_PORT_TLS", "T_QSTRING", "T_FULLDIR", "T_ID",
  "T_HTTP_URL", "T_HTTPS_URL", "T_HOSTNAME", "T_IP", "T_DOMAIN_NAME",
  "T_ADDRESS_PORT", "T_MIMETYPE_ID", "','", "'{'", "'}'", "$accept",
  "conffile", "lines", "server_lines", "line", "common_line",
  "server_line", "handler_server_optinal_entries", "directory_options",
  "sendfile_options", "handler_options", "encoder_options",
  "thread_options", "auth_options", "directories", "id_or_path",
  "id_path_list", "id_list", "domain_list", "ip_or_domain", "ip_list",
  "port", "port_tls", "listen", "log_flush_interval", "poll_method",
  "document_root", "log", "@1", "log_optional", "tuple_list", "tuple",
  "server_tokens", "mime", "mime_entry", "@2", "mimetype_options", "icons",
  "timeout", "keepalive", "keepalive_max_requests", "ssl_file",
  "ssl_key_file", "ssl_ca_list_file", "encoder", "@3",
  "maybe_encoder_options", "encoder_option", "pidfile", "panic_action",
  "listen_queue_size", "sendfile", "sendfile_option", "maxfds",
  "maxconnectionreuse", "chroot", "thread_number", "maybe_thread_options",
  "thread_option", "ipv6", "user1", "user2", "group1", "group2", "handler",
  "http_generic", "handler_option", "str_type", "@4", "address_or_path",
  "handler_server_optinal", "handler_server_optinal_entry", "host_name",
  "server", "@5", "extension", "@6", "directory", "@7", "request", "@8",
  "directory_option", "auth_option", "maybe_auth_option_params",
  "auth_option_params", "auth_option_param", "userdir", "@9",
  "directoryindex", "maybe_handlererror_options", "errorhandler", "@10", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      44,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    73,    74,    74,    75,    75,    76,    76,    77,    77,
      78,    78,    78,    78,    78,    78,    78,    78,    78,    78,
      78,    78,    78,    78,    78,    78,    78,    78,    78,    78,
      78,    78,    78,    78,    78,    78,    79,    79,    79,    79,
      79,    79,    79,    79,    79,    79,    79,    79,    80,    80,
      81,    81,    82,    82,    83,    83,    84,    84,    85,    85,
      86,    86,    87,    87,    88,    88,    89,    89,    90,    90,
      91,    91,    92,    92,    93,    93,    94,    95,    96,    97,
      98,    99,   101,   100,   102,   102,   103,   103,   104,   105,
     106,   108,   107,   109,   109,   110,   111,   112,   113,   114,
     115,   116,   118,   117,   119,   119,   120,   120,   121,   122,
     123,   124,   125,   125,   126,   127,   128,   129,   130,   130,
     131,   132,   133,   134,   135,   136,   137,   137,   138,   138,
     139,   139,   139,   139,   140,   140,   140,   140,   140,   140,
     139,   139,   139,   139,   139,   139,   139,   139,   141,   139,
     142,   142,   143,   143,   144,   144,   139,   139,   145,   145,
     145,   147,   146,   149,   148,   151,   150,   153,   152,   154,
     154,   154,   154,   154,   155,   155,   155,   156,   156,   157,
     157,   158,   160,   159,   161,   162,   162,   164,   163
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     1,     1,     2,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     2,
       0,     2,     0,     2,     0,     2,     0,     2,     0,     2,
       0,     2,     0,     2,     1,     1,     1,     3,     1,     3,
       1,     3,     1,     1,     1,     3,     2,     2,     2,     2,
       2,     2,     0,     4,     0,     3,     0,     2,     2,     2,
       2,     0,     6,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     0,     4,     3,     0,     2,     2,     2,     2,
       2,     4,     2,     2,     2,     2,     2,     3,     3,     0,
       2,     2,     2,     2,     2,     2,     5,     2,     1,     1,
       4,     3,     3,     2,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     3,     2,     3,     2,     1,     0,     4,
       1,     1,     0,     3,     3,     2,     2,     2,     1,     1,
       1,     0,     6,     0,     6,     0,     6,     0,     6,     1,
       2,     5,     3,     1,     2,     2,     3,     3,     0,     0,
       2,     2,     0,     6,     2,     0,     3,     0,     4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     3,     4,
       9,     8,    11,    12,    13,    29,    30,    40,    42,    14,
      15,    16,    17,    18,    19,    20,    44,    45,    46,    43,
      21,    31,    32,    33,    34,    35,    26,    27,    28,    22,
      23,    24,    25,    10,    37,    36,    38,    47,    41,    39,
     119,   100,    99,    98,   187,    96,    97,    81,    82,    90,
       0,   123,   122,   125,   124,   158,   159,   160,     0,    70,
     182,   108,    78,    89,   102,    65,    64,    66,   184,    95,
     101,    79,   109,   110,    52,   114,   116,   115,    80,    68,
       0,   121,     0,     0,    76,    77,     1,     5,    58,   117,
     185,    84,   165,   161,     0,     0,   105,     0,     0,     0,
     163,   167,    91,     0,    54,   188,    86,    83,    50,     0,
      71,    62,    56,   103,    67,     0,     0,   111,    53,    69,
      50,    50,     0,     0,   118,    59,     0,     0,     0,     0,
       6,     0,     0,   112,   113,     0,     0,     0,     0,     0,
     120,     0,     0,     0,     0,   147,     0,     0,     0,     0,
       0,   186,    55,     0,    85,    87,     0,     0,     0,     0,
     173,   166,   169,    51,   162,     7,   183,    63,     0,     0,
     104,    57,   164,   168,    94,    93,    92,   142,   151,   150,
     148,   146,   144,     0,     0,   157,   133,     0,   128,   129,
     156,   141,   137,   135,   134,   138,   139,   136,   140,    88,
     170,   127,     0,     0,   107,   106,   152,   143,   132,   131,
     145,    54,    73,    72,    74,   172,    60,    48,   149,   130,
       0,     0,     0,     0,   126,    75,     0,     0,     0,   171,
      61,     0,     0,   153,    49,   175,   174,   178,     0,   155,
     179,   176,   154,     0,     0,   177,   180,   181
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    37,    38,   169,    39,    40,    41,   263,   168,   138,
     166,   172,   143,   262,   171,   107,   108,   120,    98,   254,
     255,    42,    43,    44,    45,    46,    47,    48,   131,   147,
     167,   195,    49,    50,    51,   162,   179,    52,    53,    54,
      55,    56,    57,    58,    59,   136,   153,   211,    60,    61,
      62,    63,   158,    64,    65,    66,    67,   129,   165,    68,
      69,    70,    71,    72,   202,   230,   192,   238,   246,   220,
     258,   274,    99,    73,   149,    74,   160,    75,   148,    76,
     161,   203,   270,   281,   283,   286,    77,   135,    78,   145,
      79,   130
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -207
static const short int yypact[] =
{
     123,   -51,   -11,    -9,   -22,    15,     4,    31,    37,    40,
      51,    64,   -20,    33,    25,    43,    78,    25,    93,   100,
      62,    99,   104,   109,   107,   113,   101,   119,   118,   128,
     125,   126,   134,   120,   124,   137,   138,   196,   123,  -207,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,
     129,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,
     130,  -207,  -207,  -207,  -207,  -207,  -207,  -207,   132,   127,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,   135,  -207,  -207,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,   136,
     140,  -207,   141,   142,  -207,  -207,  -207,  -207,  -207,  -207,
     143,   144,  -207,  -207,    25,   145,   146,    62,    42,   126,
    -207,  -207,  -207,    -7,  -207,  -207,  -207,  -207,  -207,   177,
    -207,  -207,  -207,  -207,  -207,   150,   151,  -207,  -207,  -207,
    -207,  -207,    98,   147,  -207,  -207,     6,   -33,     1,    -5,
    -207,   -10,    -1,  -207,  -207,    28,    70,   126,   161,   148,
    -207,   162,   -37,   160,    62,  -207,   -26,   139,   163,    89,
      47,  -207,  -207,   165,  -207,  -207,   166,   167,   188,   126,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,   126,   126,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,
    -207,  -207,  -207,   173,   164,  -207,   172,    58,  -207,  -207,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,
    -207,   152,    14,   168,  -207,  -207,   169,  -207,   174,  -207,
    -207,  -207,  -207,  -207,   171,  -207,  -207,  -207,  -207,  -207,
      44,    14,     2,    41,  -207,  -207,   126,   175,   176,  -207,
    -207,   180,    58,  -207,  -207,  -207,  -207,   178,    58,  -207,
    -207,  -207,  -207,   -14,   182,  -207,  -207,  -207
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -207,  -207,  -207,  -207,   195,  -207,  -135,  -207,    -3,  -207,
     -15,  -207,  -207,  -207,  -207,  -207,  -128,  -139,   103,  -207,
     -17,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -206,  -207,  -207,
    -207,  -207,   228,  -207,  -207,  -207,  -207,    75,  -207,  -207,
    -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,  -207,
    -207,  -207
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned short int yytable[] =
{
     159,     2,     3,   208,     5,    11,    80,     8,     9,   154,
      11,   223,   163,   196,   170,   181,    15,   197,   284,   266,
      19,   250,    20,   224,   218,   209,   182,   198,    22,   193,
     199,   219,   267,   268,   205,    83,   119,    91,   214,   194,
     196,   183,    92,   184,   197,   185,    31,   225,   200,    33,
      81,   186,    82,   181,   198,   187,   222,   199,   285,   188,
     243,    85,   206,   189,   182,   164,   279,   204,   190,   244,
     245,   210,   282,   201,   269,   200,   252,    84,   191,   183,
     253,   184,   196,   185,   155,   156,   197,    95,    86,   186,
      93,    96,    97,   187,   271,    94,   198,   188,    87,   199,
     212,   189,    88,   272,   231,   100,   190,   232,   233,   234,
     235,   236,    89,   273,   157,   237,   264,   200,   232,   233,
     234,   235,   236,   105,   106,    90,   237,   275,     1,     2,
       3,     4,     5,     6,     7,     8,     9,    10,    11,   101,
      12,    13,   213,    14,    15,    16,    17,    18,    19,   177,
      20,    21,   228,   229,   178,   103,    22,   175,   176,    23,
     109,    24,   104,    25,    26,   110,   111,    27,   112,    28,
     113,    29,   114,    30,    31,    32,   115,    33,    34,   116,
     122,    35,    36,     2,     3,   117,     5,   118,   119,     8,
       9,   121,    11,   123,   124,   125,   126,   134,    15,   226,
     128,   132,    19,   133,    20,   137,   139,   173,   174,   180,
      22,   140,   141,   142,   144,   146,   151,   152,   215,   217,
     216,   221,   242,   251,   248,   227,   239,   240,    31,   241,
     247,    33,   249,   127,   259,   276,   260,   150,   277,   256,
     257,   261,   278,   287,   265,   102,   207,     0,     0,   280
};

static const short int yycheck[] =
{
     139,     6,     7,     4,     9,    15,    57,    12,    13,   137,
      15,    37,    19,    12,   149,     9,    21,    16,    32,    17,
      25,   227,    27,    49,    61,    26,    20,    26,    33,    62,
      29,    68,    30,    31,   169,    57,    62,    57,   177,    72,
      12,    35,    62,    37,    16,    39,    51,   186,    47,    54,
      61,    45,    61,     9,    26,    49,   184,    29,    72,    53,
     199,    57,    72,    57,    20,    72,   272,    72,    62,   208,
     209,    72,   278,    72,    72,    47,    62,    62,    72,    35,
      66,    37,    12,    39,    42,    43,    16,    62,    57,    45,
      57,    66,    67,    49,    53,    62,    26,    53,    61,    29,
      72,    57,    62,    62,    57,    62,    62,    60,    61,    62,
      63,    64,    61,    72,    72,    68,    72,    47,    60,    61,
      62,    63,    64,    61,    62,    61,    68,   266,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    61,
      17,    18,    72,    20,    21,    22,    23,    24,    25,    51,
      27,    28,    63,    64,    56,    62,    33,   160,   161,    36,
      61,    38,    62,    40,    41,    61,    57,    44,    61,    46,
      57,    48,    71,    50,    51,    52,    57,    54,    55,    61,
      60,    58,    59,     6,     7,    57,     9,    62,    62,    12,
      13,    57,    15,    69,    57,    57,     0,    70,    21,    60,
      71,    71,    25,    71,    27,    70,    70,    57,    57,    62,
      33,    71,    71,    71,    71,    71,    71,    71,    57,    57,
      72,    61,    34,    71,    60,    62,    61,    61,    51,    62,
      57,    54,    60,    38,    60,    60,   251,   134,    62,    71,
      71,    70,    62,    61,   261,    17,   171,    -1,    -1,    71
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    17,    18,    20,    21,    22,    23,    24,    25,
      27,    28,    33,    36,    38,    40,    41,    44,    46,    48,
      50,    51,    52,    54,    55,    58,    59,    74,    75,    77,
      78,    79,    94,    95,    96,    97,    98,    99,   100,   105,
     106,   107,   110,   111,   112,   113,   114,   115,   116,   117,
     121,   122,   123,   124,   126,   127,   128,   129,   132,   133,
     134,   135,   136,   146,   148,   150,   152,   159,   161,   163,
      57,    61,    61,    57,    62,    57,    57,    61,    62,    61,
      61,    57,    62,    57,    62,    62,    66,    67,    91,   145,
      62,    61,   145,    62,    62,    61,    62,    88,    89,    61,
      61,    57,    61,    57,    71,    57,    61,    57,    62,    62,
      90,    57,    60,    69,    57,    57,     0,    77,    71,   130,
     164,   101,    71,    71,    70,   160,   118,    70,    82,    70,
      71,    71,    71,    85,    71,   162,    71,   102,   151,   147,
      91,    71,    71,   119,    89,    42,    43,    72,   125,    90,
     149,   153,   108,    19,    72,   131,    83,   103,    81,    76,
      79,    87,    84,    57,    57,    81,    81,    51,    56,   109,
      62,     9,    20,    35,    37,    39,    45,    49,    53,    57,
      62,    72,   139,    62,    72,   104,    12,    16,    26,    29,
      47,    72,   137,   154,    72,    79,    72,   150,     4,    26,
      72,   120,    72,    72,    90,    57,    72,    57,    61,    68,
     142,    61,    89,    37,    49,    90,    60,    62,    63,    64,
     138,    57,    60,    61,    62,    63,    64,    68,   140,    61,
      61,    62,    34,    90,    90,    90,   141,    57,    60,    60,
     140,    71,    62,    66,    92,    93,    71,    71,   143,    60,
      83,    70,    86,    80,    72,    93,    17,    30,    31,    72,
     155,    53,    62,    72,   144,    90,    60,    62,    62,   140,
      71,   156,   140,   157,    32,    72,   158,    61
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr,					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname[yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      size_t yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

#endif /* YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()
    ;
#endif
#endif
{
  
  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 64:

    { (yyval.string) = (yyvsp[0].string); }
    break;

  case 65:

    { (yyval.string) = (yyvsp[0].string); }
    break;

  case 66:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = (yyvsp[0].string);
	   
	   (yyval.list) = n;
}
    break;

  case 67:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = (yyvsp[0].list);
	   n->string = (yyvsp[-2].string);

	   (yyval.list) = n;
}
    break;

  case 68:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = (yyvsp[0].string);
	   
	   (yyval.list) = n;
}
    break;

  case 69:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = (yyvsp[0].list);
	   n->string = (yyvsp[-2].string);

	   (yyval.list) = n;
}
    break;

  case 70:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = (yyvsp[0].string);
	   
	   (yyval.list) = n;
}
    break;

  case 71:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = (yyvsp[0].list);
	   n->string = (yyvsp[-2].string);

	   (yyval.list) = n;
}
    break;

  case 74:

    {
	   linked_list_t *n = (linked_list_t *) malloc (sizeof(linked_list_t));
	   n->next   = NULL;
	   n->string = (yyvsp[0].string);

	   (yyval.list) = n;
}
    break;

  case 75:

    {
	   linked_list_t *n = (linked_list_t *) malloc (sizeof(linked_list_t));
	   n->next   = (yyvsp[0].list);
	   n->string = (yyvsp[-2].string);

	   (yyval.list) = n;
}
    break;

  case 76:

    {
	   SRV(server)->port = (yyvsp[0].number);
}
    break;

  case 77:

    {
	   SRV(server)->port_tls = (yyvsp[0].number);
}
    break;

  case 78:

    {
	   SRV(server)->listen_to = (yyvsp[0].string);
}
    break;

  case 79:

    {
	   SRV(server)->log_flush_elapse = (yyvsp[0].number);
}
    break;

  case 80:

    {
	   if (strcmp((yyvsp[0].string), "epoll") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_epoll;
	   } else if (strcmp((yyvsp[0].string), "port") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_port;
	   } else if (strcmp((yyvsp[0].string), "kqueue") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_kqueue;
	   } else if (strcmp((yyvsp[0].string), "poll") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_poll;
	   } else if (strcmp((yyvsp[0].string), "select") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_select;
	   } else {
			 PRINT_MSG ("ERROR: Unknown polling method '%s'\n", (yyvsp[0].string));
			 return 1;
	   }
}
    break;

  case 81:

    {
	   char                      *root;
	   int                        root_len;
	   cherokee_virtual_server_t *vserver;

	   vserver = auto_virtual_server;

	   root     = (yyvsp[0].string);
	   root_len = strlen((yyvsp[0].string));

	   /* Check for the endding slash
	    */
	   root = make_finish_with_slash (root, &root_len);

	   /* Add the virtual root path to the virtual server struct
	    */
	   cherokee_buffer_add (vserver->root, root, root_len);
}
    break;

  case 82:

    {
	   ret_t ret;

	   /* Maybe load the module
	    */
	   ret = cherokee_module_loader_load (&SRV(server)->loader, (yyvsp[0].string));
	   if (ret < ret_ok) {
			 PRINT_MSG ("ERROR: Can't load logger module '%s'\n", (yyvsp[0].string));
			 return 1;
	   }

	   cherokee_module_loader_get_info (&SRV(server)->loader, (yyvsp[0].string), &current_module_info);
}
    break;

  case 83:

    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   /* Instance the logger object
	    */
	   cherokee_logger_table_new_logger (SRV(server)->loggers, (yyvsp[-2].string), current_module_info,
								  vserver->logger_props, &vserver->logger);
	   current_module_info = NULL;
}
    break;

  case 88:

    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   if (vserver->logger_props == NULL) {
			 cherokee_table_new (&vserver->logger_props);
	   }

	   cherokee_typed_table_add_str (vserver->logger_props, (yyvsp[-1].string), (yyvsp[0].string));
}
    break;

  case 89:

    {
	   if (!strncasecmp("Product", (yyvsp[0].string), 7)) {
			 SRV(server)->server_token = cherokee_version_product;
	   } else if (!strncasecmp("Minor", (yyvsp[0].string), 5)) {
			 SRV(server)->server_token = cherokee_version_minor;
	   } else if (!strncasecmp("Minimal", (yyvsp[0].string), 7)) {
			 SRV(server)->server_token = cherokee_version_minimal;
	   } else if (!strncasecmp("OS", (yyvsp[0].string), 2)) {
			 SRV(server)->server_token = cherokee_version_os;
	   } else if (!strncasecmp("Full", (yyvsp[0].string), 4)) {
			 SRV(server)->server_token = cherokee_version_full;
	   } else {
			 PRINT_MSG ("ERROR: Unknown server token '%s'\n", (yyvsp[0].string));
			 return 1;
	   }
}
    break;

  case 90:

    {
	   SRV(server)->mime_file = (yyvsp[0].string);
}
    break;

  case 91:

    {
	   ret_t                  ret;
	   cherokee_mime_entry_t *entry;

	   if (SRV(server)->mime == NULL) {
			 ret = cherokee_mime_new (&SRV(server)->mime);
			 if (ret != ret_ok) return 1;
	   }

	   ret = cherokee_mime_get_by_type (SRV(server)->mime, (yyvsp[-1].string), &entry);
	   if (ret != ret_ok) {
			 cherokee_mime_entry_new (&entry);
			 cherokee_mime_add_entry (SRV(server)->mime, entry);
	   }

	   current_mime_entry = entry;
}
    break;

  case 92:

    {
	   current_mime_entry = NULL;
}
    break;

  case 93:

    {
	   cherokee_mime_entry_set_maxage (current_mime_entry, (yyvsp[0].number));
}
    break;

  case 94:

    {
	   ret_t          ret;
	   linked_list_t *i;

	   i = (yyvsp[0].list);
	   while (i != NULL) {			 
			 ret = cherokee_mime_set_by_suffix (SRV(server)->mime, i->string, current_mime_entry);
			 if (ret != ret_ok) return ret;

			 free (i->string);
			 i = i->next;
	   }
}
    break;

  case 95:

    {
	   SRV(server)->icons_file = (yyvsp[0].string);
}
    break;

  case 96:

    {
	   SRV(server)->timeout = (yyvsp[0].number);

	   cherokee_buffer_clean  (SRV(server)->timeout_header);
	   cherokee_buffer_add_va (SRV(server)->timeout_header, "Keep-Alive: timeout=%d"CRLF, (yyvsp[0].number));
}
    break;

  case 97:

    {
	   SRV(server)->keepalive = ((yyvsp[0].number) == 0) ? false : true;
}
    break;

  case 98:

    {
	   SRV(server)->keepalive_max = (yyvsp[0].number);
}
    break;

  case 99:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_cert != NULL) {
			 PRINT_MSG ("ERROR: \"SSLCertificateFile\" overlaps: '%s' <- '%s'\n", vsrv->server_cert, (yyvsp[0].string));
			 free (vsrv->server_cert);
	   }

	   vsrv->server_cert = (yyvsp[0].string);

#else
	   PRINT_MSG_S ("WARNING: Ignoring SSL configuration entry: \"SSLCertificateFile\"\n");
#endif
}
    break;

  case 100:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_key != NULL) {
			 PRINT_MSG ("ERROR: \"SSLCertificateKeyFile\" overlaps: '%s' <- '%s'\n", vsrv->server_key, (yyvsp[0].string));
			 free (vsrv->server_key);
	   }

	   vsrv->server_key = (yyvsp[0].string);

#else
	   PRINT_MSG_S ("WARNING: Ignoring SSL configuration entry: \"SSLCertificateKeyFile\"\n");
#endif
}
    break;

  case 101:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->ca_cert != NULL) {
			 PRINT_MSG ("ERROR: \"SSLCAListFile\" overlaps: '%s' <- '%s'\n", vsrv->ca_cert, (yyvsp[0].string));
			 free (vsrv->ca_cert);
	   }

	   vsrv->ca_cert = (yyvsp[0].string);

#else
	   PRINT_MSG_S ("WARNING: Ignoring SSL configuration entry: \"SSLCAListFile\"\n");
#endif
}
    break;

  case 102:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;
	   cherokee_encoder_table_entry_t *enc;

	   /* Load the module
	    */
	   ret = cherokee_module_loader_load (&SRV(server)->loader, (yyvsp[0].string));
	   if (ret < ret_ok) {
			 PRINT_MSG ("ERROR: Can't load encoder module '%s'\n", (yyvsp[0].string));
			 return 1;
	   }

	   cherokee_module_loader_get_info  (&SRV(server)->loader, (yyvsp[0].string), &info);

	   /* Set the info in the new entry
	    */
	   cherokee_encoder_table_entry_new (&enc);
	   cherokee_encoder_table_entry_get_info (enc, info);

	   /* Set in the encoders table
	    */
	   cherokee_encoder_table_set (SRV(server)->encoders, (yyvsp[0].string), enc);
	   current_encoder_entry = enc;
}
    break;

  case 103:

    {
	   current_encoder_entry = NULL;
}
    break;

  case 106:

    {
	   linked_list_t            *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = (yyvsp[0].list);
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_allow (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 107:

    {
	   linked_list_t            *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = (yyvsp[0].list);
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_deny (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 108:

    {
	   FILE *file;
	   CHEROKEE_TEMP(buffer, 10);

	   file = fopen ((yyvsp[0].string), "w");
	   if (file == NULL) {
			 PRINT_MSG ("ERROR: Can't write PID file '%s': %s\n", (yyvsp[0].string), strerror(errno));
			 return 0;
	   }

	   snprintf (buffer, buffer_size, "%d\n", getpid());
	   fwrite (buffer, 1, strlen(buffer), file);
	   fclose (file);

	   free ((yyvsp[0].string));
}
    break;

  case 109:

    {
	   if (SRV(server)->panic_action != NULL) {
			 PRINT_MSG ("WARNING: Overwriting panic action '%s' by '%s'\n", SRV(server)->panic_action, (yyvsp[0].string));
			 free (SRV(server)->panic_action);
	   }

	   SRV(server)->panic_action = (yyvsp[0].string);
}
    break;

  case 110:

    {
	   SRV(server)->listen_queue = (yyvsp[0].number);
}
    break;

  case 112:

    {
	   SRV(server)->sendfile.min = (yyvsp[0].number);
}
    break;

  case 113:

    {
	   SRV(server)->sendfile.max = (yyvsp[0].number);
}
    break;

  case 114:

    {
	   SRV(server)->max_fds = (yyvsp[0].number);
}
    break;

  case 115:

    {
	   SRV(server)->max_conn_reuse = (yyvsp[0].number);
}
    break;

  case 116:

    {
	   SRV(server)->chroot = (yyvsp[0].string);
}
    break;

  case 117:

    {
#ifdef HAVE_PTHREAD
	   SRV(server)->thread_num = (yyvsp[-1].number);
#endif
}
    break;

  case 120:

    {
#ifdef HAVE_PTHREAD
	   if (strcasecmp((yyvsp[0].string), "fifo") == 0) {
			 SRV(server)->thread_policy = SCHED_FIFO;
	   } else if (strcasecmp((yyvsp[0].string), "rr") == 0) {
			 SRV(server)->thread_policy = SCHED_RR;
	   } else if (strcasecmp((yyvsp[0].string), "other") == 0) {
			 SRV(server)->thread_policy = SCHED_OTHER;
	   } else {
			 PRINT_MSG ("ERROR: unknown scheduling policy '%s'\n", (yyvsp[0].string));
	   }
#endif
}
    break;

  case 121:

    {
	   SRV(server)->ipv6 = (yyvsp[0].number);
}
    break;

  case 122:

    {
	   struct passwd *pwd;
	   
	   pwd = (struct passwd *) getpwnam ((yyvsp[0].string));
	   if (pwd == NULL) {
			 PRINT_MSG ("ERROR: User '%s' not found in the system", (yyvsp[0].string));
			 return 1;
	   }

	   SRV(server)->user = pwd->pw_uid;

	   free ((yyvsp[0].string));
}
    break;

  case 123:

    {
	   SRV(server)->user = (yyvsp[0].number);
}
    break;

  case 124:

    {
	   struct group *grp;

	   grp = (struct group *) getgrnam ((yyvsp[0].string));
	   if (grp == NULL) {
			 PRINT_MSG ("ERROR: Group '%s' not found in the system", (yyvsp[0].string));
			 return 1;
	   }

	   SRV(server)->group = grp->gr_gid;

	   free ((yyvsp[0].string));
}
    break;

  case 125:

    {
	   SRV(server)->group = (yyvsp[0].number);
}
    break;

  case 126:

    {
	   (yyval.name_ptr).name = (yyvsp[-3].string);
	   (yyval.name_ptr).ptr = current_config_entry;
}
    break;

  case 127:

    {
	   (yyval.name_ptr).name = (yyvsp[0].string);
	   (yyval.name_ptr).ptr = current_config_entry;
}
    break;

  case 128:

    { (yyval.string) = (yyvsp[0].string); }
    break;

  case 129:

    { (yyval.string) = (yyvsp[0].string); }
    break;

  case 130:

    {
	   handler_redir_add_property (current_config_entry, (yyvsp[-1].string), (yyvsp[0].string), 1);
}
    break;

  case 131:

    {
	   handler_redir_add_property (current_config_entry, (yyvsp[-1].string), (yyvsp[0].string), 0);
}
    break;

  case 132:

    {
	   handler_redir_add_property_simple (current_config_entry, (yyvsp[0].string), 1);
}
    break;

  case 133:

    {
	   handler_redir_add_property_simple (current_config_entry, (yyvsp[0].string), 0);
}
    break;

  case 139:

    { 
	   (yyval.string) = (yyvsp[0].string); 
}
    break;

  case 140:

    {
	   if (!strcasecmp ((yyvsp[-1].string), "bgcolor")) {
			 dirs_table_set_handler_prop (current_config_entry, "bgcolor", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "background")) {
			 dirs_table_set_handler_prop (current_config_entry, "background", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "text")) {
			 dirs_table_set_handler_prop (current_config_entry, "text", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "link")) {
			 dirs_table_set_handler_prop (current_config_entry, "link", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "vlink")) {
			 dirs_table_set_handler_prop (current_config_entry, "vlink", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "alink")) {
			 dirs_table_set_handler_prop (current_config_entry, "alink", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "interpreter")) {
			 dirs_table_set_handler_prop (current_config_entry, "interpreter", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "scriptalias")) {
			 dirs_table_set_handler_prop (current_config_entry, "scriptalias", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "url")) {
			 dirs_table_set_handler_prop (current_config_entry, "url", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "filedir")) {
			 dirs_table_set_handler_prop (current_config_entry, "filedir", (yyvsp[0].string));
	   } else if (!strcasecmp ((yyvsp[-1].string), "changeuser")) {
			 cherokee_config_entry_set_handler_prop (current_config_entry, "changeuser", typed_int, INT_TO_POINTER((yyvsp[0].string)), NULL);
	   } else {
			 return 1;
	   }
}
    break;

  case 141:

    {
	   if (!strcasecmp ((yyvsp[-1].string), "changeuser")) {
			 cherokee_config_entry_set_handler_prop (current_config_entry, "changeuser", typed_int, INT_TO_POINTER((yyvsp[0].number)), NULL);
	   } else if (!strcasecmp ((yyvsp[-1].string), "iocache")) {
			 cherokee_config_entry_set_handler_prop (current_config_entry, "cache", typed_int, INT_TO_POINTER((yyvsp[0].number)), NULL);
	   } else if (!strcasecmp ((yyvsp[-1].string), "errorhandler")) {
			 return 1;
	   }
}
    break;

  case 142:

    {
	   cherokee_config_entry_set_handler_prop (current_config_entry, "error_handler", typed_int, INT_TO_POINTER((yyvsp[0].number)), NULL);
}
    break;

  case 143:

    {
	   cherokee_config_entry_set_handler_prop (current_config_entry, "show_headerfile", typed_int, INT_TO_POINTER((yyvsp[0].number)), NULL);
}
    break;

  case 144:

    {
	   linked_list_t *i;
	   list_t         nlist = LIST_HEAD_INIT(nlist);

	   i = (yyvsp[0].list);
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_list_add_tail (&nlist, i->string);

			 prev = i;
			 i = i->next;
			 free(prev);
	   }	   

	   cherokee_config_entry_set_handler_prop (current_config_entry, "headerfile", typed_list, &nlist, 
									   (cherokee_typed_free_func_t) cherokee_list_free_item_simple);
}
    break;

  case 145:

    {
	   int re;

	   re = add_key_val_entry_in_property (current_config_entry->handler_properties, "env", (yyvsp[-1].string), (yyvsp[0].string));
	   if (re != 0) return re;
}
    break;

  case 146:

    { dirs_table_set_handler_prop (current_config_entry, "socket", (yyvsp[0].string)); }
    break;

  case 147:

    { cherokee_config_entry_set_handler_prop (current_config_entry, "about", typed_int, INT_TO_POINTER(1), NULL); }
    break;

  case 148:

    { 
	   list_t                  nlist        = LIST_HEAD_INIT(nlist);
	   list_t                 *plist        = NULL;
	   cherokee_table_t       *properties;
	   cherokee_fcgi_server_t *server_entry = NULL;
	   
	   /* Add the new entry to the list
	    */
	   properties = current_config_entry->handler_properties;

	   if (properties != NULL) {
			 cherokee_typed_table_get_list (properties, "servers", &plist);
	   }

	   /* The list is new
	    */
	   if (plist == NULL) {
			 cherokee_fcgi_server_first_new (&server_entry);

			 list_add ((list_t *)server_entry, &nlist);
			 cherokee_config_entry_set_handler_prop (current_config_entry, "servers", typed_list, &nlist, 
											 (cherokee_typed_free_func_t) cherokee_fcgi_server_free);
	   } 
	   /* Add to an existing list
	    */
	   else {
			 cherokee_fcgi_server_new (&server_entry);
			 list_add_tail ((list_t *)server_entry, plist);
	   }

	   current_fastcgi_server = server_entry;
	   cherokee_buffer_add (&server_entry->host, (yyvsp[0].string), strlen((yyvsp[0].string)));

}
    break;

  case 150:

    { (yyval.string) = (yyvsp[0].string); }
    break;

  case 151:

    { (yyval.string) = (yyvsp[0].string); }
    break;

  case 154:

    {
	   ret_t ret;

	   ret = cherokee_fcgi_server_add_env (current_fastcgi_server, (yyvsp[-1].string), (yyvsp[0].string));
	   if (ret != ret_ok) return 1;
}
    break;

  case 155:

    {
	   if (strcasecmp((yyvsp[-1].string), "interpreter") != 0) return 1;
	   cherokee_buffer_add (&current_fastcgi_server->interpreter, (yyvsp[0].string), strlen((yyvsp[0].string)));
}
    break;

  case 156:

    {
	   char code[4];

	   if (((yyvsp[-1].number) < 100) || ((yyvsp[-1].number) >= http_type_500_max)) {
			 PRINT_MSG ("ERROR: Incorrect HTTP code number %d\n", (yyvsp[-1].number));
			 return 1;
	   }

	   snprintf (code, 4, "%d", (yyvsp[-1].number));
	   dirs_table_set_handler_prop (current_config_entry, code, (yyvsp[0].string));
}
    break;

  case 157:

    {
	   linked_list_t *i;

	   i = (yyvsp[0].list);
	   while (i != NULL) {
			 if ((!strncasecmp (i->string, "date",  4)) ||
				(!strncasecmp (i->string, "size",  4)) ||
				(!strncasecmp (i->string, "group", 5)) ||
				(!strncasecmp (i->string, "owner", 5)))
			 {
				    char *lower;

				    lower = new_string_to_lowercase (i->string);
				    free (i->string);
				    i->string = lower;

				    cherokee_config_entry_set_handler_prop (current_config_entry, 
													   i->string, typed_int, INT_TO_POINTER(1), NULL);
			 } else {
				    PRINT_MSG ("ERROR: Unknown parameter '%s' for \"Show\"", i->string);
			 }
				
			 i = i->next;
	   }

	   free_linked_list ((yyvsp[0].list), free);
}
    break;

  case 160:

    {
	   (yyval.string) = (yyvsp[0].string);
}
    break;

  case 161:

    {
	   linked_list_t *i = (yyvsp[-1].list);
	   CHEROKEE_NEW(vsrv, virtual_server);

	   current_virtual_server = vsrv;
	   current_dirs_table     = &vsrv->dirs;

	   /* Add the virtual server to the list
	    */
	   list_add ((list_t *)vsrv, &SRV(server)->vservers);

	   /* Add default virtual server name
	    */
	   if (i->string != NULL) {
			 cherokee_buffer_t *name = current_virtual_server->name;

			 if (cherokee_buffer_is_empty (name)) {
				    cherokee_buffer_add_va (name, "%s", i->string);
			 }
	   }

	   /* Add all the alias to the table
	    */
	   while (i != NULL) {
			 cherokee_table_add (SRV(server)->vservers_ref, i->string, vsrv);
			 i = i->next;
	   }
	   free_linked_list ((yyvsp[-1].list), NULL);

}
    break;

  case 162:

    {

	   current_virtual_server = NULL;
	   current_dirs_table  = NULL;
}
    break;

  case 163:

    {
	   /* Fill the tmp struct
	    */
	   extension_content_tmp.exts_list      = (yyvsp[-1].list);
	   extension_content_tmp.vserver        = auto_virtual_server;
	   extension_content_tmp.entry          = config_entry_new (); /* new! */
	   extension_content_tmp.handler_name   = NULL;
	   extension_content_tmp.document_root  = NULL;

	   /* Extensions table is created under demand
	    */
	   if (extension_content_tmp.vserver->exts == NULL) {
			 ret_t ret;

			 ret = cherokee_exts_table_new (&extension_content_tmp.vserver->exts);
			 if (unlikely (ret != ret_ok)) {
				    PRINT_MSG_S ("ERROR: Couldn't instance a new exts table object\n");
				    return 1;
			 }
	   }
	   extension_content_tmp.exts = extension_content_tmp.vserver->exts;
}
    break;

  case 164:

    {
	   ret_t                   ret;
	   linked_list_t          *i;
	   cherokee_module_info_t *info;

	   /* Does this directory have a handler
	    */
	   if (extension_content_tmp.handler_name != NULL) {
			 int re;
			 re = load_module (&SRV(server)->loader, extension_content_tmp.handler_name, &info);
			 if (re != 0) return 1;
	   
			 cherokee_config_entry_set_handler (extension_content_tmp.entry, info);	   
	   }

	   /* Add "web_dir -> entry" in the dirs table
	    */
	   i = extension_content_tmp.exts_list;
	   while (i != NULL) {
			 ret = cherokee_exts_table_has (extension_content_tmp.exts, i->string);
			 if (ret != ret_not_found) {
				    PRINT_MSG ("ERROR: Extension '%s' was already set\n", i->string);
				    return 1;
			 }

			 ret = cherokee_exts_table_add (extension_content_tmp.exts,
									  i->string,
									  extension_content_tmp.entry);
			 if (ret != ret_ok) {
				    switch (ret) {
				    case ret_file_not_found:
						  PRINT_MSG ("ERROR: Can't load handler '%s': File not found\n",
								   extension_content_tmp.handler_name);
						  break;
				    default:
						  PRINT_MSG ("ERROR: Can't load handler '%s': Unknown error\n",
								   extension_content_tmp.handler_name);
				    }
			 }

			 i = i->next;
	   }

	   /* Clean
	    */
	   if (extension_content_tmp.document_root != NULL) {
			 free (extension_content_tmp.document_root);
			 extension_content_tmp.document_root = NULL;
	   }

	   extension_content_tmp.vserver       = NULL;
	   extension_content_tmp.exts          = NULL;
	   extension_content_tmp.entry         = NULL;
	   extension_content_tmp.handler_name  = NULL;

	   free_linked_list (extension_content_tmp.exts_list, free);
	   extension_content_tmp.exts_list = NULL;

	   current_config_entry = NULL;
}
    break;

  case 165:

    {
	   /* Fill the tmp struct
	    */
	   directory_content_tmp.directory_name = (yyvsp[-1].string);
	   directory_content_tmp.vserver        = auto_virtual_server;
	   directory_content_tmp.dirs           = auto_dirs_table;
	   directory_content_tmp.entry          = config_entry_new (); /* new! */
	   directory_content_tmp.handler_name   = NULL;
	   directory_content_tmp.document_root  = NULL;
}
    break;

  case 166:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;

	   /* Set the document_root in the entry
	    */
	   if (directory_content_tmp.document_root != NULL) {
			 if (directory_content_tmp.entry->document_root == NULL)
				    cherokee_buffer_new (&directory_content_tmp.entry->document_root);
			 else 
				    cherokee_buffer_clean (directory_content_tmp.entry->document_root);

			 cherokee_buffer_add_va (directory_content_tmp.entry->document_root, "%s",
								directory_content_tmp.document_root);
	   }

	   /* Does this directory have a handler
	    */
	   if (directory_content_tmp.handler_name != NULL) {
			 int re;
			 re = load_module (&SRV(server)->loader, directory_content_tmp.handler_name, &info);
			 if (re != 0) return 1;
	   
			 cherokee_config_entry_set_handler (directory_content_tmp.entry, info);	   
	   }
	   
	   /* Add "web_dir -> entry" in the dirs table
	    */
	   ret = cherokee_dirs_table_add (directory_content_tmp.dirs,
							    directory_content_tmp.directory_name,
							    directory_content_tmp.entry);
	   if (ret != ret_ok) {
			 switch (ret) {
			 case ret_file_not_found:
				    PRINT_MSG ("ERROR: Can't load handler '%s': File not found\n",
							directory_content_tmp.handler_name);
				    break;
			 default:
				    PRINT_MSG ("ERROR: Can't load handler '%s': Unknown error\n",
							directory_content_tmp.handler_name);
			 }
	   }

	   cherokee_dirs_table_relink (directory_content_tmp.dirs);

	   /* Clean
	    */
	   if (directory_content_tmp.document_root != NULL) {
			 free (directory_content_tmp.document_root);
			 directory_content_tmp.document_root = NULL;
	   }
	   directory_content_tmp.vserver       = NULL;
	   directory_content_tmp.dirs          = NULL;
	   directory_content_tmp.entry         = NULL;
	   directory_content_tmp.handler_name  = NULL;

	   current_config_entry = NULL;
}
    break;

  case 167:

    {
	   /* Fill the tmp struct
	    */
	   request_content_tmp.vserver        = auto_virtual_server;
	   request_content_tmp.reqs           = auto_reqs_table;
	   request_content_tmp.entry          = reqs_list_entry_new (); /* new! */
	   request_content_tmp.handler_name   = NULL;
	   request_content_tmp.document_root  = NULL;
	   
	   cherokee_buffer_add (&(request_content_tmp.entry->request), (yyvsp[-1].string), strlen((yyvsp[-1].string)));
}
    break;

  case 168:

    {
	   ret_t                   ret;
	   cherokee_module_info_t *info;

	   /* Does this directory have a handler
	    */
	   if (request_content_tmp.handler_name != NULL) {
			 int re;
			 re = load_module (&SRV(server)->loader, request_content_tmp.handler_name, &info);
			 if (re != 0) return 1;
	   
			 cherokee_config_entry_set_handler ((cherokee_config_entry_t *)request_content_tmp.entry, info);	   
	   }

	   /* Add the new entry
	    */
	   ret = cherokee_reqs_list_add (request_content_tmp.reqs, request_content_tmp.entry, SRV(server)->regexs);
	   if (ret != ret_ok) return 1;

	   /* Clean
	    */
	   if (request_content_tmp.document_root != NULL) {
			 free (request_content_tmp.document_root);
			 request_content_tmp.document_root = NULL;
	   }

	   request_content_tmp.vserver       = NULL;
	   request_content_tmp.reqs          = NULL;
	   request_content_tmp.entry         = NULL;
	   request_content_tmp.handler_name  = NULL;
}
    break;

  case 169:

    {	   
	   directory_content_tmp.handler_name = (yyvsp[0].name_ptr).name;
	   extension_content_tmp.handler_name = (yyvsp[0].name_ptr).name;
	   request_content_tmp.handler_name   = (yyvsp[0].name_ptr).name;
}
    break;

  case 170:

    {
	   if (directory_content_tmp.document_root != NULL) {
			 PRINT_MSG ("WARNING: Overwriting DocumentRoot '%s' by '%s'\n",
					  directory_content_tmp.document_root, (yyvsp[0].string));

			 free (directory_content_tmp.document_root);
	   }

	   directory_content_tmp.document_root = make_slash_end ((yyvsp[0].string));
}
    break;

  case 171:

    {
	   linked_list_t               *i     = (yyvsp[-3].list);
	   cherokee_config_entry_t *entry = current_config_entry;

	   while (i != NULL) {
			 if (strncasecmp(i->string, "basic", 5) == 0) {
				    entry->authentication |= http_auth_basic;
			 } 
			 else if (strncasecmp(i->string, "digest", 6) == 0) {
				    entry->authentication |= http_auth_digest;			 
			 }
			 else {
				    PRINT_MSG ("ERROR: Unknown authentication type '%s'\n", i->string);
				    return 1;
			 }

			 i = i->next;
	   }

	   free_linked_list ((yyvsp[-3].list), free);
}
    break;

  case 172:

    {
	   ret_t ret;
	   linked_list_t *i, *prev;
	   CHEROKEE_NEW(n, access);

	   i = (yyvsp[0].list);
	   while (i != NULL) {
			 ret = cherokee_access_add (n, i->string);
			 if (ret != ret_ok) return 1;

			 free (i->string);
			 prev = i;
			 i = i->next;
			 free (prev);
	   }

	   current_config_entry->access = n;
}
    break;

  case 173:

    {
#ifndef HAVE_TLS
	   PRINT_MSG_S ("WARNING: Ignoring SSL configuration entry: \"OnlySecure\"\n");
#endif

	   current_config_entry->only_secure = true;
}
    break;

  case 174:

    {
	   cherokee_buffer_t *realm;

	   if (current_config_entry->auth_realm == NULL) 
			 cherokee_buffer_new (&current_config_entry->auth_realm);

	   realm = current_config_entry->auth_realm;


	   cherokee_buffer_add (realm, (yyvsp[0].string), strlen((yyvsp[0].string)));
	   free ((yyvsp[0].string));
}
    break;

  case 175:

    {
	   linked_list_t *i;

	   if (current_config_entry->users == NULL) {
			 cherokee_table_new (&current_config_entry->users);
	   }

	   i = (yyvsp[0].list);
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_table_add (current_config_entry->users, i->string, NULL);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }	   
}
    break;

  case 176:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;

	   ret = cherokee_module_loader_load (&SRV(server)->loader, (yyvsp[-1].string));
	   if (ret != ret_ok) {
			 PRINT_MSG ("ERROR: Can't load validator module '%s'\n", (yyvsp[-1].string));
			 return 1;
	   }

	   cherokee_module_loader_get_info  (&SRV(server)->loader, (yyvsp[-1].string), &info);

	   if (info->type != cherokee_validator) {
			 PRINT_MSG ("ERROR: %s is not a validator module!!\n", (yyvsp[-1].string));
	   }


	   current_config_entry->validator_new_func = info->new_func;
}
    break;

  case 181:

    { dirs_table_set_validator_prop (current_config_entry, "file", (yyvsp[0].string)); }
    break;

  case 182:

    {
	   int   len;
	   char *tmp;
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   /* Set the users public directory
	    */
	   if (!cherokee_buffer_is_empty (vsrv->userdir)) {
			 PRINT_MSG ("WARNING: Overwriting userdir '%s'\n", vsrv->userdir->buf);
			 cherokee_buffer_clean (vsrv->userdir);
	   }

	   len = strlen((yyvsp[0].string));
	   tmp = make_finish_with_slash ((yyvsp[0].string), &len);
	   cherokee_buffer_add (vsrv->userdir, tmp, len);

	   /* Set the plugin table reference
	    */
	   current_dirs_table = vsrv->userdir_dirs;

}
    break;

  case 183:

    {

	   /* Remove the references
	    */
	   current_dirs_table = NULL;
}
    break;

  case 184:

    {
	   linked_list_t             *i    = (yyvsp[0].list);
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   while (i != NULL) {
			 cherokee_list_add_tail (&vsrv->index_list, i->string);
			 i = i->next;
	   }

	   free_linked_list ((yyvsp[0].list), NULL);
}
    break;

  case 187:

    {
	   ret_t                      ret;
	   cherokee_module_info_t    *info;
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   /* Load the module
	    */
	   ret = cherokee_module_loader_load (&SRV(server)->loader, (yyvsp[0].string));
	   if (ret < ret_ok) {
			 PRINT_MSG ("ERROR: Loading module '%s'\n", (yyvsp[0].string));
			 return 1;
	   }

	   ret = cherokee_module_loader_get_info (&SRV(server)->loader, (yyvsp[0].string), &info);
	   if (ret < ret_ok) {
			 PRINT_MSG ("ERROR: Loading module '%s'\n", (yyvsp[0].string));
			 return 1;
	   }
	   
	   /* Remove the old (by default) error handler and cretate a new one
	    */
	   vsrv->error_handler = config_entry_new();

	   /* Setup the loaded module
	    */
	   cherokee_config_entry_set_handler (vsrv->error_handler, info);
}
    break;


      default: break;
    }

/* Line 1126 of yacc.c.  */


  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  int yytype = YYTRANSLATE (yychar);
	  YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
	  YYSIZE_T yysize = yysize0;
	  YYSIZE_T yysize1;
	  int yysize_overflow = 0;
	  char *yymsg = 0;
#	  define YYERROR_VERBOSE_ARGS_MAXIMUM 5
	  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
	  int yyx;

#if 0
	  /* This is so xgettext sees the translatable formats that are
	     constructed on the fly.  */
	  YY_("syntax error, unexpected %s");
	  YY_("syntax error, unexpected %s, expecting %s");
	  YY_("syntax error, unexpected %s, expecting %s or %s");
	  YY_("syntax error, unexpected %s, expecting %s or %s or %s");
	  YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
#endif
	  char *yyfmt;
	  char const *yyf;
	  static char const yyunexpected[] = "syntax error, unexpected %s";
	  static char const yyexpecting[] = ", expecting %s";
	  static char const yyor[] = " or %s";
	  char yyformat[sizeof yyunexpected
			+ sizeof yyexpecting - 1
			+ ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
			   * (sizeof yyor - 1))];
	  char const *yyprefix = yyexpecting;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 1;

	  yyarg[0] = yytname[yytype];
	  yyfmt = yystpcpy (yyformat, yyunexpected);

	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
		  {
		    yycount = 1;
		    yysize = yysize0;
		    yyformat[sizeof yyunexpected - 1] = '\0';
		    break;
		  }
		yyarg[yycount++] = yytname[yyx];
		yysize1 = yysize + yytnamerr (0, yytname[yyx]);
		yysize_overflow |= yysize1 < yysize;
		yysize = yysize1;
		yyfmt = yystpcpy (yyfmt, yyprefix);
		yyprefix = yyor;
	      }

	  yyf = YY_(yyformat);
	  yysize1 = yysize + yystrlen (yyf);
	  yysize_overflow |= yysize1 < yysize;
	  yysize = yysize1;

	  if (!yysize_overflow && yysize <= YYSTACK_ALLOC_MAXIMUM)
	    yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg)
	    {
	      /* Avoid sprintf, as that infringes on the user's name space.
		 Don't have undefined behavior even if the translation
		 produced a string with the wrong number of "%s"s.  */
	      char *yyp = yymsg;
	      int yyi = 0;
	      while ((*yyp = *yyf))
		{
		  if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		    {
		      yyp += yytnamerr (yyp, yyarg[yyi++]);
		      yyf += 2;
		    }
		  else
		    {
		      yyp++;
		      yyf++;
		    }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    {
	      yyerror (YY_("syntax error"));
	      goto yyexhaustedlab;
	    }
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror (YY_("syntax error"));
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
        }
      else
	{
	  yydestruct ("Error: discarding", yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (0)
     goto yyerrorlab;

yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping", yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token. */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK;
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}






