/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <stdlib.h>
#include <string.h>

#include "handler.h"


ret_t
cherokee_handler_init_base (cherokee_handler_t *hdl)
{
	   hdl->redirect   = NULL;
	   
	   /* Pure virtual methods
	    */
	   hdl->init        = NULL;
	   hdl->free        = NULL;
	   hdl->step        = NULL;
	   hdl->add_headers = NULL;

	   return ret_ok;
}




/* 	Virtual method hidding layer
 */
ret_t
cherokee_handler_free (cherokee_handler_t *hdl)
{
	if (hdl->redirect) {
		free (hdl->redirect);
		hdl->redirect = NULL;
	}
	
	if (hdl->free)
		return hdl->free (hdl);
	
	return ret_error;
}


inline ret_t
cherokee_handler_init (cherokee_handler_t *hdl)
{
	if (hdl->init)
		return hdl->init (hdl);
	
	return ret_error;
}


inline ret_t
cherokee_handler_step (cherokee_handler_t *hdl, cherokee_buffer_t *buffer)
{
	if (hdl->step)
		return hdl->step (hdl, buffer);
	
	return ret_error;
}


inline ret_t
cherokee_handler_add_headers (cherokee_handler_t *hdl, cherokee_buffer_t *buffer)
{
	if (hdl->add_headers)
		return hdl->add_headers (hdl, buffer);

	return ret_error;
}

