/* A Bison parser, made by GNU Bison 1.875d.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     T_QUOTE = 258,
     T_DENY = 259,
     T_THREAD_NUM = 260,
     T_SSL_CERT_KEY_FILE = 261,
     T_SSL_CERT_FILE = 262,
     T_KEEPALIVE_MAX_REQUESTS = 263,
     T_ERROR_HANDLER = 264,
     T_TIMEOUT = 265,
     T_KEEPALIVE = 266,
     T_DOCUMENT_ROOT = 267,
     T_LOG = 268,
     T_MIME_FILE = 269,
     T_DIRECTORY = 270,
     T_HANDLER = 271,
     T_USER = 272,
     T_GROUP = 273,
     T_POLICY = 274,
     T_SERVER = 275,
     T_USERDIR = 276,
     T_URL = 277,
     T_PIDFILE = 278,
     T_LISTEN = 279,
     T_FILEDIR = 280,
     T_SERVER_TOKENS = 281,
     T_ENCODER = 282,
     T_ALLOW = 283,
     T_BGCOLOR = 284,
     T_TEXT = 285,
     T_LINK = 286,
     T_ALINK = 287,
     T_VLINK = 288,
     T_BACKGROUND = 289,
     T_DIRECTORYINDEX = 290,
     T_IPV6 = 291,
     T_SHOW = 292,
     T_CHROOT = 293,
     T_HEADER_FILE = 294,
     T_ICONS = 295,
     T_AUTH = 296,
     T_NAME = 297,
     T_METHOD = 298,
     T_PASSWDFILE = 299,
     T_SSL_CA_LIST_FILE = 300,
     T_FROM = 301,
     T_SOCKET = 302,
     T_LOG_FLUSH_INTERVAL = 303,
     T_INCLUDE = 304,
     T_PANIC_ACTION = 305,
     T_JUST_ABOUT = 306,
     T_LISTEN_QUEUE_SIZE = 307,
     T_SENDFILE = 308,
     T_MINSIZE = 309,
     T_MAXSIZE = 310,
     T_MAX_FDS = 311,
     T_INTERPRETER = 312,
     T_SCRIPT_ALIAS = 313,
     T_ONLY_SECURE = 314,
     T_MAX_CONNECTION_REUSE = 315,
     T_REWRITE = 316,
     T_POLL_METHOD = 317,
     T_EXTENSION = 318,
     T_NUMBER = 319,
     T_PORT = 320,
     T_QSTRING = 321,
     T_FULLDIR = 322,
     T_ID = 323,
     T_HTTP_URL = 324,
     T_HTTPS_URL = 325,
     T_HOSTNAME = 326,
     T_IP = 327,
     T_DOMAIN_NAME = 328,
     T_ADDRESS_PORT = 329
   };
#endif
#define T_QUOTE 258
#define T_DENY 259
#define T_THREAD_NUM 260
#define T_SSL_CERT_KEY_FILE 261
#define T_SSL_CERT_FILE 262
#define T_KEEPALIVE_MAX_REQUESTS 263
#define T_ERROR_HANDLER 264
#define T_TIMEOUT 265
#define T_KEEPALIVE 266
#define T_DOCUMENT_ROOT 267
#define T_LOG 268
#define T_MIME_FILE 269
#define T_DIRECTORY 270
#define T_HANDLER 271
#define T_USER 272
#define T_GROUP 273
#define T_POLICY 274
#define T_SERVER 275
#define T_USERDIR 276
#define T_URL 277
#define T_PIDFILE 278
#define T_LISTEN 279
#define T_FILEDIR 280
#define T_SERVER_TOKENS 281
#define T_ENCODER 282
#define T_ALLOW 283
#define T_BGCOLOR 284
#define T_TEXT 285
#define T_LINK 286
#define T_ALINK 287
#define T_VLINK 288
#define T_BACKGROUND 289
#define T_DIRECTORYINDEX 290
#define T_IPV6 291
#define T_SHOW 292
#define T_CHROOT 293
#define T_HEADER_FILE 294
#define T_ICONS 295
#define T_AUTH 296
#define T_NAME 297
#define T_METHOD 298
#define T_PASSWDFILE 299
#define T_SSL_CA_LIST_FILE 300
#define T_FROM 301
#define T_SOCKET 302
#define T_LOG_FLUSH_INTERVAL 303
#define T_INCLUDE 304
#define T_PANIC_ACTION 305
#define T_JUST_ABOUT 306
#define T_LISTEN_QUEUE_SIZE 307
#define T_SENDFILE 308
#define T_MINSIZE 309
#define T_MAXSIZE 310
#define T_MAX_FDS 311
#define T_INTERPRETER 312
#define T_SCRIPT_ALIAS 313
#define T_ONLY_SECURE 314
#define T_MAX_CONNECTION_REUSE 315
#define T_REWRITE 316
#define T_POLL_METHOD 317
#define T_EXTENSION 318
#define T_NUMBER 319
#define T_PORT 320
#define T_QSTRING 321
#define T_FULLDIR 322
#define T_ID 323
#define T_HTTP_URL 324
#define T_HTTPS_URL 325
#define T_HOSTNAME 326
#define T_IP 327
#define T_DOMAIN_NAME 328
#define T_ADDRESS_PORT 329




/* Copy the first part of user declarations.  */


/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common-internal.h"

#include <pwd.h>
#include <grp.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <ctype.h>
#include <strings.h>

#include "table.h"
#include "mime.h"
#include "server.h"
#include "server-protected.h"
#include "virtual_server.h"
#include "dirs_table_entry.h"
#include "encoder.h"
#include "logger_table.h"
#include "access.h"
#include "list_ext.h"


/* Define the parameter name of the yyparse() argument
 */
#define YYPARSE_PARAM server



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)

typedef union YYSTYPE {
	   int   number;
	   char *string;
	   void *ptr;

	   struct {
			 char *name;
			 void *ptr;
	   } name_ptr;

	   void *list;
} YYSTYPE;
/* Line 191 of yacc.c.  */

# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* What is the right way to import this prototipe?
 */
extern int yylex (void);


extern char *yytext;
extern int   yylineno;

char                                   *current_yacc_file           = NULL;
static cherokee_dirs_table_t           *current_dirs_table          = NULL;
static cherokee_dirs_table_entry_t     *current_dirs_table_entry    = NULL;
static cherokee_virtual_server_t       *current_virtual_server      = NULL;
static cherokee_encoder_table_entry_t  *current_encoder_entry       = NULL;
static cherokee_module_info_t          *current_module_info         = NULL;

typedef struct {
	   void *next;
	   char *string;
} linked_list_t;

struct {
	   char                           *handler_name;
	   cherokee_dirs_table_entry_t    *entry;
	   cherokee_virtual_server_t      *vserver;
	   cherokee_dirs_table_t          *dirs;
	   char                           *document_root;
	   char                           *directory_name;
} directory_content_tmp;

struct {
	   char                           *handler_name;
	   cherokee_dirs_table_entry_t    *entry;
	   cherokee_virtual_server_t      *vserver;
	   cherokee_exts_table_t          *exts;
	   char                           *document_root;
	   linked_list_t                  *exts_list;
} extension_content_tmp;


#define auto_virtual_server ((current_virtual_server) ? current_virtual_server : SRV(server)->vserver_default)
#define auto_dirs_table     ((current_dirs_table) ? current_dirs_table : &(auto_virtual_server)->dirs)


static void
free_linked_list (linked_list_t *list, void (*free_func) (void *))
{
	   linked_list_t *i = list;

	   while (i != NULL) {
			 linked_list_t *prev = i;

			 if ((free_func) && (i->string)) {
				    free_func (i->string);
			 }

			 prev = i;
			 i = i->next;
			 free (prev);
	   }	   
}

static char *
make_finish_with_slash (char *string, int *len)
{
	   char *new;
	   int   new_len;

	   if (string[(*len)-1] == '/') {
			 return string;
	   }

	   new_len = (*len) + 2;
	   new  = (char*) malloc (new_len);

	   *len = snprintf (new, new_len, "%s/", string);

	   free (string);
	   return new;
}

static char *
make_slash_end (char *string)
{
	   int len = strlen(string);
	   return make_finish_with_slash (string, &len);
}

static cherokee_dirs_table_entry_t *
dirs_table_entry_new (void)
{
	   cherokee_dirs_table_entry_t *entry;

	   cherokee_dirs_table_entry_new (&entry);
	   current_dirs_table_entry = entry;

	   return entry;
}

static char *
new_string_to_lowercase (const char *in)
{
	   int   i;
	   char *tmp;
	   
	   i = strlen(in);
	   tmp = (char *) malloc (i+1);
	   tmp[i] = '\0';

	   while (i--) {
			 tmp[i] = tolower(in[i]);
	   }

	   return tmp;
}

static int
load_module (cherokee_module_loader_t *loader, char *name, cherokee_module_info_t **info)
{
	   ret_t ret;

	   ret = cherokee_module_loader_load (loader, name);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Loading module '%s'\n", name);
			 return 1;
	   }
	   
	   ret = cherokee_module_loader_get (loader, name, info);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Loading module '%s'\n", name);
			 return 1;
	   }

	   return 0;
}

void
yyerror (char* msg)
{
	   char *config;

	   config = (current_yacc_file) ? current_yacc_file : "";

        PRINT_ERROR ("Error parsing file %s:%d '%s', symbol '%s'\n", 
				 config, yylineno, msg, yytext);
}



/* Line 214 of yacc.c.  */


#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  120
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   222

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  78
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  80
/* YYNRULES -- Number of rules. */
#define YYNRULES  165
/* YYNRULES -- Number of states. */
#define YYNSTATES  254

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   329

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    75,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    76,     2,    77,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     4,     6,     8,    11,    13,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    93,    96,    97,
     100,   101,   104,   105,   108,   109,   112,   113,   116,   117,
     120,   122,   124,   126,   130,   132,   136,   138,   142,   144,
     148,   151,   154,   157,   160,   163,   164,   169,   170,   174,
     175,   178,   181,   184,   187,   190,   193,   196,   199,   202,
     205,   208,   209,   214,   218,   219,   222,   225,   228,   231,
     234,   237,   242,   245,   248,   251,   254,   257,   261,   265,
     266,   269,   272,   275,   278,   281,   284,   290,   293,   295,
     297,   300,   304,   307,   310,   313,   316,   319,   322,   325,
     328,   331,   334,   336,   339,   342,   345,   348,   351,   353,
     355,   357,   358,   365,   366,   373,   374,   381,   383,   386,
     392,   396,   398,   401,   405,   409,   410,   411,   414,   417,
     418,   425,   428,   429,   433,   434
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
      79,     0,    -1,    -1,    80,    -1,    82,    -1,    80,    82,
      -1,    84,    -1,    81,    84,    -1,    84,    -1,    83,    -1,
     141,    -1,    97,    -1,    98,    -1,   107,    -1,   108,    -1,
     109,    -1,   110,    -1,   111,    -1,   112,    -1,   120,    -1,
     133,    -1,   134,    -1,   135,    -1,   136,    -1,   128,    -1,
     129,    -1,   132,    -1,   154,    -1,   156,    -1,    99,    -1,
     100,    -1,   121,    -1,   122,    -1,   123,    -1,   124,    -1,
     126,    -1,   127,    -1,   145,    -1,   143,    -1,   101,    -1,
     102,    -1,   116,    -1,   113,    -1,   114,    -1,   115,    -1,
     152,    -1,    -1,    85,   147,    -1,    -1,    86,   125,    -1,
      -1,    87,   139,    -1,    -1,    88,   119,    -1,    -1,    89,
     131,    -1,    -1,    90,   148,    -1,    -1,    91,   145,    -1,
      68,    -1,    67,    -1,    92,    -1,    92,    75,    93,    -1,
      68,    -1,    68,    75,    94,    -1,   140,    -1,   140,    75,
      95,    -1,    72,    -1,    72,    75,    96,    -1,    65,    64,
      -1,    24,   140,    -1,    48,    64,    -1,    62,    68,    -1,
      12,    67,    -1,    -1,    13,    68,   103,   104,    -1,    -1,
      76,   105,    77,    -1,    -1,   105,   106,    -1,    68,    67,
      -1,    26,    68,    -1,    14,    67,    -1,    40,    67,    -1,
      10,    64,    -1,    11,    64,    -1,     8,    64,    -1,     7,
      67,    -1,     6,    67,    -1,    45,    67,    -1,    -1,    27,
      68,   117,   118,    -1,    76,    88,    77,    -1,    -1,    28,
      94,    -1,     4,    94,    -1,    23,    67,    -1,    49,    67,
      -1,    50,    67,    -1,    52,    64,    -1,    53,    76,    86,
      77,    -1,    54,    64,    -1,    55,    64,    -1,    56,    64,
      -1,    60,    64,    -1,    38,    67,    -1,     5,    64,   130,
      -1,    76,    89,    77,    -1,    -1,    19,    68,    -1,    36,
      64,    -1,    17,    68,    -1,    17,    64,    -1,    18,    68,
      -1,    18,    64,    -1,    16,    68,    76,    87,    77,    -1,
      16,    68,    -1,    69,    -1,    70,    -1,    22,   138,    -1,
      61,    66,    66,    -1,    22,    67,    -1,    25,    67,    -1,
      29,    68,    -1,    30,    68,    -1,    31,    68,    -1,    33,
      68,    -1,    32,    68,    -1,    39,    68,    -1,    47,    67,
      -1,    57,    67,    -1,    51,    -1,    58,    67,    -1,    20,
      74,    -1,    57,    66,    -1,    64,   138,    -1,    37,    94,
      -1,    68,    -1,    72,    -1,    73,    -1,    -1,    20,    95,
      76,   142,    81,    77,    -1,    -1,    63,    94,    76,   144,
      85,    77,    -1,    -1,    15,    67,    76,   146,    85,    77,
      -1,   137,    -1,    12,    67,    -1,    41,    94,    76,    90,
      77,    -1,    28,    46,    96,    -1,    59,    -1,    42,    66,
      -1,    43,    68,   149,    -1,    76,   150,    77,    -1,    -1,
      -1,   150,   151,    -1,    44,    67,    -1,    -1,    21,    68,
     153,    76,    91,    77,    -1,    35,    93,    -1,    -1,    76,
      87,    77,    -1,    -1,     9,    68,   157,   155,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   238,   238,   239,   242,   243,   246,   247,   250,   251,
     254,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   294,   295,   297,   298,
     300,   301,   303,   304,   306,   307,   309,   310,   312,   313,
     318,   319,   321,   330,   342,   351,   363,   372,   384,   393,
     402,   407,   412,   417,   435,   457,   456,   482,   483,   485,
     486,   489,   502,   520,   525,   530,   538,   543,   548,   565,
     582,   601,   600,   631,   632,   634,   655,   676,   695,   700,
     710,   715,   717,   722,   727,   732,   737,   742,   749,   750,
     752,   768,   773,   788,   793,   808,   813,   819,   825,   826,
     828,   833,   856,   861,   866,   869,   872,   875,   878,   881,
     884,   887,   890,   893,   896,   899,   903,   916,   945,   946,
     947,   953,   952,   990,   989,  1077,  1076,  1144,  1151,  1164,
    1188,  1207,  1217,  1226,  1246,  1247,  1250,  1251,  1254,  1260,
    1259,  1288,  1301,  1302,  1305,  1304
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "T_QUOTE", "T_DENY", "T_THREAD_NUM",
  "T_SSL_CERT_KEY_FILE", "T_SSL_CERT_FILE", "T_KEEPALIVE_MAX_REQUESTS",
  "T_ERROR_HANDLER", "T_TIMEOUT", "T_KEEPALIVE", "T_DOCUMENT_ROOT",
  "T_LOG", "T_MIME_FILE", "T_DIRECTORY", "T_HANDLER", "T_USER", "T_GROUP",
  "T_POLICY", "T_SERVER", "T_USERDIR", "T_URL", "T_PIDFILE", "T_LISTEN",
  "T_FILEDIR", "T_SERVER_TOKENS", "T_ENCODER", "T_ALLOW", "T_BGCOLOR",
  "T_TEXT", "T_LINK", "T_ALINK", "T_VLINK", "T_BACKGROUND",
  "T_DIRECTORYINDEX", "T_IPV6", "T_SHOW", "T_CHROOT", "T_HEADER_FILE",
  "T_ICONS", "T_AUTH", "T_NAME", "T_METHOD", "T_PASSWDFILE",
  "T_SSL_CA_LIST_FILE", "T_FROM", "T_SOCKET", "T_LOG_FLUSH_INTERVAL",
  "T_INCLUDE", "T_PANIC_ACTION", "T_JUST_ABOUT", "T_LISTEN_QUEUE_SIZE",
  "T_SENDFILE", "T_MINSIZE", "T_MAXSIZE", "T_MAX_FDS", "T_INTERPRETER",
  "T_SCRIPT_ALIAS", "T_ONLY_SECURE", "T_MAX_CONNECTION_REUSE", "T_REWRITE",
  "T_POLL_METHOD", "T_EXTENSION", "T_NUMBER", "T_PORT", "T_QSTRING",
  "T_FULLDIR", "T_ID", "T_HTTP_URL", "T_HTTPS_URL", "T_HOSTNAME", "T_IP",
  "T_DOMAIN_NAME", "T_ADDRESS_PORT", "','", "'{'", "'}'", "$accept",
  "conffile", "lines", "server_lines", "line", "common_line",
  "server_line", "directory_options", "sendfile_options",
  "handler_options", "encoder_options", "thread_options", "auth_options",
  "directories", "id_or_path", "id_path_list", "id_list", "domain_list",
  "ip_list", "port", "listen", "log_flush_interval", "poll_method",
  "document_root", "log", "@1", "log_optional", "tuple_list", "tuple",
  "server_tokens", "mime", "icons", "timeout", "keepalive",
  "keepalive_max_requests", "ssl_file", "ssl_key_file", "ssl_ca_list_file",
  "encoder", "@2", "maybe_encoder_options", "encoder_option", "pidfile",
  "include", "panic_action", "listen_queue_size", "sendfile",
  "sendfile_option", "maxfds", "maxconnectionreuse", "chroot",
  "thread_number", "maybe_thread_options", "thread_option", "ipv6",
  "user1", "user2", "group1", "group2", "handler", "http_generic",
  "handler_option", "host_name", "server", "@3", "extension", "@4",
  "directory", "@5", "directory_option", "auth_option",
  "maybe_auth_option_params", "auth_option_params", "auth_option_param",
  "userdir", "@6", "directoryindex", "maybe_handlererror_options",
  "errorhandler", "@7", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,    44,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    78,    79,    79,    80,    80,    81,    81,    82,    82,
      83,    83,    83,    83,    83,    83,    83,    83,    83,    83,
      83,    83,    83,    83,    83,    83,    83,    83,    83,    83,
      83,    83,    83,    83,    83,    83,    83,    84,    84,    84,
      84,    84,    84,    84,    84,    84,    85,    85,    86,    86,
      87,    87,    88,    88,    89,    89,    90,    90,    91,    91,
      92,    92,    93,    93,    94,    94,    95,    95,    96,    96,
      97,    98,    99,   100,   101,   103,   102,   104,   104,   105,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   117,   116,   118,   118,   119,   119,   120,   121,   122,
     123,   124,   125,   125,   126,   127,   128,   129,   130,   130,
     131,   132,   133,   134,   135,   136,   137,   137,   138,   138,
     139,   139,   139,   139,   139,   139,   139,   139,   139,   139,
     139,   139,   139,   139,   139,   139,   139,   139,   140,   140,
     140,   142,   141,   144,   143,   146,   145,   147,   147,   147,
     147,   147,   148,   148,   149,   149,   150,   150,   151,   153,
     152,   154,   155,   155,   157,   156
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     1,     1,     2,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     2,     0,     2,
       0,     2,     0,     2,     0,     2,     0,     2,     0,     2,
       1,     1,     1,     3,     1,     3,     1,     3,     1,     3,
       2,     2,     2,     2,     2,     0,     4,     0,     3,     0,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     0,     4,     3,     0,     2,     2,     2,     2,     2,
       2,     4,     2,     2,     2,     2,     2,     3,     3,     0,
       2,     2,     2,     2,     2,     2,     5,     2,     1,     1,
       2,     3,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     1,     2,     2,     2,     2,     2,     1,     1,
       1,     0,     6,     0,     6,     0,     6,     1,     2,     5,
       3,     1,     2,     3,     3,     0,     0,     2,     2,     0,
       6,     2,     0,     3,     0,     4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     3,     4,     9,     8,
      11,    12,    29,    30,    39,    40,    13,    14,    15,    16,
      17,    18,    42,    43,    44,    41,    19,    31,    32,    33,
      34,    35,    36,    24,    25,    26,    20,    21,    22,    23,
      10,    38,    37,    45,    27,    28,   109,    89,    88,    87,
     164,    85,    86,    74,    75,    83,     0,   113,   112,   115,
     114,   138,   139,   140,     0,    66,   159,    97,    71,    82,
      91,    61,    60,    62,   161,   111,   106,    84,    90,    72,
      98,    99,   100,    48,   104,   105,    73,    64,     0,    70,
       1,     5,    54,   107,   162,    77,   145,   141,     0,     0,
      94,     0,     0,     0,   143,     0,    50,   165,    79,    76,
      46,     0,    67,    58,    52,    92,    63,     0,     0,   101,
      49,    65,    46,     0,   108,    55,     0,     0,     0,     0,
       6,     0,     0,   102,   103,     0,   110,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   132,     0,
       0,     0,     0,   163,    51,     0,    78,    80,     0,     0,
       0,     0,   151,   146,   147,    47,   142,     7,   160,    59,
       0,     0,    93,    53,   144,   134,   122,   118,   119,   120,
     123,   124,   125,   126,   128,   127,   137,   129,   130,   135,
     131,   133,     0,   136,    81,   148,   117,     0,     0,    96,
      95,   121,    50,    68,   150,    56,     0,     0,     0,   116,
      69,     0,     0,   149,    57,   152,   155,   156,   153,     0,
       0,   154,   157,   158
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    35,    36,   159,    37,    38,    39,   158,   132,   156,
     162,   135,   238,   161,   103,   104,   118,    94,   234,    40,
      41,    42,    43,    44,    45,   125,   139,   157,   187,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,   130,
     145,   203,    56,    57,    58,    59,    60,   150,    61,    62,
      63,    64,   123,   155,    65,    66,    67,    68,    69,   194,
     209,   184,    95,    70,   141,    71,   152,    72,   140,   195,
     244,   248,   249,   252,    73,   129,    74,   137,    75,   124
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -131
static const short int yypact[] =
{
      76,   -50,   -46,   -39,   -21,   -19,     1,    12,     0,   -17,
       2,    25,   -31,   -16,   -26,   -15,    28,   -26,    11,    30,
      -8,    37,    39,    40,    41,    45,    43,    46,    51,    42,
      53,    55,    52,    54,    59,   127,    76,  -131,  -131,  -131,
    -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,
    -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,
    -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,
    -131,  -131,  -131,  -131,  -131,  -131,    57,  -131,  -131,  -131,
    -131,  -131,  -131,  -131,  -131,  -131,    58,  -131,  -131,  -131,
    -131,  -131,  -131,  -131,    66,    56,  -131,  -131,  -131,  -131,
    -131,  -131,  -131,    68,  -131,  -131,  -131,  -131,  -131,  -131,
    -131,  -131,  -131,  -131,  -131,  -131,  -131,    74,    75,  -131,
    -131,  -131,  -131,  -131,    77,    79,  -131,  -131,   -26,    80,
      81,    -8,   -20,    54,  -131,   -14,  -131,  -131,  -131,  -131,
    -131,     5,  -131,  -131,  -131,  -131,  -131,    86,    95,  -131,
    -131,  -131,  -131,    62,  -131,  -131,   115,   -41,    -3,    -5,
    -131,   -11,    -4,  -131,  -131,     3,  -131,    87,     8,    97,
     106,   110,   112,   113,   114,    54,   116,    98,  -131,   -12,
     119,   117,    35,  -131,  -131,   120,  -131,  -131,   121,   122,
     145,    54,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,
      54,    54,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,
    -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,
    -131,  -131,   128,  -131,  -131,  -131,   124,   125,   129,  -131,
    -131,  -131,  -131,   118,  -131,  -131,   138,   125,   -13,  -131,
    -131,   132,   133,  -131,  -131,  -131,   130,  -131,  -131,   -38,
     136,  -131,  -131,  -131
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -131,  -131,  -131,  -131,   168,  -131,  -118,    60,  -131,   -25,
    -131,  -131,  -131,  -131,  -131,    78,  -130,    82,   -29,  -131,
    -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,
    -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,
    -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,
    -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,
      29,  -131,   196,  -131,  -131,  -131,  -131,    61,  -131,  -131,
    -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131,  -131
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
     200,     2,     3,   151,    11,   153,   250,     8,     9,   188,
      11,     2,     3,   189,    76,   188,    15,     8,     9,   189,
      11,    77,    19,   160,   201,   190,    15,   185,    78,   241,
     242,   190,    19,    87,   147,   148,   186,    88,   191,   251,
      24,   197,    91,    79,   191,   216,    92,    93,    89,    80,
      24,    84,    90,    96,   219,   220,   192,   149,    33,   101,
     102,   228,   192,   154,   243,    81,   198,    83,    33,    85,
     229,   230,   196,   202,   193,   206,    82,   207,   208,    99,
     204,     1,     2,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    86,    12,    13,    97,    14,    15,   100,    16,
      17,   105,    18,    19,   207,   208,   106,   107,   108,   109,
     110,    20,    21,   111,    22,   112,    23,   114,   113,   115,
     116,    24,   117,   119,    25,    26,    27,   120,    28,    29,
     166,   128,    30,   122,   126,   167,    31,   168,    32,    33,
     169,    34,   127,   131,   170,   171,   172,   173,   174,   133,
     163,   134,   175,   136,   176,   138,   143,   144,   167,   164,
     168,   205,   177,   169,   210,   218,   178,   170,   171,   172,
     173,   174,   179,   180,   211,   175,   181,   176,   212,   182,
     213,   214,   215,   222,   217,   177,   221,   224,   225,   178,
     226,   227,   183,   237,   231,   179,   180,   233,   245,   181,
     232,   246,   182,   253,   121,   235,   247,   236,   240,   146,
     142,   223,   165,    98,     0,   239,     0,     0,     0,     0,
       0,     0,   199
};

static const short int yycheck[] =
{
       4,     6,     7,   133,    15,    19,    44,    12,    13,    12,
      15,     6,     7,    16,    64,    12,    21,    12,    13,    16,
      15,    67,    27,   141,    28,    28,    21,    68,    67,    42,
      43,    28,    27,    64,    54,    55,    77,    68,    41,    77,
      45,   159,    68,    64,    41,   175,    72,    73,    64,    68,
      45,    68,    68,    68,    66,    67,    59,    77,    63,    67,
      68,   191,    59,    77,    77,    64,    77,    67,    63,    67,
     200,   201,    77,    77,    77,    67,    64,    69,    70,    68,
      77,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    67,    17,    18,    67,    20,    21,    68,    23,
      24,    64,    26,    27,    69,    70,    67,    67,    67,    64,
      67,    35,    36,    67,    38,    64,    40,    64,    76,    64,
      68,    45,    68,    64,    48,    49,    50,     0,    52,    53,
      68,    75,    56,    76,    76,    20,    60,    22,    62,    63,
      25,    65,    76,    75,    29,    30,    31,    32,    33,    75,
      64,    76,    37,    76,    39,    76,    76,    76,    20,    64,
      22,    74,    47,    25,    67,    67,    51,    29,    30,    31,
      32,    33,    57,    58,    68,    37,    61,    39,    68,    64,
      68,    68,    68,    66,    68,    47,    67,    67,    67,    51,
      68,    46,    77,    75,    66,    57,    58,    72,    66,    61,
      76,    68,    64,    67,    36,    76,    76,   232,   237,   131,
     128,   182,   152,    17,    -1,    77,    -1,    -1,    -1,    -1,
      -1,    -1,   161
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    17,    18,    20,    21,    23,    24,    26,    27,
      35,    36,    38,    40,    45,    48,    49,    50,    52,    53,
      56,    60,    62,    63,    65,    79,    80,    82,    83,    84,
      97,    98,    99,   100,   101,   102,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   120,   121,   122,   123,
     124,   126,   127,   128,   129,   132,   133,   134,   135,   136,
     141,   143,   145,   152,   154,   156,    64,    67,    67,    64,
      68,    64,    64,    67,    68,    67,    67,    64,    68,    64,
      68,    68,    72,    73,    95,   140,    68,    67,   140,    68,
      68,    67,    68,    92,    93,    64,    67,    67,    67,    64,
      67,    67,    64,    76,    64,    64,    68,    68,    94,    64,
       0,    82,    76,   130,   157,   103,    76,    76,    75,   153,
     117,    75,    86,    75,    76,    89,    76,   155,    76,   104,
     146,   142,    95,    76,    76,   118,    93,    54,    55,    77,
     125,    94,   144,    19,    77,   131,    87,   105,    85,    81,
      84,    91,    88,    64,    64,    85,    68,    20,    22,    25,
      29,    30,    31,    32,    33,    37,    39,    47,    51,    57,
      58,    61,    64,    77,   139,    68,    77,   106,    12,    16,
      28,    41,    59,    77,   137,   147,    77,    84,    77,   145,
       4,    28,    77,   119,    77,    74,    67,    69,    70,   138,
      67,    68,    68,    68,    68,    68,    94,    68,    67,    66,
      67,    67,    66,   138,    67,    67,    68,    46,    94,    94,
      94,    66,    76,    72,    96,    76,    87,    75,    90,    77,
      96,    42,    43,    77,   148,    66,    68,    76,   149,   150,
      44,    77,   151,    67
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 60:

    { yyval.string = yyvsp[0].string; }
    break;

  case 61:

    { yyval.string = yyvsp[0].string; }
    break;

  case 62:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;
	   
	   yyval.list = n;
}
    break;

  case 63:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 64:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;
	   
	   yyval.list = n;
}
    break;

  case 65:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 66:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;
	   
	   yyval.list = n;
}
    break;

  case 67:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 68:

    {
	   linked_list_t *n = (linked_list_t *) malloc (sizeof(linked_list_t));
	   n->next   = NULL;
	   n->string = yyvsp[0].string;

	   yyval.list = n;
}
    break;

  case 69:

    {
	   linked_list_t *n = (linked_list_t *) malloc (sizeof(linked_list_t));
	   n->next   = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 70:

    {
	   SRV(server)->port = yyvsp[0].number;
}
    break;

  case 71:

    {
	   SRV(server)->listen_to = yyvsp[0].string;
}
    break;

  case 72:

    {
	   SRV(server)->log_flush_elapse = yyvsp[0].number;
}
    break;

  case 73:

    {
	   if (strcmp(yyvsp[0].string, "epoll") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_epoll;
	   } else if (strcmp(yyvsp[0].string, "port") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_port;
	   } else if (strcmp(yyvsp[0].string, "kqueue") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_kqueue;
	   } else if (strcmp(yyvsp[0].string, "poll") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_poll;
	   } else if (strcmp(yyvsp[0].string, "select") == 0) {
			 SRV(server)->fdpoll_method = cherokee_poll_select;
	   } else {
			 PRINT_ERROR ("ERROR: Unknown polling method '%s'\n", yyvsp[0].string);
			 return 1;
	   }
}
    break;

  case 74:

    {
	   char                      *root;
	   int                        root_len;
	   cherokee_virtual_server_t *vserver;

	   vserver = auto_virtual_server;

	   root     = yyvsp[0].string;
	   root_len = strlen(yyvsp[0].string);

	   /* Check for the endding slash
	    */
	   root = make_finish_with_slash (root, &root_len);

	   /* Add the virtual root path to the virtual server struct
	    */
	   cherokee_buffer_add (vserver->root, root, root_len);
}
    break;

  case 75:

    {
	   ret_t ret;

	   /* Maybe load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load logger module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   cherokee_module_loader_get (SRV(server)->loader, yyvsp[0].string, &current_module_info);
}
    break;

  case 76:

    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   /* Instance the logger object
	    */
	   cherokee_logger_table_new_logger (SRV(server)->loggers, yyvsp[-2].string, current_module_info,
								  vserver->logger_props, &vserver->logger);
	   current_module_info = NULL;
}
    break;

  case 81:

    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   if (vserver->logger_props == NULL) {
			 cherokee_table_new (&vserver->logger_props);
	   }

	   cherokee_table_add (vserver->logger_props, yyvsp[-1].string, yyvsp[0].string);
}
    break;

  case 82:

    {
	   if (!strncasecmp("Product", yyvsp[0].string, 7)) {
			 SRV(server)->server_token = cherokee_version_product;
	   } else if (!strncasecmp("Minor", yyvsp[0].string, 5)) {
			 SRV(server)->server_token = cherokee_version_minor;
	   } else if (!strncasecmp("Minimal", yyvsp[0].string, 7)) {
			 SRV(server)->server_token = cherokee_version_minimal;
	   } else if (!strncasecmp("OS", yyvsp[0].string, 2)) {
			 SRV(server)->server_token = cherokee_version_os;
	   } else if (!strncasecmp("Full", yyvsp[0].string, 4)) {
			 SRV(server)->server_token = cherokee_version_full;
	   } else {
			 PRINT_ERROR ("ERROR: Unknown server token '%s'\n", yyvsp[0].string);
			 return 1;
	   }
}
    break;

  case 83:

    {
	   SRV(server)->mime_file = yyvsp[0].string;
}
    break;

  case 84:

    {
	   SRV(server)->icons_file = yyvsp[0].string;
}
    break;

  case 85:

    {
	   SRV(server)->timeout = yyvsp[0].number;

	   cherokee_buffer_clean  (SRV(server)->timeout_header);
	   cherokee_buffer_add_va (SRV(server)->timeout_header, "Keep-Alive: timeout=%d"CRLF, yyvsp[0].number);
}
    break;

  case 86:

    {
	   SRV(server)->keepalive = (yyvsp[0].number == 0) ? false : true;
}
    break;

  case 87:

    {
	   SRV(server)->keepalive_max = yyvsp[0].number;
}
    break;

  case 88:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_cert != NULL) {
			 PRINT_ERROR ("ERROR: \"SSLCertificateFile\" overlaps: '%s' <- '%s'\n", vsrv->server_cert, yyvsp[0].string);
			 free (vsrv->server_cert);
	   }

	   vsrv->server_cert = yyvsp[0].string;

#else
	   PRINT_ERROR_S ("WARNING: Ignoring SSL configuration entry: \"SSLCertificateFile\"\n");
#endif
}
    break;

  case 89:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_key != NULL) {
			 PRINT_ERROR ("ERROR: \"SSLCertificateKeyFile\" overlaps: '%s' <- '%s'\n", vsrv->server_key, yyvsp[0].string);
			 free (vsrv->server_key);
	   }

	   vsrv->server_key = yyvsp[0].string;

#else
	   PRINT_ERROR_S ("WARNING: Ignoring SSL configuration entry: \"SSLCertificateKeyFile\"\n");
#endif
}
    break;

  case 90:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->ca_cert != NULL) {
			 PRINT_ERROR ("ERROR: \"SSLCAListFile\" overlaps: '%s' <- '%s'\n", vsrv->ca_cert, yyvsp[0].string);
			 free (vsrv->ca_cert);
	   }

	   vsrv->ca_cert = yyvsp[0].string;

#else
	   PRINT_ERROR_S ("WARNING: Ignoring SSL configuration entry: \"SSLCAListFile\"\n");
#endif
}
    break;

  case 91:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;
	   cherokee_encoder_table_entry_t *enc;

	   /* Load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load encoder module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[0].string, &info);

	   /* Set the info in the new entry
	    */
	   cherokee_encoder_table_entry_new (&enc);
	   cherokee_encoder_table_entry_get_info (enc, info);

	   /* Set in the encoders table
	    */
	   cherokee_encoder_table_set (SRV(server)->encoders, yyvsp[0].string, enc);
	   current_encoder_entry = enc;
}
    break;

  case 92:

    {
	   current_encoder_entry = NULL;
}
    break;

  case 95:

    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = yyvsp[0].list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_allow (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 96:

    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = yyvsp[0].list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_deny (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 97:

    {
	   FILE *file;
	   CHEROKEE_TEMP(buffer, 10);

	   file = fopen (yyvsp[0].string, "w");
	   if (file == NULL) {
			 PRINT_ERROR ("ERROR: Can't write PID file '%s': %s\n", yyvsp[0].string, strerror(errno));
			 return 0;
	   }

	   snprintf (buffer, buffer_size, "%d\n", getpid());
	   fwrite (buffer, 1, strlen(buffer), file);
	   fclose (file);

	   free (yyvsp[0].string);
}
    break;

  case 98:

    {
	   cherokee_list_add_tail (&SRV(server)->include_list, yyvsp[0].string);
}
    break;

  case 99:

    {
	   if (SRV(server)->panic_action != NULL) {
			 PRINT_ERROR ("WARNING: Overwriting panic action '%s' by '%s'\n", SRV(server)->panic_action, yyvsp[0].string);
			 free (SRV(server)->panic_action);
	   }

	   SRV(server)->panic_action = yyvsp[0].string;
}
    break;

  case 100:

    {
	   SRV(server)->listen_queue = yyvsp[0].number;
}
    break;

  case 102:

    {
	   SRV(server)->sendfile.min = yyvsp[0].number;
}
    break;

  case 103:

    {
	   SRV(server)->sendfile.max = yyvsp[0].number;
}
    break;

  case 104:

    {
	   SRV(server)->max_fds = yyvsp[0].number;
}
    break;

  case 105:

    {
	   SRV(server)->max_conn_reuse = yyvsp[0].number;
}
    break;

  case 106:

    {
	   SRV(server)->chroot = yyvsp[0].string;
}
    break;

  case 107:

    {
#ifdef HAVE_PTHREAD
	   SRV(server)->thread_num = yyvsp[-1].number;
#endif
}
    break;

  case 110:

    {
#ifdef HAVE_PTHREAD
	   if (strcasecmp(yyvsp[0].string, "fifo") == 0) {
			 SRV(server)->thread_policy = SCHED_FIFO;
	   } else if (strcasecmp(yyvsp[0].string, "rr") == 0) {
			 SRV(server)->thread_policy = SCHED_RR;
	   } else if (strcasecmp(yyvsp[0].string, "other") == 0) {
			 SRV(server)->thread_policy = SCHED_OTHER;
	   } else {
			 PRINT_ERROR ("ERROR: unknown scheduling policy '%s'\n", yyvsp[0].string);
	   }
#endif
}
    break;

  case 111:

    {
	   SRV(server)->ipv6 = yyvsp[0].number;
}
    break;

  case 112:

    {
	   struct passwd *pwd;
	   
	   pwd = (struct passwd *) getpwnam (yyvsp[0].string);
	   if (pwd == NULL) {
			 PRINT_ERROR ("ERROR: User '%s' not found in the system", yyvsp[0].string);
			 return 1;
	   }

	   SRV(server)->user = pwd->pw_uid;

	   free (yyvsp[0].string);
}
    break;

  case 113:

    {
	   SRV(server)->user = yyvsp[0].number;
}
    break;

  case 114:

    {
	   struct group *grp;

	   grp = (struct group *) getgrnam (yyvsp[0].string);
	   if (grp == NULL) {
			 PRINT_ERROR ("ERROR: Group '%s' not found in the system", yyvsp[0].string);
			 return 1;
	   }

	   SRV(server)->group = grp->gr_gid;

	   free (yyvsp[0].string);
}
    break;

  case 115:

    {
	   SRV(server)->group = yyvsp[0].number;
}
    break;

  case 116:

    {
	   yyval.name_ptr.name = yyvsp[-3].string;
	   yyval.name_ptr.ptr = current_dirs_table_entry;
}
    break;

  case 117:

    {
	   yyval.name_ptr.name = yyvsp[0].string;
	   yyval.name_ptr.ptr = current_dirs_table_entry;
}
    break;

  case 118:

    { yyval.string = yyvsp[0].string; }
    break;

  case 119:

    { yyval.string = yyvsp[0].string; }
    break;

  case 120:

    {
	   cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "url", yyvsp[0].string);
}
    break;

  case 121:

    {
	int *count;
	char name[32];

	if (current_dirs_table_entry->properties != NULL)
		count = (int *)cherokee_table_get_val (current_dirs_table_entry->properties, "regex_count");

	if (count == 0) {
		count = (int*)malloc(sizeof(int));
		*count = 1;
		cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "regex_count", (void *)count);
	} else {
		++*count;
	}

	snprintf(name, sizeof(name), "regex_%d_expr", *count - 1);
	cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, name, yyvsp[-1].string);

	snprintf(name, sizeof(name), "regex_%d_subs", *count - 1);
	cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, name, yyvsp[0].string);
}
    break;

  case 122:

    {
	   cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "url", yyvsp[0].string);
}
    break;

  case 123:

    {
	   cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "filedir", yyvsp[0].string);
}
    break;

  case 124:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "bgcolor", yyvsp[0].string); }
    break;

  case 125:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "text", yyvsp[0].string); }
    break;

  case 126:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "link", yyvsp[0].string); }
    break;

  case 127:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "vlink", yyvsp[0].string); }
    break;

  case 128:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "alink", yyvsp[0].string); }
    break;

  case 129:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "headerfile", yyvsp[0].string); }
    break;

  case 130:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "socket", yyvsp[0].string); }
    break;

  case 131:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "interpreter", yyvsp[0].string); }
    break;

  case 132:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "about", NULL); }
    break;

  case 133:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "scriptalias", yyvsp[0].string); }
    break;

  case 134:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "server", yyvsp[0].string); }
    break;

  case 135:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "interpreter", yyvsp[0].string); }
    break;

  case 136:

    {
	   char code[4];

	   if ((yyvsp[-1].number < 100) || (yyvsp[-1].number >= http_type_500_max)) {
			 PRINT_ERROR("ERROR: Incorrect HTTP code number %d\n", yyvsp[-1].number);
			 return 1;
	   }

	   snprintf (code, 4, "%d", yyvsp[-1].number);
	   cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, code, yyvsp[0].string);
}
    break;

  case 137:

    {
	   linked_list_t *i;

	   i = yyvsp[0].list;
	   while (i != NULL) {
			 if ((!strncasecmp (i->string, "date",  4)) ||
				(!strncasecmp (i->string, "size",  4)) ||
				(!strncasecmp (i->string, "group", 5)) ||
				(!strncasecmp (i->string, "owner", 5)))
			 {
				    char *lower;

				    lower = new_string_to_lowercase (i->string);
				    free (i->string);
				    i->string = lower;

				    cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, i->string, i->string);				    
			 } else {
				    PRINT_ERROR ("ERROR: Unknown parameter '%s' for \"Show\"", i->string);
			 }
				
			 i = i->next;
	   }

	   free_linked_list (yyvsp[0].list, free);
}
    break;

  case 140:

    {
	   yyval.string = yyvsp[0].string;
}
    break;

  case 141:

    {
	   linked_list_t *i = yyvsp[-1].list;
	   CHEROKEE_NEW(vsrv, virtual_server);

	   current_virtual_server = vsrv;
	   current_dirs_table     = &vsrv->dirs;

	   /* Add the virtual server to the list
	    */
	   list_add ((list_t *)vsrv, &SRV(server)->vservers);

	   /* Add default virtual server name
	    */
	   if (i->string != NULL) {
			 cherokee_buffer_t *name = current_virtual_server->name;

			 if (cherokee_buffer_is_empty (name)) {
				    cherokee_buffer_add_va (name, "%s", i->string);
			 }
	   }

	   /* Add all the alias to the table
	    */
	   while (i != NULL) {
			 cherokee_table_add (SRV(server)->vservers_ref, i->string, vsrv);
			 i = i->next;
	   }
	   free_linked_list (yyvsp[-1].list, NULL);

}
    break;

  case 142:

    {

	   current_virtual_server = NULL;
	   current_dirs_table  = NULL;
}
    break;

  case 143:

    {
	   /* Fill the tmp struct
	    */
	   extension_content_tmp.exts_list      = yyvsp[-1].list;
	   extension_content_tmp.vserver        = auto_virtual_server;
	   extension_content_tmp.entry          = dirs_table_entry_new (); /* new! */
	   extension_content_tmp.handler_name   = NULL;
	   extension_content_tmp.document_root  = NULL;

	   /* Extensions table is created under demand
	    */
	   if (extension_content_tmp.vserver->exts == NULL) {
			 ret_t ret;

			 ret = cherokee_exts_table_new (&extension_content_tmp.vserver->exts);
			 if (unlikely (ret != ret_ok)) {
				    PRINT_ERROR_S ("ERROR: Couldn't instance a new exts table object\n");
				    return 1;
			 }
	   }
	   extension_content_tmp.exts = extension_content_tmp.vserver->exts;
}
    break;

  case 144:

    {
	   ret_t                   ret;
	   linked_list_t          *i;
	   cherokee_module_info_t *info;

	   /* Does this directory have a handler
	    */
	   if (extension_content_tmp.handler_name != NULL) {
			 int re;
			 re = load_module (SRV(server)->loader, extension_content_tmp.handler_name, &info);
			 if (re != 0) return 1;
	   
			 cherokee_dirs_table_entry_set_handler (extension_content_tmp.entry, info);	   
	   }

	   /* Add "web_dir -> entry" in the dirs table
	    */
	   i = extension_content_tmp.exts_list;
	   while (i != NULL) {
			 ret = cherokee_exts_table_has (extension_content_tmp.exts, i->string);
			 if (ret != ret_not_found) {
				    PRINT_ERROR ("ERROR: Extension '%s' was already set\n", i->string);
				    return 1;
			 }

			 ret = cherokee_exts_table_add (extension_content_tmp.exts,
									  i->string,
									  extension_content_tmp.entry);
			 if (ret != ret_ok) {
				    switch (ret) {
				    case ret_file_not_found:
						  PRINT_ERROR ("ERROR: Can't load handler '%s': File not found\n",
									extension_content_tmp.handler_name);
						  break;
				    default:
						  PRINT_ERROR ("ERROR: Can't load handler '%s': Unknown error\n",
									extension_content_tmp.handler_name);
				    }
			 }

			 i = i->next;
	   }

	   /* Clean
	    */
	   if (extension_content_tmp.document_root != NULL) {
			 free (extension_content_tmp.document_root);
			 extension_content_tmp.document_root = NULL;
	   }

	   extension_content_tmp.vserver       = NULL;
	   extension_content_tmp.exts          = NULL;
	   extension_content_tmp.entry         = NULL;
	   extension_content_tmp.handler_name  = NULL;
	   extension_content_tmp.document_root  = NULL;

	   free_linked_list (extension_content_tmp.exts_list, free);
	   extension_content_tmp.exts_list = NULL;

	   current_dirs_table_entry = NULL;
}
    break;

  case 145:

    {
	   /* Fill the tmp struct
	    */
	   directory_content_tmp.directory_name = yyvsp[-1].string;
	   directory_content_tmp.vserver        = auto_virtual_server;
	   directory_content_tmp.dirs           = auto_dirs_table;
	   directory_content_tmp.entry          = dirs_table_entry_new (); /* new! */
	   directory_content_tmp.handler_name   = NULL;
	   directory_content_tmp.document_root  = NULL;
}
    break;

  case 146:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;

	   /* Set the document_root in the entry
	    */
	   if (directory_content_tmp.document_root != NULL) {
			 cherokee_buffer_clean (directory_content_tmp.entry->document_root);
			 cherokee_buffer_add_va (directory_content_tmp.entry->document_root, "%s",
								directory_content_tmp.document_root);
	   }

	   /* Does this directory have a handler
	    */
	   if (directory_content_tmp.handler_name != NULL) {
			 int re;
			 re = load_module (SRV(server)->loader, directory_content_tmp.handler_name, &info);
			 if (re != 0) return 1;
	   
			 cherokee_dirs_table_entry_set_handler (directory_content_tmp.entry, info);	   
	   }
	   
	   /* Add "web_dir -> entry" in the dirs table
	    */
	   ret = cherokee_dirs_table_add (directory_content_tmp.dirs,
							    directory_content_tmp.directory_name,
							    directory_content_tmp.entry);
	   if (ret != ret_ok) {
			 switch (ret) {
			 case ret_file_not_found:
				    PRINT_ERROR ("ERROR: Can't load handler '%s': File not found\n",
							  directory_content_tmp.handler_name);
				    break;
			 default:
				    PRINT_ERROR ("ERROR: Can't load handler '%s': Unknown error\n",
							  directory_content_tmp.handler_name);
			 }
	   }

	   cherokee_dirs_table_relink (directory_content_tmp.dirs);

	   /* Clean
	    */
	   if (directory_content_tmp.document_root != NULL) {
			 free (directory_content_tmp.document_root);
			 directory_content_tmp.document_root = NULL;
	   }
	   directory_content_tmp.vserver       = NULL;
	   directory_content_tmp.dirs          = NULL;
	   directory_content_tmp.entry         = NULL;
	   directory_content_tmp.handler_name  = NULL;

	   current_dirs_table_entry = NULL;
}
    break;

  case 147:

    {	   
	   directory_content_tmp.handler_name = yyvsp[0].name_ptr.name;
	   extension_content_tmp.handler_name = yyvsp[0].name_ptr.name;
}
    break;

  case 148:

    {
	   if (directory_content_tmp.document_root != NULL) {
			 PRINT_ERROR ("WARNING: Overwriting DocumentRoot '%s' by '%s'\n",
					    directory_content_tmp.document_root, yyvsp[0].string);

			 free (directory_content_tmp.document_root);
	   }

	   directory_content_tmp.document_root = make_slash_end (yyvsp[0].string);
}
    break;

  case 149:

    {
	   linked_list_t                  *i     = yyvsp[-3].list;
	   cherokee_dirs_table_entry_t *entry = directory_content_tmp.entry;

	   while (i != NULL) {
			 if (strncasecmp(i->string, "basic", 5) == 0) {
				    entry->authentication |= http_auth_basic;
			 } 
			 else if (strncasecmp(i->string, "digest", 6) == 0) {
				    entry->authentication |= http_auth_digest;			 
			 }
			 else {
				    PRINT_ERROR ("ERROR: Unknown authentication type '%s'\n", i->string);
				    return 1;
			 }

			 i = i->next;
	   }

	   free_linked_list (yyvsp[-3].list, free);
}
    break;

  case 150:

    {
	   ret_t ret;
	   linked_list_t *i, *prev;
	   CHEROKEE_NEW(n, access);

	   i = yyvsp[0].list;
	   while (i != NULL) {
			 ret = cherokee_access_add (n, i->string);
			 if (ret != ret_ok) return 1;

			 free (i->string);
			 prev = i;
			 i = i->next;
			 free (prev);
	   }
	   directory_content_tmp.entry->access = n;
}
    break;

  case 151:

    {
#ifndef HAVE_TLS
	   PRINT_ERROR_S ("ERROR: Cherokee is compiled without TLS support, so\n"
				   "       it isn't possible to use OnlySecure\n");
#endif

	   directory_content_tmp.entry->only_secure = true;
}
    break;

  case 152:

    {
	   cherokee_buffer_t *realm;
	   realm = directory_content_tmp.entry->auth_realm;

	   cherokee_buffer_add (realm, yyvsp[0].string, strlen(yyvsp[0].string));
	   free (yyvsp[0].string);
}
    break;

  case 153:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;

	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[-1].string);
	   if (ret != ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load validator module '%s'\n", yyvsp[-1].string);
			 return 1;
	   }

	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[-1].string, &info);

	   if (info->type != cherokee_validator) {
			 PRINT_ERROR ("ERROR: %s is not a validator module!!\n", yyvsp[-1].string);
	   }

	   directory_content_tmp.entry->validator_new_func = info->new_func;
}
    break;

  case 158:

    { cherokee_dirs_table_entry_set_prop (current_dirs_table_entry, "file", yyvsp[0].string); }
    break;

  case 159:

    {
	   int   len;
	   char *tmp;
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   /* Set the users public directory
	    */
	   if (!cherokee_buffer_is_empty (vsrv->userdir)) {
			 PRINT_ERROR ("WARNING: Overwriting userdir '%s'\n", vsrv->userdir->buf);
			 cherokee_buffer_clean (vsrv->userdir);
	   }

	   len = strlen(yyvsp[0].string);
	   tmp = make_finish_with_slash (yyvsp[0].string, &len);
	   cherokee_buffer_add (vsrv->userdir, tmp, len);

	   /* Set the plugin table reference
	    */
	   current_dirs_table = vsrv->userdir_dirs;

}
    break;

  case 160:

    {

	   /* Remove the references
	    */
	   current_dirs_table = NULL;
}
    break;

  case 161:

    {
	   linked_list_t *i = yyvsp[0].list;

	   while (i != NULL) {
			 cherokee_list_add_tail (&SRV(server)->index_list, i->string);
			 i = i->next;
	   }

	   free_linked_list (yyvsp[0].list, NULL);
}
    break;

  case 164:

    {
	   ret_t                      ret;
	   cherokee_module_info_t    *info;
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   /* Load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Loading module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   ret = cherokee_module_loader_get (SRV(server)->loader, yyvsp[0].string, &info);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Loading module '%s'\n", yyvsp[0].string);
			 return 1;
	   }
	   
	   /* Remove the old (by default) error handler and cretate a new one
	    */
	   vsrv->error_handler = dirs_table_entry_new();

	   /* Setup the loaded module
	    */
	   cherokee_dirs_table_entry_set_handler (vsrv->error_handler, info);
}
    break;


    }

/* Line 1010 of yacc.c.  */


  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
		 yydestruct (yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
	  yydestruct (yytoken, &yylval);
	  yychar = YYEMPTY;

	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}






