/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#if !defined (CHEROKEE_INSIDE_CHEROKEE_H) && !defined (CHEROKEE_COMPILATION)
# error "Only <cherokee/cherokee.h> can be included directly, this file may disappear or change contents."
#endif

#ifndef CHEROKEE_ADMIN_CLIENT_H
#define CHEROKEE_ADMIN_CLIENT_H

#include <cherokee/common.h>
#include <cherokee/fdpoll.h>
#include <cherokee/buffer.h>
#include <cherokee/config_value.h>


CHEROKEE_BEGIN_DECLS

typedef struct cherokee_admin_client cherokee_admin_client_t;
#define ADMIN_CLIENT(x) ((cherokee_admin_client_t *)(x))


ret_t cherokee_admin_client_new      (cherokee_admin_client_t **admin);
ret_t cherokee_admin_client_free     (cherokee_admin_client_t  *admin);

ret_t cherokee_admin_client_set_fdpoll (cherokee_admin_client_t *admin, cherokee_fdpoll_t *poll);
ret_t cherokee_admin_client_set_url    (cherokee_admin_client_t *admin, cherokee_buffer_t *url);

ret_t cherokee_admin_client_prepare    (cherokee_admin_client_t *admin);
ret_t cherokee_admin_client_step       (cherokee_admin_client_t *admin);

ret_t cherokee_admin_client_add_raw    (cherokee_admin_client_t *admin, cherokee_buffer_t *thing);
ret_t cherokee_admin_client_get_reply  (cherokee_admin_client_t *admin, cherokee_config_value_t **conf);

CHEROKEE_END_DECLS

#endif /* CHEROKEE_ADMIN_CLIENT_H */
