%{
/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "config_protocol_grammar.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
%}

%option yylineno
%option nounput

str             \"[^\"]+\"
nl              [\n\r]
integer         [-+]?[0-9]+

%%


"number"      { return T_NUMBER; }
"string"      { return T_STRING; }
"list"        { return T_LIST; }
"keyval"      { return T_KEYVAL; }

{nl}          { return T_NEWLINE; }
{integer}     { yy_config_protocol_lval.number = atoll(yytext); return T_NUM; }
{str}         { yy_config_protocol_lval.string = strdup(yytext); return T_STR; }


<<EOF>>       { yyterminate(); }
.		    { return yy_config_protocol_text[0]; }

%%

int 
yy_config_protocol_wrap()
{
       return 1;
}

