/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#if !defined (CHEROKEE_INSIDE_CHEROKEE_H) && !defined (CHEROKEE_COMPILATION)
# error "Only <cherokee/cherokee.h> can be included directly, this file may disappear or change contents."
#endif

#ifndef CHEROKEE_ADMIN_H
#define CHEROKEE_ADMIN_H

#include <cherokee/common.h>
#include <cherokee/fdpoll.h>
#include <cherokee/admin_request.h>


CHEROKEE_BEGIN_DECLS

typedef struct cherokee_admin cherokee_admin_t;
#define ADMIN(x) ((cherokee_admin_t *)(x))


ret_t cherokee_admin_new  (cherokee_admin_t **admin);
ret_t cherokee_admin_free (cherokee_admin_t  *admin);

/**
 
  XML       = List of Operation
  Operation = { Get, Set, Reply } + Property
  Property  = { String, }

  Client: CGI, GNOME   1.- <-  out: XML
  ------               4.-  ->  in: response XML   

  1.- AdminRequest.Serialize()
  4.- AdminReply.Deserialize(String)


  AdminRequest.Set x N       // configure
  AdminRequest.toXML         // Write XML request
  AdminRequest.Run()         // downloader: send request, POST /admin/ (request)
                             //             get reply
  AdminReply.Parse()         // Parse XML reply
  
                                             
                                             
  Handler              2.-  ->  in: XML           
  -------              3.- <-  out: response XML                

  2.- AdminRequest.Deserialize(String)
  3.- AdminReply.Serialize()

  AdminRequest.Deserialize (post) // Parse XML request
  Do Whatever
  AdminReply.Set x N
  AdminReply.toXML

--------------------------------------------------------------------------

Request,
  SetProperty
  Render
  Parse

Reply,
  SetProperty
  Render
  Parse

--------------------------------------------------------------------------

Message,
  SetProperty
  toXML
  parseXML

--------------------------------------------------------------------------

 CGI -> config -> HTTP: <<string>> -> config -> handler -> server


item.kind   = get, set, reply
item.type   = number, string, keyvalue, list
item.value  = xxx

request = list of items







**/


/* Server
 */
// ret_t cherokee_admin_reply_query (cherokee_admin_t *admin, cherokee_buffer_t *query, cherokee_buffer_t *reply);



/* Client
 */
ret_t cherokee_admin_add_query   (cherokee_admin_t *admin, char *);
ret_t cherokee_admin_set_poll    (cherokee_admin_t *admin, cherokee_fdpoll_t *poll);
ret_t cherokee_admin_set_request (cherokee_admin_t *admin, cherokee_admin_request_t *req);
ret_t cherokee_admin_step        (cherokee_admin_t *admin);

CHEROKEE_END_DECLS

#endif /* CHEROKEE_ADMIN_H */
