/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common-internal.h"
#include "admin.h"
#include "buffer.h"
#include "downloader.h"
#include "downloader-protected.h"


struct cherokee_admin {
	cherokee_fdpoll_t        *poll;
	cherokee_admin_request_t *req;
	cherokee_downloader_t     downloader;
};

ret_t 
cherokee_admin_new (cherokee_admin_t **admin)
{
	CHEROKEE_NEW_STRUCT(n,admin);

	/* Init
	 */
	n->poll = NULL;
	n->req  = NULL;

	cherokee_downloader_init (&n->downloader);

	/* Return the object
	 */
	*admin = n;
	return ret_ok;
}


ret_t 
cherokee_admin_free (cherokee_admin_t *admin)
{
	cherokee_downloader_mrproper (&admin->downloader);

	free (admin);
	return ret_ok;
}


ret_t 
cherokee_admin_set_poll (cherokee_admin_t *admin, cherokee_fdpoll_t *poll)
{
	if (admin->poll != NULL) {
		PRINT_ERROR_S ("WARNING: Overwritting poll object\n");
	}

	admin->poll = poll;
	return ret_ok;
}


ret_t 
cherokee_admin_set_request (cherokee_admin_t *admin, cherokee_admin_request_t *req)
{
	admin->req = req;
	return ret_ok;
}


ret_t 
cherokee_admin_step (cherokee_admin_t *admin)
{
	return ret_eagain;
}
