/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE2_SERVER_H__
#define __CHEROKEE2_SERVER_H__

#include <time.h>

#include "common.h"
#include "list.h"
#include "fdpoll.h"
#include "plugin_table.h"
#include "virtual_server.h"


typedef struct {
	time_t bogo_now;

	cherokee_fdpoll_t         *fdpoll;
	
	/* Virtual servers
	 */
	cherokee_table_t          *vservers;
	cherokee_virtual_server_t *vserver_default;
	
	/* lists
	 */
	list_t active_list;
	list_t reuse_list;

	/* Configuration
	 */
	int   socket;

	int   fdwatch_msecs;

	int   port;
	int   log;
	int   timeout;
	int   keepalive;

	uid_t user;
	uid_t user_orig;
	gid_t group;
	gid_t group_orig;

	char *mimetypes_file;

	char                          *userdir;              /* Eg: public_html */
	cherokee_plugin_table_entry_t *userdir_handler;     
} cherokee_server_t;


#define SRV(x) ((cherokee_server_t *)(x))


ret_t cherokee_server_new   (cherokee_server_t **srv);
ret_t cherokee_server_init  (cherokee_server_t  *srv);
ret_t cherokee_server_clean (cherokee_server_t  *srv);
ret_t cherokee_server_free  (cherokee_server_t  *srv);

void  cherokee_server_step            (cherokee_server_t  *srv);
void  cherokee_server_set_min_latency (cherokee_server_t  *srv, int msecs);

ret_t cherokee_server_log   (cherokee_server_t  *srv, int active);

ret_t cherokee_server_read_config_file   (cherokee_server_t  *srv, char *filename);
ret_t cherokee_server_read_config_string (cherokee_server_t  *srv, char *string);

#endif /* __CHEROKEE2_SERVER_H__ */
