/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "log.h"
#include <varargs.h>

static int __cherokee_logging = 0;

ret_t 
cherokee_log_init (void)
{
	openlog (PACKAGE, LOG_PID, LOG_DAEMON);
	__cherokee_logging = 1;
	return ret_ok;
}


ret_t 
cherokee_log_close (void)
{
	closelog();
	__cherokee_logging = 0;
	return ret_ok;
}


void inline
cherokee_log (int priority, const char *format, ...)
{
	va_list l;
	
	if (__cherokee_logging) {
		snprintf (gbl_buffer, gbl_buffer_size, format, l);
		
		syslog (priority, "%s", gbl_buffer);
	}
}
