/* A Bison parser, made by GNU Bison 1.875d.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     T_QUOTE = 258,
     T_DENY = 259,
     T_THREAD_NUM = 260,
     T_SSL_CERT_KEY_FILE = 261,
     T_SSL_CERT_FILE = 262,
     T_KEEPALIVE_MAX_REQUESTS = 263,
     T_ERROR_HANDLER = 264,
     T_TIMEOUT = 265,
     T_KEEPALIVE = 266,
     T_DOCUMENT_ROOT = 267,
     T_LOG = 268,
     T_MIME_FILE = 269,
     T_DIRECTORY = 270,
     T_HANDLER = 271,
     T_USER = 272,
     T_GROUP = 273,
     T_POLICY = 274,
     T_SERVER = 275,
     T_USERDIR = 276,
     T_URL = 277,
     T_PIDFILE = 278,
     T_LISTEN = 279,
     T_FILEDIR = 280,
     T_SERVER_TOKENS = 281,
     T_ENCODER = 282,
     T_ALLOW = 283,
     T_BGCOLOR = 284,
     T_TEXT = 285,
     T_LINK = 286,
     T_ALINK = 287,
     T_VLINK = 288,
     T_BACKGROUND = 289,
     T_DIRECTORYINDEX = 290,
     T_IPV6 = 291,
     T_SHOW = 292,
     T_CHROOT = 293,
     T_HEADER_FILE = 294,
     T_ICONS = 295,
     T_AUTH = 296,
     T_NAME = 297,
     T_METHOD = 298,
     T_PASSWDFILE = 299,
     T_SSL_CA_LIST_FILE = 300,
     T_FROM = 301,
     T_SOCKET = 302,
     T_LOG_FLUSH_INTERVAL = 303,
     T_INCLUDE = 304,
     T_PANIC_ACTION = 305,
     T_JUST_ABOUT = 306,
     T_LISTEN_QUEUE_SIZE = 307,
     T_SENDFILE = 308,
     T_MINSIZE = 309,
     T_MAXSIZE = 310,
     T_MAX_FDS = 311,
     T_INTERPRETER = 312,
     T_SCRIPT_ALIAS = 313,
     T_ONLY_SECURE = 314,
     T_MAX_CONNECTION_REUSE = 315,
     T_REWRITE = 316,
     T_NUMBER = 317,
     T_PORT = 318,
     T_QSTRING = 319,
     T_FULLDIR = 320,
     T_ID = 321,
     T_HTTP_URL = 322,
     T_HTTPS_URL = 323,
     T_HOSTNAME = 324,
     T_IP = 325,
     T_DOMAIN_NAME = 326
   };
#endif
#define T_QUOTE 258
#define T_DENY 259
#define T_THREAD_NUM 260
#define T_SSL_CERT_KEY_FILE 261
#define T_SSL_CERT_FILE 262
#define T_KEEPALIVE_MAX_REQUESTS 263
#define T_ERROR_HANDLER 264
#define T_TIMEOUT 265
#define T_KEEPALIVE 266
#define T_DOCUMENT_ROOT 267
#define T_LOG 268
#define T_MIME_FILE 269
#define T_DIRECTORY 270
#define T_HANDLER 271
#define T_USER 272
#define T_GROUP 273
#define T_POLICY 274
#define T_SERVER 275
#define T_USERDIR 276
#define T_URL 277
#define T_PIDFILE 278
#define T_LISTEN 279
#define T_FILEDIR 280
#define T_SERVER_TOKENS 281
#define T_ENCODER 282
#define T_ALLOW 283
#define T_BGCOLOR 284
#define T_TEXT 285
#define T_LINK 286
#define T_ALINK 287
#define T_VLINK 288
#define T_BACKGROUND 289
#define T_DIRECTORYINDEX 290
#define T_IPV6 291
#define T_SHOW 292
#define T_CHROOT 293
#define T_HEADER_FILE 294
#define T_ICONS 295
#define T_AUTH 296
#define T_NAME 297
#define T_METHOD 298
#define T_PASSWDFILE 299
#define T_SSL_CA_LIST_FILE 300
#define T_FROM 301
#define T_SOCKET 302
#define T_LOG_FLUSH_INTERVAL 303
#define T_INCLUDE 304
#define T_PANIC_ACTION 305
#define T_JUST_ABOUT 306
#define T_LISTEN_QUEUE_SIZE 307
#define T_SENDFILE 308
#define T_MINSIZE 309
#define T_MAXSIZE 310
#define T_MAX_FDS 311
#define T_INTERPRETER 312
#define T_SCRIPT_ALIAS 313
#define T_ONLY_SECURE 314
#define T_MAX_CONNECTION_REUSE 315
#define T_REWRITE 316
#define T_NUMBER 317
#define T_PORT 318
#define T_QSTRING 319
#define T_FULLDIR 320
#define T_ID 321
#define T_HTTP_URL 322
#define T_HTTPS_URL 323
#define T_HOSTNAME 324
#define T_IP 325
#define T_DOMAIN_NAME 326




/* Copy the first part of user declarations.  */


/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common-internal.h"

#include <pwd.h>
#include <grp.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <ctype.h>
#include <strings.h>

#include "table.h"
#include "mime.h"
#include "server.h"
#include "server-protected.h"
#include "virtual_server.h"
#include "handler_table_entry.h"
#include "encoder.h"
#include "logger_table.h"
#include "access.h"
#include "list_ext.h"


/* Define the parameter name of the yyparse() argument
 */
#define YYPARSE_PARAM server



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)

typedef union YYSTYPE {
	   int   number;
	   char *string;
	   void *ptr;

	   struct {
			 char *name;
			 void *ptr;
	   } name_ptr;

	   void *list;
} YYSTYPE;
/* Line 191 of yacc.c.  */

# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* What is the right way to import this prototipe?
 */
extern int yylex (void);


extern char *yytext;
extern int   yylineno;

char                                  *current_yacc_file           = NULL;
static cherokee_handler_table_t       *current_handler_table       = NULL;
static cherokee_handler_table_entry_t *current_handler_table_entry = NULL;
static cherokee_virtual_server_t      *current_virtual_server      = NULL;
static cherokee_encoder_table_entry_t *current_encoder_entry       = NULL;
static cherokee_module_info_t         *current_module_info         = NULL;
// static list_t                         *current_list                = NULL;

struct {
	   char                          *handler_name;
	   cherokee_handler_table_entry_t *entry;
	   cherokee_virtual_server_t     *vserver;
	   cherokee_handler_table_t      *plugins;
	   char                          *document_root;
	   char                          *directory_name;
} directory_content_tmp;

typedef struct {
	   void *next;
	   char *string;
} linked_list_t;


#define auto_virtual_server ((current_virtual_server) ? current_virtual_server : SRV(server)->vserver_default)
#define auto_handler_table  ((current_handler_table) ? current_handler_table : (auto_virtual_server)->plugins)


static void
free_linked_list (linked_list_t *list, void (*free_func) (void *))
{
	   linked_list_t *i = list;

	   while (i != NULL) {
			 linked_list_t *prev = i;

			 if ((free_func) && (i->string)) {
				    free_func (i->string);
			 }

			 prev = i;
			 i = i->next;
			 free (prev);
	   }	   
}

static char *
make_finish_with_slash (char *string, int *len)
{
	   char *new;
	   int   new_len;

	   if (string[(*len)-1] == '/') {
			 return string;
	   }

	   new_len = (*len) + 2;
	   new  = (char*) malloc (new_len);

	   *len = snprintf (new, new_len, "%s/", string);

	   free (string);
	   return new;
}

static char *
make_slash_end (char *string)
{
	   int len = strlen(string);
	   return make_finish_with_slash (string, &len);
}

cherokee_handler_table_entry_t *
handler_table_entry_new (void)
{
	   cherokee_handler_table_entry_t *entry;

	   cherokee_handler_table_entry_new (&entry);
	   current_handler_table_entry = entry;

	   return entry;
}


char *
new_string_to_lowercase (const char *in)
{
	   int   i;
	   char *tmp;
	   
	   i = strlen(in);
	   tmp = (char *) malloc (i+1);
	   tmp[i] = '\0';

	   while (i--) {
			 tmp[i] = tolower(in[i]);
	   }

	   return tmp;
}


void
yyerror (char* msg)
{
	   char *config;

	   config = (current_yacc_file) ? current_yacc_file : "";

        PRINT_ERROR ("Error parsing file %s:%d '%s', symbol '%s'\n", 
				 config, yylineno, msg, yytext);
}



/* Line 214 of yacc.c.  */


#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  111
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   211

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  75
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  75
/* YYNRULES -- Number of rules. */
#define YYNRULES  154
/* YYNRULES -- Number of states. */
#define YYNSTATES  236

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   326

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    72,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    73,     2,    74,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     4,     6,     8,    11,    13,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    89,    92,    93,    96,    97,
     100,   101,   104,   105,   108,   109,   112,   113,   116,   118,
     122,   124,   128,   130,   134,   137,   140,   143,   146,   147,
     152,   153,   157,   158,   161,   164,   167,   170,   173,   176,
     179,   182,   185,   188,   191,   192,   197,   201,   202,   205,
     208,   211,   214,   217,   220,   225,   228,   231,   234,   237,
     240,   244,   248,   249,   252,   255,   258,   261,   264,   267,
     273,   276,   278,   280,   283,   287,   290,   293,   296,   299,
     302,   305,   308,   311,   314,   317,   319,   322,   325,   328,
     330,   332,   334,   335,   342,   343,   350,   352,   355,   361,
     365,   367,   370,   374,   378,   379,   380,   383,   386,   387,
     394,   397,   398,   402,   403
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
      76,     0,    -1,    -1,    77,    -1,    79,    -1,    77,    79,
      -1,    81,    -1,    78,    81,    -1,    81,    -1,    80,    -1,
     135,    -1,    92,    -1,    93,    -1,   101,    -1,   102,    -1,
     103,    -1,   104,    -1,   105,    -1,   106,    -1,   114,    -1,
     127,    -1,   128,    -1,   129,    -1,   130,    -1,   122,    -1,
     123,    -1,   126,    -1,   146,    -1,   148,    -1,    94,    -1,
     115,    -1,   116,    -1,   117,    -1,   118,    -1,   120,    -1,
     121,    -1,   137,    -1,    95,    -1,    96,    -1,   110,    -1,
     107,    -1,   108,    -1,   109,    -1,   144,    -1,    -1,    82,
     139,    -1,    -1,    83,   119,    -1,    -1,    84,   133,    -1,
      -1,    85,   113,    -1,    -1,    86,   125,    -1,    -1,    87,
     140,    -1,    -1,    88,   137,    -1,    66,    -1,    66,    72,
      89,    -1,   134,    -1,   134,    72,    90,    -1,    70,    -1,
      70,    72,    91,    -1,    63,    62,    -1,    24,   134,    -1,
      48,    62,    -1,    12,    65,    -1,    -1,    13,    66,    97,
      98,    -1,    -1,    73,    99,    74,    -1,    -1,    99,   100,
      -1,    66,    65,    -1,    26,    66,    -1,    14,    65,    -1,
      40,    65,    -1,    10,    62,    -1,    11,    62,    -1,     8,
      62,    -1,     7,    65,    -1,     6,    65,    -1,    45,    65,
      -1,    -1,    27,    66,   111,   112,    -1,    73,    85,    74,
      -1,    -1,    28,    89,    -1,     4,    89,    -1,    23,    65,
      -1,    49,    65,    -1,    50,    65,    -1,    52,    62,    -1,
      53,    73,    83,    74,    -1,    54,    62,    -1,    55,    62,
      -1,    56,    62,    -1,    60,    62,    -1,    38,    65,    -1,
       5,    62,   124,    -1,    73,    86,    74,    -1,    -1,    19,
      66,    -1,    36,    62,    -1,    17,    66,    -1,    17,    62,
      -1,    18,    66,    -1,    18,    62,    -1,    16,    66,    73,
      84,    74,    -1,    16,    66,    -1,    67,    -1,    68,    -1,
      22,   132,    -1,    61,    64,    64,    -1,    22,    65,    -1,
      25,    65,    -1,    29,    66,    -1,    30,    66,    -1,    31,
      66,    -1,    33,    66,    -1,    32,    66,    -1,    39,    66,
      -1,    47,    65,    -1,    57,    65,    -1,    51,    -1,    58,
      65,    -1,    62,   132,    -1,    37,    89,    -1,    66,    -1,
      70,    -1,    71,    -1,    -1,    20,    90,    73,   136,    78,
      74,    -1,    -1,    15,    65,    73,   138,    82,    74,    -1,
     131,    -1,    12,    65,    -1,    41,    89,    73,    87,    74,
      -1,    28,    46,    91,    -1,    59,    -1,    42,    64,    -1,
      43,    66,   141,    -1,    73,   142,    74,    -1,    -1,    -1,
     142,   143,    -1,    44,    65,    -1,    -1,    21,    66,   145,
      73,    88,    74,    -1,    35,    89,    -1,    -1,    73,    84,
      74,    -1,    -1,     9,    66,   149,   147,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   212,   212,   213,   216,   217,   220,   221,   224,   225,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   256,   257,   258,   259,
     260,   261,   262,   263,   266,   267,   269,   270,   272,   273,
     275,   276,   278,   279,   281,   282,   284,   285,   290,   299,
     312,   321,   334,   343,   352,   357,   362,   367,   389,   388,
     414,   415,   417,   418,   421,   434,   452,   457,   462,   470,
     475,   480,   497,   514,   533,   532,   563,   564,   566,   587,
     608,   627,   632,   642,   647,   649,   654,   659,   664,   669,
     674,   681,   682,   684,   700,   705,   720,   725,   740,   745,
     751,   757,   758,   760,   765,   790,   795,   800,   803,   806,
     809,   812,   815,   818,   821,   824,   827,   830,   843,   872,
     873,   874,   880,   879,   917,   916,   997,  1003,  1016,  1040,
    1057,  1067,  1076,  1096,  1097,  1100,  1101,  1104,  1110,  1109,
    1138,  1151,  1152,  1155,  1154
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "T_QUOTE", "T_DENY", "T_THREAD_NUM",
  "T_SSL_CERT_KEY_FILE", "T_SSL_CERT_FILE", "T_KEEPALIVE_MAX_REQUESTS",
  "T_ERROR_HANDLER", "T_TIMEOUT", "T_KEEPALIVE", "T_DOCUMENT_ROOT",
  "T_LOG", "T_MIME_FILE", "T_DIRECTORY", "T_HANDLER", "T_USER", "T_GROUP",
  "T_POLICY", "T_SERVER", "T_USERDIR", "T_URL", "T_PIDFILE", "T_LISTEN",
  "T_FILEDIR", "T_SERVER_TOKENS", "T_ENCODER", "T_ALLOW", "T_BGCOLOR",
  "T_TEXT", "T_LINK", "T_ALINK", "T_VLINK", "T_BACKGROUND",
  "T_DIRECTORYINDEX", "T_IPV6", "T_SHOW", "T_CHROOT", "T_HEADER_FILE",
  "T_ICONS", "T_AUTH", "T_NAME", "T_METHOD", "T_PASSWDFILE",
  "T_SSL_CA_LIST_FILE", "T_FROM", "T_SOCKET", "T_LOG_FLUSH_INTERVAL",
  "T_INCLUDE", "T_PANIC_ACTION", "T_JUST_ABOUT", "T_LISTEN_QUEUE_SIZE",
  "T_SENDFILE", "T_MINSIZE", "T_MAXSIZE", "T_MAX_FDS", "T_INTERPRETER",
  "T_SCRIPT_ALIAS", "T_ONLY_SECURE", "T_MAX_CONNECTION_REUSE", "T_REWRITE",
  "T_NUMBER", "T_PORT", "T_QSTRING", "T_FULLDIR", "T_ID", "T_HTTP_URL",
  "T_HTTPS_URL", "T_HOSTNAME", "T_IP", "T_DOMAIN_NAME", "','", "'{'",
  "'}'", "$accept", "conffile", "lines", "server_lines", "line",
  "common_line", "server_line", "directory_options", "sendfile_options",
  "handler_options", "encoder_options", "thread_options", "auth_options",
  "directories", "id_list", "domain_list", "ip_list", "port", "listen",
  "log_flush_interval", "document_root", "log", "@1", "log_optional",
  "tuple_list", "tuple", "server_tokens", "mime", "icons", "timeout",
  "keepalive", "keepalive_max_requests", "ssl_file", "ssl_key_file",
  "ssl_ca_list_file", "encoder", "@2", "maybe_encoder_options",
  "encoder_option", "pidfile", "include", "panic_action",
  "listen_queue_size", "sendfile", "sendfile_option", "maxfds",
  "maxconnectionreuse", "chroot", "thread_number", "maybe_thread_options",
  "thread_option", "ipv6", "user1", "user2", "group1", "group2", "handler",
  "http_generic", "handler_option", "host_name", "server", "@3",
  "directory", "@4", "directory_option", "auth_option",
  "maybe_auth_option_params", "auth_option_params", "auth_option_param",
  "userdir", "@5", "directoryindex", "maybe_handlererror_options",
  "errorhandler", "@6", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,    44,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    75,    76,    76,    77,    77,    78,    78,    79,    79,
      80,    80,    80,    80,    80,    80,    80,    80,    80,    80,
      80,    80,    80,    80,    80,    80,    80,    80,    80,    80,
      80,    80,    80,    80,    80,    80,    81,    81,    81,    81,
      81,    81,    81,    81,    82,    82,    83,    83,    84,    84,
      85,    85,    86,    86,    87,    87,    88,    88,    89,    89,
      90,    90,    91,    91,    92,    93,    94,    95,    97,    96,
      98,    98,    99,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   111,   110,   112,   112,   113,   113,
     114,   115,   116,   117,   118,   119,   119,   120,   121,   122,
     123,   124,   124,   125,   126,   127,   128,   129,   130,   131,
     131,   132,   132,   133,   133,   133,   133,   133,   133,   133,
     133,   133,   133,   133,   133,   133,   133,   133,   133,   134,
     134,   134,   136,   135,   138,   137,   139,   139,   139,   139,
     139,   140,   140,   141,   141,   142,   142,   143,   145,   144,
     146,   147,   147,   149,   148
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     1,     1,     2,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     0,     2,     0,     2,
       0,     2,     0,     2,     0,     2,     0,     2,     1,     3,
       1,     3,     1,     3,     2,     2,     2,     2,     0,     4,
       0,     3,     0,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     0,     4,     3,     0,     2,     2,
       2,     2,     2,     2,     4,     2,     2,     2,     2,     2,
       3,     3,     0,     2,     2,     2,     2,     2,     2,     5,
       2,     1,     1,     2,     3,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     1,     2,     2,     2,     1,
       1,     1,     0,     6,     0,     6,     1,     2,     5,     3,
       1,     2,     3,     3,     0,     0,     2,     2,     0,     6,
       2,     0,     3,     0,     4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     3,     4,     9,     8,    11,    12,
      29,    37,    38,    13,    14,    15,    16,    17,    18,    40,
      41,    42,    39,    19,    30,    31,    32,    33,    34,    35,
      24,    25,    26,    20,    21,    22,    23,    10,    36,    43,
      27,    28,   102,    82,    81,    80,   153,    78,    79,    67,
      68,    76,     0,   106,   105,   108,   107,   129,   130,   131,
       0,    60,   148,    90,    65,    75,    84,    58,   150,   104,
      99,    77,    83,    66,    91,    92,    93,    46,    97,    98,
      64,     1,     5,    52,   100,   151,    70,   134,   132,     0,
       0,    87,     0,     0,     0,    48,   154,    72,    69,    44,
       0,    61,    56,    50,    85,    59,     0,     0,    94,    47,
       0,   101,    53,     0,     0,     0,     0,     6,     0,     0,
      95,    96,   103,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   125,     0,     0,     0,     0,   152,    49,
       0,    71,    73,     0,     0,     0,     0,   140,   135,   136,
      45,   133,     7,   149,    57,     0,     0,    86,    51,   115,
     111,   112,   113,   116,   117,   118,   119,   121,   120,   128,
     122,   123,   124,   126,     0,   127,    74,   137,   110,     0,
       0,    89,    88,   114,    48,    62,   139,    54,     0,     0,
       0,   109,    63,     0,     0,   138,    55,   141,   144,   145,
     142,     0,     0,   143,   146,   147
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    33,    34,   146,    35,    36,    37,   145,   123,   143,
     149,   124,   220,   148,    98,    90,   216,    38,    39,    40,
      41,    42,   116,   128,   144,   172,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,   121,   134,   188,    53,
      54,    55,    56,    57,   139,    58,    59,    60,    61,   114,
     142,    62,    63,    64,    65,    66,   179,   192,   169,    91,
      67,   130,    68,   129,   180,   226,   230,   231,   234,    69,
     120,    70,   126,    71,   115
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -120
static const short int yypact[] =
{
      67,   -39,   -34,   -26,   -17,   -15,    -9,    -1,    -7,    -2,
      -6,     0,   -32,   -29,   -22,     2,    18,   -22,    20,    23,
      26,    33,    31,    32,    34,    36,    35,    39,    44,    28,
      46,    47,    48,    62,    67,  -120,  -120,  -120,  -120,  -120,
    -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,
    -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,
    -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,
    -120,  -120,    38,  -120,  -120,  -120,  -120,  -120,  -120,  -120,
    -120,  -120,    40,  -120,  -120,  -120,  -120,  -120,  -120,  -120,
      41,    49,  -120,  -120,  -120,  -120,  -120,    50,  -120,  -120,
    -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,
    -120,  -120,  -120,  -120,  -120,    45,    51,  -120,  -120,   -22,
      53,    56,    26,   -27,   -14,  -120,  -120,  -120,  -120,  -120,
       5,  -120,  -120,  -120,  -120,  -120,    69,    75,  -120,  -120,
      72,  -120,  -120,   103,   -45,    -3,    -5,  -120,   -11,    -4,
    -120,  -120,  -120,   -13,    74,    77,    78,    79,    80,    81,
      26,    82,    76,  -120,    84,    86,    88,   -25,  -120,  -120,
      90,  -120,  -120,    91,    87,   111,    26,  -120,  -120,  -120,
    -120,  -120,  -120,  -120,  -120,    26,    26,  -120,  -120,  -120,
    -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,
    -120,  -120,  -120,  -120,    94,  -120,  -120,  -120,    98,    93,
      99,  -120,  -120,  -120,  -120,   101,  -120,  -120,   137,    93,
     -28,  -120,  -120,   114,   109,  -120,  -120,  -120,   106,  -120,
    -120,   -38,   115,  -120,  -120,  -120
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -120,  -120,  -120,  -120,   147,  -120,  -111,  -120,  -120,   -31,
    -120,  -120,  -120,  -120,  -119,    63,   -33,  -120,  -120,  -120,
    -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,
    -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,
    -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,  -120,
    -120,  -120,  -120,  -120,  -120,  -120,  -120,    22,  -120,   168,
    -120,  -120,    42,  -120,  -120,  -120,  -120,  -120,  -120,  -120,
    -120,  -120,  -120,  -120,  -120
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
     185,     2,     3,   135,    11,   140,   232,     8,     9,   173,
      11,     2,     3,   174,   223,   224,    15,     8,     9,   147,
      11,   170,    19,    72,   186,   175,    15,   136,   137,   171,
      83,    73,    19,    85,    84,   182,   233,    86,   176,    74,
      24,   199,   190,   191,    87,    75,   225,   138,    88,    89,
      24,    76,   189,    77,   190,   191,   177,   210,    79,    81,
     141,    78,   111,   183,    80,    82,   211,   212,    92,   181,
     187,   178,     1,     2,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    93,    12,    13,    95,    14,    15,    96,
      16,    17,    97,    18,    19,    99,   100,   101,   103,   102,
     104,   107,    20,    21,   105,    22,   106,    23,   108,   109,
     110,   113,    24,   117,   118,    25,    26,    27,   125,    28,
      29,   119,   122,    30,   127,   153,   132,    31,   154,   133,
      32,   150,   155,   156,   157,   158,   159,   151,   152,   193,
     160,   201,   161,   194,   195,   196,   197,   198,   200,   202,
     162,   203,   204,   208,   163,   206,   207,   209,   213,   153,
     164,   165,   154,   215,   166,   167,   155,   156,   157,   158,
     159,   214,   217,   219,   160,   228,   161,   168,   227,   229,
     235,   112,   131,   218,   162,    94,   222,     0,   163,   205,
     184,     0,     0,     0,   164,   165,     0,     0,   166,   167,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   221
};

static const short int yycheck[] =
{
       4,     6,     7,   122,    15,    19,    44,    12,    13,    12,
      15,     6,     7,    16,    42,    43,    21,    12,    13,   130,
      15,    66,    27,    62,    28,    28,    21,    54,    55,    74,
      62,    65,    27,    62,    66,   146,    74,    66,    41,    65,
      45,   160,    67,    68,    66,    62,    74,    74,    70,    71,
      45,    66,    65,    62,    67,    68,    59,   176,    65,    65,
      74,    62,     0,    74,    66,    65,   185,   186,    66,    74,
      74,    74,     5,     6,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    65,    17,    18,    66,    20,    21,    66,
      23,    24,    66,    26,    27,    62,    65,    65,    62,    65,
      65,    73,    35,    36,    65,    38,    62,    40,    62,    62,
      62,    73,    45,    73,    73,    48,    49,    50,    73,    52,
      53,    72,    72,    56,    73,    22,    73,    60,    25,    73,
      63,    62,    29,    30,    31,    32,    33,    62,    66,    65,
      37,    65,    39,    66,    66,    66,    66,    66,    66,    65,
      47,    65,    64,    66,    51,    65,    65,    46,    64,    22,
      57,    58,    25,    70,    61,    62,    29,    30,    31,    32,
      33,    73,    73,    72,    37,    66,    39,    74,    64,    73,
      65,    34,   119,   214,    47,    17,   219,    -1,    51,   167,
     148,    -1,    -1,    -1,    57,    58,    -1,    -1,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    74
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    17,    18,    20,    21,    23,    24,    26,    27,
      35,    36,    38,    40,    45,    48,    49,    50,    52,    53,
      56,    60,    63,    76,    77,    79,    80,    81,    92,    93,
      94,    95,    96,   101,   102,   103,   104,   105,   106,   107,
     108,   109,   110,   114,   115,   116,   117,   118,   120,   121,
     122,   123,   126,   127,   128,   129,   130,   135,   137,   144,
     146,   148,    62,    65,    65,    62,    66,    62,    62,    65,
      66,    65,    65,    62,    66,    62,    66,    66,    70,    71,
      90,   134,    66,    65,   134,    66,    66,    66,    89,    62,
      65,    65,    65,    62,    65,    65,    62,    73,    62,    62,
      62,     0,    79,    73,   124,   149,    97,    73,    73,    72,
     145,   111,    72,    83,    86,    73,   147,    73,    98,   138,
     136,    90,    73,    73,   112,    89,    54,    55,    74,   119,
      19,    74,   125,    84,    99,    82,    78,    81,    88,    85,
      62,    62,    66,    22,    25,    29,    30,    31,    32,    33,
      37,    39,    47,    51,    57,    58,    61,    62,    74,   133,
      66,    74,   100,    12,    16,    28,    41,    59,    74,   131,
     139,    74,    81,    74,   137,     4,    28,    74,   113,    65,
      67,    68,   132,    65,    66,    66,    66,    66,    66,    89,
      66,    65,    65,    65,    64,   132,    65,    65,    66,    46,
      89,    89,    89,    64,    73,    70,    91,    73,    84,    72,
      87,    74,    91,    42,    43,    74,   140,    64,    66,    73,
     141,   142,    44,    74,   143,    65
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 58:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;
	   
	   yyval.list = n;
}
    break;

  case 59:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));

	   n->next = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 60:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;
	   
	   yyval.list = n;
}
    break;

  case 61:

    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));

	   n->next = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 62:

    {
	   linked_list_t *n = (linked_list_t *) malloc (sizeof(linked_list_t));
	   n->next   = NULL;
	   n->string = yyvsp[0].string;

	   yyval.list = n;
}
    break;

  case 63:

    {
	   linked_list_t *n = (linked_list_t *) malloc (sizeof(linked_list_t));
	   n->next   = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 64:

    {
	   SRV(server)->port = yyvsp[0].number;
}
    break;

  case 65:

    {
	   SRV(server)->listen_to = yyvsp[0].string;
}
    break;

  case 66:

    {
	   SRV(server)->log_flush_elapse = yyvsp[0].number;
}
    break;

  case 67:

    {
	   char                      *root;
	   int                        root_len;
	   cherokee_virtual_server_t *vserver;

	   vserver = auto_virtual_server;

	   root     = yyvsp[0].string;
	   root_len = strlen(yyvsp[0].string);

	   /* Check for the endding slash
	    */
	   root = make_finish_with_slash (root, &root_len);

	   /* Add the virtual root path to the virtual server struct
	    */
	   cherokee_buffer_add (vserver->root, root, root_len);
}
    break;

  case 68:

    {
	   ret_t ret;

	   /* Maybe load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load logger module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   cherokee_module_loader_get (SRV(server)->loader, yyvsp[0].string, &current_module_info);
}
    break;

  case 69:

    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   /* Instance the logger object
	    */
	   cherokee_logger_table_new_logger (SRV(server)->loggers, yyvsp[-2].string, current_module_info,
								  vserver->logger_props, &vserver->logger);
	   current_module_info = NULL;
}
    break;

  case 74:

    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   if (vserver->logger_props == NULL) {
			 cherokee_table_new (&vserver->logger_props);
	   }

	   cherokee_table_add (vserver->logger_props, yyvsp[-1].string, yyvsp[0].string);
}
    break;

  case 75:

    {
	   if (!strncasecmp("Product", yyvsp[0].string, 7)) {
			 SRV(server)->server_token = cherokee_version_product;
	   } else if (!strncasecmp("Minor", yyvsp[0].string, 5)) {
			 SRV(server)->server_token = cherokee_version_minor;
	   } else if (!strncasecmp("Minimal", yyvsp[0].string, 7)) {
			 SRV(server)->server_token = cherokee_version_minimal;
	   } else if (!strncasecmp("OS", yyvsp[0].string, 2)) {
			 SRV(server)->server_token = cherokee_version_os;
	   } else if (!strncasecmp("Full", yyvsp[0].string, 4)) {
			 SRV(server)->server_token = cherokee_version_full;
	   } else {
			 PRINT_ERROR ("ERROR: Unknown server token '%s'\n", yyvsp[0].string);
			 return 1;
	   }
}
    break;

  case 76:

    {
	   SRV(server)->mime_file = yyvsp[0].string;
}
    break;

  case 77:

    {
	   SRV(server)->icons_file = yyvsp[0].string;
}
    break;

  case 78:

    {
	   SRV(server)->timeout = yyvsp[0].number;

	   cherokee_buffer_clean  (SRV(server)->timeout_header);
	   cherokee_buffer_add_va (SRV(server)->timeout_header, "Keep-Alive: timeout=%d"CRLF, yyvsp[0].number);
}
    break;

  case 79:

    {
	   SRV(server)->keepalive = (yyvsp[0].number == 0) ? false : true;
}
    break;

  case 80:

    {
	   SRV(server)->keepalive_max = yyvsp[0].number;
}
    break;

  case 81:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_cert != NULL) {
			 PRINT_ERROR ("ERROR: \"SSLCertificateFile\" overlaps: '%s' <- '%s'\n", vsrv->server_cert, yyvsp[0].string);
			 free (vsrv->server_cert);
	   }

	   vsrv->server_cert = yyvsp[0].string;

#else
	   PRINT_ERROR_S ("WARNING: Ignoring SSL configuration entry: \"SSLCertificateFile\"\n");
#endif
}
    break;

  case 82:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_key != NULL) {
			 PRINT_ERROR ("ERROR: \"SSLCertificateKeyFile\" overlaps: '%s' <- '%s'\n", vsrv->server_key, yyvsp[0].string);
			 free (vsrv->server_key);
	   }

	   vsrv->server_key = yyvsp[0].string;

#else
	   PRINT_ERROR_S ("WARNING: Ignoring SSL configuration entry: \"SSLCertificateKeyFile\"\n");
#endif
}
    break;

  case 83:

    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->ca_cert != NULL) {
			 PRINT_ERROR ("ERROR: \"SSLCAListFile\" overlaps: '%s' <- '%s'\n", vsrv->ca_cert, yyvsp[0].string);
			 free (vsrv->ca_cert);
	   }

	   vsrv->ca_cert = yyvsp[0].string;

#else
	   PRINT_ERROR_S ("WARNING: Ignoring SSL configuration entry: \"SSLCAListFile\"\n");
#endif
}
    break;

  case 84:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;
	   cherokee_encoder_table_entry_t *enc;

	   /* Load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load encoder module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[0].string, &info);

	   /* Set the info in the new entry
	    */
	   cherokee_encoder_table_entry_new (&enc);
	   cherokee_encoder_table_entry_get_info (enc, info);

	   /* Set in the encoders table
	    */
	   cherokee_encoder_table_set (SRV(server)->encoders, yyvsp[0].string, enc);
	   current_encoder_entry = enc;
}
    break;

  case 85:

    {
	   current_encoder_entry = NULL;
}
    break;

  case 88:

    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = yyvsp[0].list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_allow (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 89:

    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = yyvsp[0].list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_deny (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 90:

    {
	   FILE *file;
	   CHEROKEE_TEMP(buffer, 10);

	   file = fopen (yyvsp[0].string, "w");
	   if (file == NULL) {
			 PRINT_ERROR ("ERROR: Can't write PID file '%s': %s\n", yyvsp[0].string, strerror(errno));
			 return 0;
	   }

	   snprintf (buffer, buffer_size, "%d\n", getpid());
	   fwrite (buffer, 1, strlen(buffer), file);
	   fclose (file);

	   free (yyvsp[0].string);
}
    break;

  case 91:

    {
	   cherokee_list_add_tail (&SRV(server)->include_list, yyvsp[0].string);
}
    break;

  case 92:

    {
	   if (SRV(server)->panic_action != NULL) {
			 PRINT_ERROR ("WARNING: Overwriting panic action '%s' by '%s'\n", SRV(server)->panic_action, yyvsp[0].string);
			 free (SRV(server)->panic_action);
	   }

	   SRV(server)->panic_action = yyvsp[0].string;
}
    break;

  case 93:

    {
	   SRV(server)->listen_queue = yyvsp[0].number;
}
    break;

  case 95:

    {
	   SRV(server)->sendfile.min = yyvsp[0].number;
}
    break;

  case 96:

    {
	   SRV(server)->sendfile.max = yyvsp[0].number;
}
    break;

  case 97:

    {
	   SRV(server)->max_fds = yyvsp[0].number;
}
    break;

  case 98:

    {
	   SRV(server)->max_conn_reuse = yyvsp[0].number;
}
    break;

  case 99:

    {
	   SRV(server)->chroot = yyvsp[0].string;
}
    break;

  case 100:

    {
#ifdef HAVE_PTHREAD
	   SRV(server)->thread_num = yyvsp[-1].number;
#endif
}
    break;

  case 103:

    {
#ifdef HAVE_PTHREAD
	   if (strcasecmp(yyvsp[0].string, "fifo") == 0) {
			 SRV(server)->thread_policy = SCHED_FIFO;
	   } else if (strcasecmp(yyvsp[0].string, "rr") == 0) {
			 SRV(server)->thread_policy = SCHED_RR;
	   } else if (strcasecmp(yyvsp[0].string, "other") == 0) {
			 SRV(server)->thread_policy = SCHED_OTHER;
	   } else {
			 PRINT_ERROR ("ERROR: unknown scheduling policy '%s'\n", yyvsp[0].string);
	   }
#endif
}
    break;

  case 104:

    {
	   SRV(server)->ipv6 = yyvsp[0].number;
}
    break;

  case 105:

    {
	   struct passwd *pwd;
	   
	   pwd = (struct passwd *) getpwnam (yyvsp[0].string);
	   if (pwd == NULL) {
			 PRINT_ERROR ("ERROR: User '%s' not found in the system", yyvsp[0].string);
			 return 1;
	   }

	   SRV(server)->user = pwd->pw_uid;

	   free (yyvsp[0].string);
}
    break;

  case 106:

    {
	   SRV(server)->user = yyvsp[0].number;
}
    break;

  case 107:

    {
	   struct group *grp;

	   grp = (struct group *) getgrnam (yyvsp[0].string);
	   if (grp == NULL) {
			 PRINT_ERROR ("ERROR: Group '%s' not found in the system", yyvsp[0].string);
			 return 1;
	   }

	   SRV(server)->group = grp->gr_gid;

	   free (yyvsp[0].string);
}
    break;

  case 108:

    {
	   SRV(server)->group = yyvsp[0].number;
}
    break;

  case 109:

    {
	   yyval.name_ptr.name = yyvsp[-3].string;
	   yyval.name_ptr.ptr = current_handler_table_entry;
}
    break;

  case 110:

    {
	   yyval.name_ptr.name = yyvsp[0].string;
	   yyval.name_ptr.ptr = current_handler_table_entry;
}
    break;

  case 111:

    { yyval.string = yyvsp[0].string; }
    break;

  case 112:

    { yyval.string = yyvsp[0].string; }
    break;

  case 113:

    {
	   cherokee_handler_table_entry_set (current_handler_table_entry, "url", yyvsp[0].string);
}
    break;

  case 114:

    {
	int *count = NULL;
	char name[32];

	if (current_handler_table_entry->properties != NULL)
		count = cherokee_table_get_val(current_handler_table_entry->properties, "regex_count");

	if (count == NULL)
	{
		count = (int*)malloc(sizeof(int));
		*count = 1;

		cherokee_handler_table_entry_set (current_handler_table_entry, "regex_count", (void *)count);
	} else {
		++*count;
	}

	snprintf(name, sizeof(name), "regex_%d_expr", *count - 1);
	cherokee_handler_table_entry_set (current_handler_table_entry, name, yyvsp[-1].string);

	snprintf(name, sizeof(name), "regex_%d_subs", *count - 1);
	cherokee_handler_table_entry_set (current_handler_table_entry, name, yyvsp[0].string);
}
    break;

  case 115:

    {
	   cherokee_handler_table_entry_set (current_handler_table_entry, "url", yyvsp[0].string);
}
    break;

  case 116:

    {
	   cherokee_handler_table_entry_set (current_handler_table_entry, "filedir", yyvsp[0].string);
}
    break;

  case 117:

    { cherokee_handler_table_entry_set (current_handler_table_entry, "bgcolor", yyvsp[0].string); }
    break;

  case 118:

    { cherokee_handler_table_entry_set (current_handler_table_entry, "text", yyvsp[0].string); }
    break;

  case 119:

    { cherokee_handler_table_entry_set (current_handler_table_entry, "link", yyvsp[0].string); }
    break;

  case 120:

    { cherokee_handler_table_entry_set (current_handler_table_entry, "vlink", yyvsp[0].string); }
    break;

  case 121:

    { cherokee_handler_table_entry_set (current_handler_table_entry, "alink", yyvsp[0].string); }
    break;

  case 122:

    { cherokee_handler_table_entry_set (current_handler_table_entry, "headerfile", yyvsp[0].string); }
    break;

  case 123:

    { cherokee_handler_table_entry_set (current_handler_table_entry, "socket", yyvsp[0].string); }
    break;

  case 124:

    { cherokee_handler_table_entry_set (current_handler_table_entry, "interpreter", yyvsp[0].string); }
    break;

  case 125:

    { cherokee_handler_table_entry_set (current_handler_table_entry, "about", NULL); }
    break;

  case 126:

    { cherokee_handler_table_entry_set (current_handler_table_entry, "scriptalias", yyvsp[0].string); }
    break;

  case 127:

    {
	   char code[4];

	   if ((yyvsp[-1].number < 100) || (yyvsp[-1].number >= http_type_500_max)) {
			 PRINT_ERROR("ERROR: Incorrect HTTP code number %d\n", yyvsp[-1].number);
			 return 1;
	   }

	   snprintf (code, 4, "%d", yyvsp[-1].number);
	   cherokee_handler_table_entry_set (current_handler_table_entry, code, yyvsp[0].string);
}
    break;

  case 128:

    {
	   linked_list_t *i;

	   i = yyvsp[0].list;
	   while (i != NULL) {
			 if ((!strncasecmp (i->string, "date",  4)) ||
				(!strncasecmp (i->string, "size",  4)) ||
				(!strncasecmp (i->string, "group", 5)) ||
				(!strncasecmp (i->string, "owner", 5)))
			 {
				    char *lower;

				    lower = new_string_to_lowercase (i->string);
				    free (i->string);
				    i->string = lower;

				    cherokee_handler_table_entry_set (current_handler_table_entry, i->string, i->string);				    
			 } else {
				    PRINT_ERROR ("ERROR: Unknown parameter '%s' for \"Show\"", i->string);
			 }
				
			 i = i->next;
	   }

	   free_linked_list (yyvsp[0].list, free);
}
    break;

  case 131:

    {
	   yyval.string = yyvsp[0].string;
}
    break;

  case 132:

    {
	   linked_list_t *i = yyvsp[-1].list;
	   CHEROKEE_NEW(vsrv, virtual_server);

	   current_virtual_server = vsrv;
	   current_handler_table  = vsrv->plugins;

	   /* Add the virtual server to the list
	    */
	   list_add ((list_t *)vsrv, &SRV(server)->vservers);

	   /* Add default virtual server name
	    */
	   if (i->string != NULL) {
			 cherokee_buffer_t *name = current_virtual_server->name;

			 if (cherokee_buffer_is_empty (name)) {
				    cherokee_buffer_add_va (name, "%s", i->string);
			 }
	   }

	   /* Add all the alias to the table
	    */
	   while (i != NULL) {
			 cherokee_table_add (SRV(server)->vservers_ref, i->string, vsrv);
			 i = i->next;
	   }
	   free_linked_list (yyvsp[-1].list, NULL);

}
    break;

  case 133:

    {

	   current_virtual_server = NULL;
	   current_handler_table  = NULL;
}
    break;

  case 134:

    {
	   /* Fill the tmp struct
	    */
	   directory_content_tmp.directory_name = yyvsp[-1].string;
	   directory_content_tmp.vserver        = auto_virtual_server;
	   directory_content_tmp.plugins        = auto_handler_table;
	   directory_content_tmp.entry          = handler_table_entry_new (); /* new! */
	   directory_content_tmp.handler_name   = NULL;
	   directory_content_tmp.document_root  = NULL;
}
    break;

  case 135:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;

	   /* Basic checks
	    */
	   if (directory_content_tmp.handler_name == NULL) {
			 PRINT_ERROR ("ERROR: Directory %s needs a handler; this directory entry is ignored.\n", directory_content_tmp.directory_name);
			 goto out;
	   }

	   /* Set the document_root in the entry
	    */
	   if (directory_content_tmp.document_root != NULL) {
			 cherokee_buffer_make_empty(directory_content_tmp.entry->document_root);
			 cherokee_buffer_add_va (directory_content_tmp.entry->document_root, "%s",
								directory_content_tmp.document_root);
	   }

	   /* Load the module 
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, directory_content_tmp.handler_name);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Loading module '%s'\n", directory_content_tmp.handler_name);
			 return 1;
	   }
	   
	   ret = cherokee_module_loader_get  (SRV(server)->loader, directory_content_tmp.handler_name, &info);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Loading module '%s'\n", directory_content_tmp.handler_name);
			 return 1;
	   }
	   
	   cherokee_handler_table_enty_get_info (directory_content_tmp.entry, info);
	   
	   /* Add "web_dir -> entry" in the plugins table
	    */
	   ret = cherokee_handler_table_add (directory_content_tmp.plugins,
								  directory_content_tmp.directory_name,
								  directory_content_tmp.entry);
	   if (ret != ret_ok) {
			 switch (ret) {
			 case ret_file_not_found:
				    PRINT_ERROR ("ERROR: Can't load handler '%s': File not found\n",
							  directory_content_tmp.handler_name);
				    break;
			 default:
				    PRINT_ERROR ("ERROR: Can't load handler '%s': Unknown error\n",
							  directory_content_tmp.handler_name);
			 }
	   }


	   /* Clean
	    */
out:
	   if (directory_content_tmp.document_root != NULL) {
			 free (directory_content_tmp.document_root);
			 directory_content_tmp.document_root = NULL;
	   }
	   directory_content_tmp.vserver       = NULL;
	   directory_content_tmp.plugins       = NULL;
	   directory_content_tmp.entry         = NULL;
	   directory_content_tmp.handler_name  = NULL;

	   current_handler_table_entry = NULL;
}
    break;

  case 136:

    {	   
	   directory_content_tmp.handler_name = yyvsp[0].name_ptr.name;
}
    break;

  case 137:

    {
	   if (directory_content_tmp.document_root != NULL) {
			 PRINT_ERROR ("WARNING: Overwriting DocumentRoot '%s' by '%s'\n",
					    directory_content_tmp.document_root, yyvsp[0].string);

			 free (directory_content_tmp.document_root);
	   }

	   directory_content_tmp.document_root = make_slash_end (yyvsp[0].string);
}
    break;

  case 138:

    {
	   linked_list_t                  *i     = yyvsp[-3].list;
	   cherokee_handler_table_entry_t *entry = directory_content_tmp.entry;

	   while (i != NULL) {
			 if (strncasecmp(i->string, "basic", 5) == 0) {
				    entry->authentication |= http_auth_basic;
			 } 
			 else if (strncasecmp(i->string, "digest", 6) == 0) {
				    entry->authentication |= http_auth_digest;			 
			 }
			 else {
				    PRINT_ERROR ("ERROR: Unknown authentication type '%s'\n", i->string);
				    return 1;
			 }

			 i = i->next;
	   }

	   free_linked_list (yyvsp[-3].list, free);
}
    break;

  case 139:

    {
	   linked_list_t *i, *prev;
	   CHEROKEE_NEW(n, access);

	   i = yyvsp[0].list;
	   while (i != NULL) {
			 cherokee_access_add (n, i->string);
			 
			 free (i->string);
			 prev = i;
			 i = i->next;
			 free (prev);
	   }
	   directory_content_tmp.entry->access = n;
}
    break;

  case 140:

    {
#ifndef HAVE_TLS
	   PRINT_ERROR_S ("ERROR: Cherokee is compiled without TLS support, so\n"
				   "       it isn't possible to use OnlySecure\n");
#endif

	   directory_content_tmp.entry->only_secure = true;
}
    break;

  case 141:

    {
	   cherokee_buffer_t *realm;
	   realm = directory_content_tmp.entry->auth_realm;

	   cherokee_buffer_add (realm, yyvsp[0].string, strlen(yyvsp[0].string));
	   free (yyvsp[0].string);
}
    break;

  case 142:

    {
	   ret_t ret;
	   cherokee_module_info_t *info;

	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[-1].string);
	   if (ret != ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load validator module '%s'\n", yyvsp[-1].string);
			 return 1;
	   }

	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[-1].string, &info);

	   if (info->type != cherokee_validator) {
			 PRINT_ERROR ("ERROR: %s is not a validator module!!\n", yyvsp[-1].string);
	   }

	   directory_content_tmp.entry->validator_new_func = info->new_func;
}
    break;

  case 147:

    { cherokee_handler_table_entry_set (current_handler_table_entry, "file", yyvsp[0].string); }
    break;

  case 148:

    {
	   int   len;
	   char *tmp;
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   /* Set the users public directory
	    */
	   if (!cherokee_buffer_is_empty (vsrv->userdir)) {
			 PRINT_ERROR ("WARNING: Overwriting userdir '%s'\n", vsrv->userdir->buf);
			 cherokee_buffer_clean (vsrv->userdir);
	   }

	   len = strlen(yyvsp[0].string);
	   tmp = make_finish_with_slash (yyvsp[0].string, &len);
	   cherokee_buffer_add (vsrv->userdir, tmp, len);

	   /* Set the plugin table reference
	    */
	   current_handler_table = vsrv->userdir_plugins;

}
    break;

  case 149:

    {

	   /* Remove the references
	    */
	   current_handler_table = NULL;
}
    break;

  case 150:

    {
	   linked_list_t *i = yyvsp[0].list;

	   while (i != NULL) {
			 cherokee_list_add_tail (&SRV(server)->index_list, i->string);
			 i = i->next;
	   }

	   free_linked_list (yyvsp[0].list, NULL);
}
    break;

  case 153:

    {
	   ret_t                      ret;
	   cherokee_module_info_t    *info;
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   /* Load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Loading module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   ret = cherokee_module_loader_get (SRV(server)->loader, yyvsp[0].string, &info);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Loading module '%s'\n", yyvsp[0].string);
			 return 1;
	   }
	   
	   /* Remove the old (by default) error handler and cretate a new one
	    */
	   vsrv->error_handler = handler_table_entry_new();

	   /* Setup the loaded module
	    */
	   cherokee_handler_table_enty_get_info (vsrv->error_handler, info);
}
    break;


    }

/* Line 1010 of yacc.c.  */


  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
		 yydestruct (yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
	  yydestruct (yytoken, &yylval);
	  yychar = YYEMPTY;

	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}






