# Cherokee tester v0.1
# GPL Licenced


from config import *

class CherokeeTest:
    def __init__ (self):
        self.__verbose__  = DEBUG_LEVEL
        self.__config__   = None
        self.__pid__      = None
        self.__tmp_dirs__ = []

    def __del__ (self):
        from os import unlink, kill
        from time import sleep
        from shutil import rmtree
        from signal import SIGTERM, SIGKILL

        if self.__config__ is not None:
            self.Debug (DEBUG_INTERNAL, "Removing file: ", self.__config__)
            unlink (self.__config__)

        for tmp in self.__tmp_dirs__:
            self.Debug (DEBUG_INTERNAL, "Removing directory: ", tmp)
            rmtree (tmp, True)

        if self.__pid__ is not None:
            self.Debug (DEBUG_INTERNAL, "Sending SIGTERM to ", self.__pid__)
            kill (self.__pid__, SIGTERM)
            sleep(.1)
            self.Debug (DEBUG_INTERNAL, "Sending SIGKILL to ", self.__pid__)
            kill (self.__pid__, SIGKILL)
            
    def AnalizeResult (self):
        """ This method has to make the connection to the server, test
        whatever it want, check and ensure that the result from the
        server is ok.  It has to returns 0 if it was ok, or 1 on
        error"""
        raise "Virtual method"

    def GenerateConfig (self):
        """ This method has to generate a valid Cherokee configuration
        file content, and return it as a single string, or None on
        error"""
        raise "Virtual method"

    def Debug (self, level, *args):
        if self.__verbose__ >= level:
            print reduce (lambda x,y: str(x)+str(y), args)
            
    def __WriteConfig (self):
        from tempfile import mktemp
        try:
            self.__config__ = mktemp(".conf", "cherokee-")
        except:
            self.__config__ = mktemp(".cherokee-conf")
            
        f = open (self.__config__, "w")
        cfg = self.GenerateConfig()
        self.Debug (DEBUG_INTERNAL, "Creating config file: ", self.__config__)
        f.write (cfg)
        f.close()
        
    def __RunServer (self):
        from popen2 import Popen4
        from time import sleep
        command = "%s -C %s" % (CHEROKEE_EXEC, self.__config__)
        self.Debug (DEBUG_INTERNAL, "Executing: ", command)
        child = Popen4 (command)
        self.__pid__ = child.pid
        sleep(.2)

    def MakeTempDir (self):
        from tempfile import mkdtemp
        tmpdir = mkdtemp (".www", "cherokee-")
        self.Debug (DEBUG_INTERNAL, "Creating directory: ", tmpdir)
        self.__tmp_dirs__.append (tmpdir)
        return tmpdir

    def WriteFile (self, dir, filename, content):
        from os.path import join
        fn = join(dir, filename)
        f = open (fn, "w+")
        self.Debug(DEBUG_INTERNAL, "Creating file: %s, %d bytes" % (fn, len(content)))
        f.write (content)
        f.close()

    def Run (self, times=1, verbose=False):
        self.__WriteConfig()
        self.__RunServer()
        for n in range(times):
            ret = self.AnalizeResult()
            if ret != False: return ret
