/* A Bison parser, made by GNU Bison 1.875a.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     T_QUOTE = 258,
     T_DENY = 259,
     T_THREAD_NUM = 260,
     T_SSL_CERT_KEY_FILE = 261,
     T_SSL_CERT_FILE = 262,
     T_KEEPALIVE_MAX_REQUESTS = 263,
     T_ERROR_DOCUMENT = 264,
     T_TIMEOUT = 265,
     T_KEEPALIVE = 266,
     T_DOCUMENT_ROOT = 267,
     T_LOG = 268,
     T_MIME_FILE = 269,
     T_DIRECTORY = 270,
     T_HANDLER = 271,
     T_USER = 272,
     T_GROUP = 273,
     T_POLICY = 274,
     T_SERVER = 275,
     T_USERDIR = 276,
     T_URL = 277,
     T_PIDFILE = 278,
     T_LISTEN = 279,
     T_FILEDIR = 280,
     T_HIDE_VERSION = 281,
     T_HIDE_SERVER_NAME = 282,
     T_ENCODER = 283,
     T_ALLOW = 284,
     T_BGCOLOR = 285,
     T_TEXT = 286,
     T_LINK = 287,
     T_ALINK = 288,
     T_VLINK = 289,
     T_BACKGROUND = 290,
     T_DIRECTORYINDEX = 291,
     T_IPV6 = 292,
     T_SHOW = 293,
     T_CHROOT = 294,
     T_HEADER_FILE = 295,
     T_ICONS = 296,
     T_AUTH = 297,
     T_NAME = 298,
     T_METHOD = 299,
     T_PASSWDFILE = 300,
     T_SSL_CA_LIST_FILE = 301,
     T_FROM = 302,
     T_SOCKET = 303,
     T_LOG_FLUSH_INTERVAL = 304,
     T_INCLUDE = 305,
     T_PANIC_ACTION = 306,
     T_JUST_ABOUT = 307,
     T_LISTEN_QUEUE_SIZE = 308,
     T_SENDFILE = 309,
     T_MINSIZE = 310,
     T_MAXSIZE = 311,
     T_MAX_FDS = 312,
     T_NUMBER = 313,
     T_PORT = 314,
     T_QSTRING = 315,
     T_FULLDIR = 316,
     T_ID = 317,
     T_HTTP_URL = 318,
     T_HOSTNAME = 319,
     T_IP = 320,
     T_DOMAIN_NAME = 321
   };
#endif
#define T_QUOTE 258
#define T_DENY 259
#define T_THREAD_NUM 260
#define T_SSL_CERT_KEY_FILE 261
#define T_SSL_CERT_FILE 262
#define T_KEEPALIVE_MAX_REQUESTS 263
#define T_ERROR_DOCUMENT 264
#define T_TIMEOUT 265
#define T_KEEPALIVE 266
#define T_DOCUMENT_ROOT 267
#define T_LOG 268
#define T_MIME_FILE 269
#define T_DIRECTORY 270
#define T_HANDLER 271
#define T_USER 272
#define T_GROUP 273
#define T_POLICY 274
#define T_SERVER 275
#define T_USERDIR 276
#define T_URL 277
#define T_PIDFILE 278
#define T_LISTEN 279
#define T_FILEDIR 280
#define T_HIDE_VERSION 281
#define T_HIDE_SERVER_NAME 282
#define T_ENCODER 283
#define T_ALLOW 284
#define T_BGCOLOR 285
#define T_TEXT 286
#define T_LINK 287
#define T_ALINK 288
#define T_VLINK 289
#define T_BACKGROUND 290
#define T_DIRECTORYINDEX 291
#define T_IPV6 292
#define T_SHOW 293
#define T_CHROOT 294
#define T_HEADER_FILE 295
#define T_ICONS 296
#define T_AUTH 297
#define T_NAME 298
#define T_METHOD 299
#define T_PASSWDFILE 300
#define T_SSL_CA_LIST_FILE 301
#define T_FROM 302
#define T_SOCKET 303
#define T_LOG_FLUSH_INTERVAL 304
#define T_INCLUDE 305
#define T_PANIC_ACTION 306
#define T_JUST_ABOUT 307
#define T_LISTEN_QUEUE_SIZE 308
#define T_SENDFILE 309
#define T_MINSIZE 310
#define T_MAXSIZE 311
#define T_MAX_FDS 312
#define T_NUMBER 313
#define T_PORT 314
#define T_QSTRING 315
#define T_FULLDIR 316
#define T_ID 317
#define T_HTTP_URL 318
#define T_HOSTNAME 319
#define T_IP 320
#define T_DOMAIN_NAME 321




/* Copy the first part of user declarations.  */
#line 1 "read_config_grammar.y"

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "common.h"

#include <pwd.h>
#include <grp.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <ctype.h>
#include <strings.h>

#include "mime.h"
#include "server.h"
#include "table.h"
#include "virtual_server.h"
#include "handler_table_entry.h"
#include "encoder.h"
#include "logger_table.h"
#include "access.h"
#include "list_ext.h"


/* Define the parameter name of the yyparse() argument
 */
#define YYPARSE_PARAM server



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 56 "read_config_grammar.y"
typedef union YYSTYPE {
	   int   number;
	   char *string;
	   void *ptr;

	   struct {
			 char *name;
			 void *ptr;
	   } name_ptr;

	   void *list;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 275 "read_config_grammar.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 70 "read_config_grammar.y"

/* What is the right way to import this prototipe?
 */
extern int yylex(void);


extern char *yytext;
extern int   yylineno;

static cherokee_virtual_server_t      *current_virtual_server      = NULL;
static cherokee_handler_table_entry_t *current_handler_table_entry = NULL;
static cherokee_encoder_table_entry_t *current_encoder_entry       = NULL;
static cherokee_module_info_t         *current_module_info         = NULL;
static list_t                         *current_list                = NULL;

struct {
	   char                          *handler_name;
	   cherokee_handler_table_entry_t *entry;
	   cherokee_virtual_server_t     *vserver;
	   char                          *document_root;
	   char                          *directory_name;
} directory_content_tmp;

typedef struct {
	   void *next;
	   char *string;
} linked_list_t;


#define auto_virtual_server ((current_virtual_server) ? current_virtual_server : SRV(server)->vserver_default)


static void
free_linked_list (linked_list_t *list, void (*free_func) (void *))
{
	   linked_list_t *i = list;

	   while (i != NULL) {
			 linked_list_t *prev = i;

			 if ((free_func) && (i->string)) {
				    free_func (i->string);
			 }

			 prev = i;
			 i = i->next;
			 free (prev);
	   }	   
}

static char *
make_finish_with_slash (char *string, int *len)
{
	   char *new;
	   int   new_len;

	   if (string[(*len)-1] == '/') {
			 return string;
	   }

	   new_len = (*len) + 2;
	   new  = (char*) malloc (new_len);

	   *len = snprintf (new, new_len, "%s/", string);

	   free (string);
	   return new;
}

static char *
make_slash_end (char *string)
{
	   int len = strlen(string);
	   return make_finish_with_slash (string, &len);
}

cherokee_handler_table_entry_t *
handler_table_entry_new (void)
{
	   cherokee_handler_table_entry_t *entry;

	   cherokee_handler_table_entry_new (&entry);
	   current_handler_table_entry = entry;

	   return entry;
}


char *
new_string_to_lowercase (const char *in)
{
	   int   i;
	   char *tmp;
	   
	   i = strlen(in);
	   tmp = (char *) malloc (i+1);
	   tmp[i] = '\0';

	   while (i--) {
			 tmp[i] = tolower(in[i]);
	   }

	   return tmp;
}


void
yyerror(char* msg)
{
        PRINT_ERROR ("Error parsing configuration: '%s', line %d, symbol '%s'\n", 
				 msg, yylineno, yytext);
}



/* Line 214 of yacc.c.  */
#line 401 "read_config_grammar.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  111
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   166

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  70
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  70
/* YYNRULES -- Number of rules. */
#define YYNRULES  142
/* YYNRULES -- Number of states. */
#define YYNSTATES  219

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   321

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    67,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    68,     2,    69,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     4,     6,     8,    11,    13,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    89,    92,    93,    96,    97,
     100,   101,   104,   105,   108,   109,   112,   114,   118,   120,
     124,   126,   130,   133,   136,   139,   142,   143,   148,   149,
     153,   154,   157,   160,   163,   166,   169,   172,   175,   178,
     181,   184,   187,   190,   191,   196,   200,   201,   204,   207,
     210,   213,   216,   219,   224,   227,   230,   233,   236,   240,
     244,   245,   248,   251,   254,   257,   260,   263,   269,   272,
     275,   278,   281,   284,   287,   290,   293,   296,   299,   302,
     304,   307,   309,   311,   313,   314,   321,   322,   329,   331,
     334,   340,   344,   347,   351,   355,   356,   357,   360,   363,
     369,   372,   376
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
      71,     0,    -1,    -1,    72,    -1,    74,    -1,    72,    74,
      -1,    76,    -1,    73,    76,    -1,    76,    -1,    75,    -1,
     128,    -1,    86,    -1,    87,    -1,    95,    -1,    96,    -1,
      97,    -1,    98,    -1,    99,    -1,   100,    -1,   101,    -1,
     109,    -1,   121,    -1,   122,    -1,   123,    -1,   124,    -1,
     137,    -1,   116,    -1,   117,    -1,   120,    -1,   138,    -1,
     139,    -1,    88,    -1,   110,    -1,   111,    -1,   112,    -1,
     113,    -1,   115,    -1,   130,    -1,    89,    -1,    90,    -1,
     105,    -1,   102,    -1,   103,    -1,   104,    -1,    -1,    77,
     132,    -1,    -1,    78,   114,    -1,    -1,    79,   126,    -1,
      -1,    80,   108,    -1,    -1,    81,   119,    -1,    -1,    82,
     133,    -1,    62,    -1,    62,    67,    83,    -1,   127,    -1,
     127,    67,    84,    -1,    65,    -1,    65,    67,    85,    -1,
      59,    58,    -1,    24,   127,    -1,    49,    58,    -1,    12,
      61,    -1,    -1,    13,    62,    91,    92,    -1,    -1,    68,
      93,    69,    -1,    -1,    93,    94,    -1,    62,    61,    -1,
      26,    58,    -1,    27,    58,    -1,    14,    61,    -1,    41,
      61,    -1,    10,    58,    -1,    11,    58,    -1,     8,    58,
      -1,     7,    61,    -1,     6,    61,    -1,    46,    61,    -1,
      -1,    28,    62,   106,   107,    -1,    68,    80,    69,    -1,
      -1,    29,    83,    -1,     4,    83,    -1,    23,    61,    -1,
      50,    61,    -1,    51,    61,    -1,    53,    58,    -1,    54,
      68,    78,    69,    -1,    55,    58,    -1,    56,    58,    -1,
      57,    58,    -1,    39,    61,    -1,     5,    58,   118,    -1,
      68,    81,    69,    -1,    -1,    19,    62,    -1,    37,    58,
      -1,    17,    62,    -1,    17,    58,    -1,    18,    62,    -1,
      18,    58,    -1,    16,    62,    68,    79,    69,    -1,    16,
      62,    -1,    22,    63,    -1,    22,    61,    -1,    25,    61,
      -1,    30,    62,    -1,    31,    62,    -1,    32,    62,    -1,
      34,    62,    -1,    33,    62,    -1,    40,    62,    -1,    48,
      61,    -1,    52,    -1,    38,    83,    -1,    62,    -1,    65,
      -1,    66,    -1,    -1,    20,    84,    68,   129,    73,    69,
      -1,    -1,    15,    61,    68,   131,    77,    69,    -1,   125,
      -1,    12,    61,    -1,    42,    83,    68,    82,    69,    -1,
      29,    47,    85,    -1,    43,    60,    -1,    44,    62,   134,
      -1,    68,   135,    69,    -1,    -1,    -1,   135,   136,    -1,
      45,    61,    -1,    21,    62,    68,   125,    69,    -1,    36,
      83,    -1,     9,    58,    61,    -1,     9,    58,    63,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   203,   203,   204,   207,   208,   211,   212,   215,   216,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   248,   249,   250,
     251,   252,   253,   254,   257,   258,   260,   261,   263,   264,
     266,   267,   269,   270,   272,   273,   278,   287,   300,   309,
     322,   331,   340,   345,   350,   355,   370,   369,   395,   396,
     398,   399,   402,   415,   420,   425,   430,   435,   443,   448,
     453,   470,   487,   506,   505,   536,   537,   539,   560,   581,
     600,   605,   615,   620,   622,   627,   632,   637,   643,   650,
     651,   653,   669,   674,   689,   694,   709,   714,   720,   727,
     732,   737,   742,   745,   748,   751,   754,   757,   760,   763,
     767,   796,   797,   798,   804,   803,   838,   837,   910,   916,
     929,   953,   971,   980,  1001,  1002,  1005,  1006,  1009,  1014,
    1045,  1057,  1069
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "T_QUOTE", "T_DENY", "T_THREAD_NUM", 
  "T_SSL_CERT_KEY_FILE", "T_SSL_CERT_FILE", "T_KEEPALIVE_MAX_REQUESTS", 
  "T_ERROR_DOCUMENT", "T_TIMEOUT", "T_KEEPALIVE", "T_DOCUMENT_ROOT", 
  "T_LOG", "T_MIME_FILE", "T_DIRECTORY", "T_HANDLER", "T_USER", "T_GROUP", 
  "T_POLICY", "T_SERVER", "T_USERDIR", "T_URL", "T_PIDFILE", "T_LISTEN", 
  "T_FILEDIR", "T_HIDE_VERSION", "T_HIDE_SERVER_NAME", "T_ENCODER", 
  "T_ALLOW", "T_BGCOLOR", "T_TEXT", "T_LINK", "T_ALINK", "T_VLINK", 
  "T_BACKGROUND", "T_DIRECTORYINDEX", "T_IPV6", "T_SHOW", "T_CHROOT", 
  "T_HEADER_FILE", "T_ICONS", "T_AUTH", "T_NAME", "T_METHOD", 
  "T_PASSWDFILE", "T_SSL_CA_LIST_FILE", "T_FROM", "T_SOCKET", 
  "T_LOG_FLUSH_INTERVAL", "T_INCLUDE", "T_PANIC_ACTION", "T_JUST_ABOUT", 
  "T_LISTEN_QUEUE_SIZE", "T_SENDFILE", "T_MINSIZE", "T_MAXSIZE", 
  "T_MAX_FDS", "T_NUMBER", "T_PORT", "T_QSTRING", "T_FULLDIR", "T_ID", 
  "T_HTTP_URL", "T_HOSTNAME", "T_IP", "T_DOMAIN_NAME", "','", "'{'", 
  "'}'", "$accept", "conffile", "lines", "server_lines", "line", 
  "common_line", "server_line", "directory_options", "sendfile_options", 
  "handler_options", "encoder_options", "thread_options", "auth_options", 
  "id_list", "domain_list", "ip_list", "port", "listen", 
  "log_flush_interval", "document_root", "log", "@1", "log_optional", 
  "tuple_list", "tuple", "hideversion", "hideservername", "mime", "icons", 
  "timeout", "keepalive", "keepalive_max_requests", "ssl_file", 
  "ssl_key_file", "ssl_ca_list_file", "encoder", "@2", 
  "maybe_encoder_options", "encoder_option", "pidfile", "include", 
  "panic_action", "listen_queue_size", "sendfile", "sendfile_option", 
  "maxfds", "chroot", "thread_number", "maybe_thread_options", 
  "thread_option", "ipv6", "user1", "user2", "group1", "group2", 
  "handler", "handler_option", "host_name", "server", "@3", "directory", 
  "@4", "directory_option", "auth_option", "maybe_auth_option_params", 
  "auth_option_params", "auth_option_param", "userdir", "directoryindex", 
  "errordocument", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,    44,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    70,    71,    71,    72,    72,    73,    73,    74,    74,
      75,    75,    75,    75,    75,    75,    75,    75,    75,    75,
      75,    75,    75,    75,    75,    75,    75,    75,    75,    75,
      75,    75,    75,    75,    75,    75,    75,    76,    76,    76,
      76,    76,    76,    76,    77,    77,    78,    78,    79,    79,
      80,    80,    81,    81,    82,    82,    83,    83,    84,    84,
      85,    85,    86,    87,    88,    89,    91,    90,    92,    92,
      93,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   106,   105,   107,   107,   108,   108,   109,
     110,   111,   112,   113,   114,   114,   115,   116,   117,   118,
     118,   119,   120,   121,   122,   123,   124,   125,   125,   126,
     126,   126,   126,   126,   126,   126,   126,   126,   126,   126,
     126,   127,   127,   127,   129,   128,   131,   130,   132,   132,
     132,   132,   133,   133,   134,   134,   135,   135,   136,   137,
     138,   139,   139
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     1,     1,     2,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     0,     2,     0,     2,
       0,     2,     0,     2,     0,     2,     1,     3,     1,     3,
       1,     3,     2,     2,     2,     2,     0,     4,     0,     3,
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     0,     4,     3,     0,     2,     2,     2,
       2,     2,     2,     4,     2,     2,     2,     2,     3,     3,
       0,     2,     2,     2,     2,     2,     2,     5,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     1,
       2,     1,     1,     1,     0,     6,     0,     6,     1,     2,
       5,     3,     2,     3,     3,     0,     0,     2,     2,     5,
       2,     3,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     3,     4,     9,     8,    11,    12,
      31,    38,    39,    13,    14,    15,    16,    17,    18,    19,
      41,    42,    43,    40,    20,    32,    33,    34,    35,    36,
      26,    27,    28,    21,    22,    23,    24,    10,    37,    25,
      29,    30,   100,    81,    80,    79,     0,    77,    78,    65,
      66,    75,     0,   104,   103,   106,   105,   121,   122,   123,
       0,    58,     0,    89,    63,    73,    74,    83,    56,   140,
     102,    97,    76,    82,    64,    90,    91,    92,    46,    96,
      62,     1,     5,    52,    98,   141,   142,    68,   126,   124,
       0,     0,    86,     0,     0,     0,    70,    67,    44,     0,
      59,     0,     0,    50,    84,    57,     0,     0,    93,    47,
       0,    99,    53,     0,     0,     0,     6,   108,   139,     0,
      94,    95,   101,     0,    69,    71,     0,     0,     0,   127,
     128,    45,   125,     7,    48,     0,     0,    85,    51,    72,
     129,     0,     0,     0,    88,    87,    60,   131,    54,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   119,
     107,    49,     0,     0,   110,   109,   111,   112,   113,   114,
     116,   115,   120,   117,   118,    61,     0,     0,   130,    55,
     132,   135,   136,   133,     0,     0,   134,   137,   138
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,    33,    34,   145,    35,    36,    37,   144,   124,   173,
     149,   125,   193,    99,    90,   177,    38,    39,    40,    41,
      42,   117,   127,   143,   155,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,   122,   134,   168,    54,
      55,    56,    57,    58,   139,    59,    60,    61,   114,   142,
      62,    63,    64,    65,    66,   132,   191,    91,    67,   129,
      68,   128,   161,   209,   213,   214,   217,    69,    70,    71
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -121
static const yysigned_char yypact[] =
{
      62,   -42,   -37,   -32,   -24,   -21,   -16,    -2,    -3,   -43,
      -1,     0,   -26,    -9,   -18,   -19,     2,   -18,     1,    20,
      19,    22,    29,    30,    31,    32,    36,    34,    35,    39,
      37,    42,    44,   104,    62,  -121,  -121,  -121,  -121,  -121,
    -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,
    -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,
    -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,
    -121,  -121,    38,  -121,  -121,  -121,   -11,  -121,  -121,  -121,
    -121,  -121,    41,  -121,  -121,  -121,  -121,  -121,  -121,  -121,
      50,    40,    52,  -121,  -121,  -121,  -121,  -121,    43,  -121,
    -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,
    -121,  -121,  -121,  -121,  -121,  -121,  -121,    59,  -121,  -121,
     -18,   112,    61,    22,   -29,   -15,  -121,  -121,  -121,     5,
    -121,    69,    64,  -121,  -121,  -121,    76,    77,  -121,  -121,
      74,  -121,  -121,   -41,    -7,    -5,  -121,    70,  -121,    -4,
    -121,  -121,  -121,    78,  -121,  -121,    80,    90,    22,  -121,
    -121,  -121,  -121,  -121,  -121,    22,    22,  -121,  -121,  -121,
    -121,    81,    75,    92,  -121,  -121,    82,  -121,  -121,    -6,
      84,    85,    86,    88,    89,    91,    22,    93,    95,  -121,
    -121,  -121,    81,   -30,  -121,  -121,  -121,  -121,  -121,  -121,
    -121,  -121,  -121,  -121,  -121,  -121,    94,    96,  -121,  -121,
    -121,    97,  -121,  -121,   -39,    98,  -121,  -121,  -121
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -121,  -121,  -121,  -121,   108,  -121,  -114,  -121,  -121,  -121,
    -121,  -121,  -121,  -120,    46,   -40,  -121,  -121,  -121,  -121,
    -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,
    -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,
    -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,
    -121,  -121,  -121,  -121,  -121,    13,  -121,   143,  -121,  -121,
    -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121,  -121
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
     165,     2,     3,   135,   140,   156,   215,     8,     9,   131,
      11,     2,     3,   206,   207,   146,    72,     8,     9,    80,
      11,   153,   157,    20,    73,   166,   136,   137,   154,    74,
     216,   163,    83,    20,    75,   158,    84,    76,   172,   208,
     138,    25,    77,    92,    87,   174,   175,    88,    89,    85,
     115,    25,   116,    86,   141,   194,    78,   195,    79,    95,
      81,    82,   159,    93,   162,   167,   202,     1,     2,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    96,    12,
      13,    97,    14,    15,    98,    16,    17,   100,    18,    19,
      20,   101,   102,   103,   104,   105,   106,   107,    21,    22,
     109,    23,   110,    24,   111,   108,   113,   120,    25,   118,
     123,    26,    27,    28,   179,    29,    30,   180,   119,    31,
     121,    32,   181,   182,   183,   184,   185,   126,   131,   133,
     186,   147,   187,   148,   150,   151,   152,   171,   164,   169,
     188,   170,   112,   178,   189,   196,   176,   197,   198,   192,
     199,   200,   205,   201,   210,   203,   204,   160,   211,   218,
      94,   190,     0,     0,     0,   212,   130
};

static const short yycheck[] =
{
       4,     6,     7,   123,    19,    12,    45,    12,    13,    16,
      15,     6,     7,    43,    44,   129,    58,    12,    13,    62,
      15,    62,    29,    28,    61,    29,    55,    56,    69,    61,
      69,   145,    58,    28,    58,    42,    62,    58,   158,    69,
      69,    46,    58,    62,    62,   165,   166,    65,    66,    58,
      61,    46,    63,    62,    69,    61,    58,    63,    61,    58,
      61,    61,    69,    61,    69,    69,   186,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    58,    17,
      18,    62,    20,    21,    62,    23,    24,    58,    26,    27,
      28,    61,    61,    61,    58,    61,    61,    58,    36,    37,
      58,    39,    58,    41,     0,    68,    68,    67,    46,    68,
      67,    49,    50,    51,    22,    53,    54,    25,    68,    57,
      68,    59,    30,    31,    32,    33,    34,    68,    16,    68,
      38,    62,    40,    69,    58,    58,    62,    47,    68,    61,
      48,    61,    34,    68,    52,    61,    65,    62,    62,    67,
      62,    62,   192,    62,    60,    62,    61,   144,    62,    61,
      17,    69,    -1,    -1,    -1,    68,   120
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    17,    18,    20,    21,    23,    24,    26,    27,
      28,    36,    37,    39,    41,    46,    49,    50,    51,    53,
      54,    57,    59,    71,    72,    74,    75,    76,    86,    87,
      88,    89,    90,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   109,   110,   111,   112,   113,   115,
     116,   117,   120,   121,   122,   123,   124,   128,   130,   137,
     138,   139,    58,    61,    61,    58,    58,    58,    58,    61,
      62,    61,    61,    58,    62,    58,    62,    62,    65,    66,
      84,   127,    62,    61,   127,    58,    58,    62,    62,    83,
      58,    61,    61,    61,    58,    61,    61,    58,    68,    58,
      58,     0,    74,    68,   118,    61,    63,    91,    68,    68,
      67,    68,   106,    67,    78,    81,    68,    92,   131,   129,
      84,    16,   125,    68,   107,    83,    55,    56,    69,   114,
      19,    69,   119,    93,    77,    73,    76,    62,    69,    80,
      58,    58,    62,    62,    69,    94,    12,    29,    42,    69,
     125,   132,    69,    76,    68,     4,    29,    69,   108,    61,
      61,    47,    83,    79,    83,    83,    65,    85,    68,    22,
      25,    30,    31,    32,    33,    34,    38,    40,    48,    52,
      69,   126,    67,    82,    61,    63,    61,    62,    62,    62,
      62,    62,    83,    62,    61,    85,    43,    44,    69,   133,
      60,    62,    68,   134,   135,    45,    69,   136,    61
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 56:
#line 279 "read_config_grammar.y"
    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;
	   
	   yyval.list = n;
}
    break;

  case 57:
#line 288 "read_config_grammar.y"
    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));

	   n->next = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 58:
#line 301 "read_config_grammar.y"
    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));
	   n->next = NULL;
	   n->string = yyvsp[0].string;
	   
	   yyval.list = n;
}
    break;

  case 59:
#line 310 "read_config_grammar.y"
    {
	   linked_list_t *n = (linked_list_t *) malloc(sizeof(linked_list_t));

	   n->next = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 60:
#line 323 "read_config_grammar.y"
    {
	   linked_list_t *n = (linked_list_t *) malloc (sizeof(linked_list_t));
	   n->next   = NULL;
	   n->string = yyvsp[0].string;

	   yyval.list = n;
}
    break;

  case 61:
#line 332 "read_config_grammar.y"
    {
	   linked_list_t *n = (linked_list_t *) malloc (sizeof(linked_list_t));
	   n->next   = yyvsp[0].list;
	   n->string = yyvsp[-2].string;

	   yyval.list = n;
}
    break;

  case 62:
#line 341 "read_config_grammar.y"
    {
	   SRV(server)->port = yyvsp[0].number;
}
    break;

  case 63:
#line 346 "read_config_grammar.y"
    {
	   SRV(server)->listen_to = yyvsp[0].string;
}
    break;

  case 64:
#line 351 "read_config_grammar.y"
    {
	   SRV(server)->log_flush_elapse = yyvsp[0].number;
}
    break;

  case 65:
#line 356 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vserver;

	   vserver = auto_virtual_server;
	   vserver->root = yyvsp[0].string;
	   vserver->root_len = strlen (yyvsp[0].string);

	   /* Check for the endding slash
	    */
	   vserver->root = make_finish_with_slash (vserver->root, &(vserver->root_len));
}
    break;

  case 66:
#line 370 "read_config_grammar.y"
    {
	   ret_t ret;

	   /* Maybe load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load logger module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   cherokee_module_loader_get (SRV(server)->loader, yyvsp[0].string, &current_module_info);
}
    break;

  case 67:
#line 384 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   /* Instance the logger object
	    */
	   cherokee_logger_table_new_logger (SRV(server)->loggers, yyvsp[-2].string, current_module_info,
								  vserver->logger_props, &vserver->logger);
	   current_module_info = NULL;
}
    break;

  case 72:
#line 403 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vserver;
	   vserver = auto_virtual_server;

	   if (vserver->logger_props == NULL) {
			 cherokee_table_new (&vserver->logger_props);
	   }

	   cherokee_table_add (vserver->logger_props, yyvsp[-1].string, yyvsp[0].string);
}
    break;

  case 73:
#line 416 "read_config_grammar.y"
    {
	   SRV(server)->hideversion = yyvsp[0].number;
}
    break;

  case 74:
#line 421 "read_config_grammar.y"
    {
	   SRV(server)->hideservername = yyvsp[0].number;
}
    break;

  case 75:
#line 426 "read_config_grammar.y"
    {
	   SRV(server)->mime_file = yyvsp[0].string;
}
    break;

  case 76:
#line 431 "read_config_grammar.y"
    {
	   SRV(server)->icons_file = yyvsp[0].string;
}
    break;

  case 77:
#line 436 "read_config_grammar.y"
    {
	   SRV(server)->timeout = yyvsp[0].number;

	   cherokee_buffer_clean  (SRV(server)->timeout_header);
	   cherokee_buffer_add_va (SRV(server)->timeout_header, "Keep-Alive: timeout=%d"CRLF, yyvsp[0].number);
}
    break;

  case 78:
#line 444 "read_config_grammar.y"
    {
	   SRV(server)->keepalive = (yyvsp[0].number == 0) ? false : true;
}
    break;

  case 79:
#line 449 "read_config_grammar.y"
    {
	   SRV(server)->keepalive_max = yyvsp[0].number;
}
    break;

  case 80:
#line 454 "read_config_grammar.y"
    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_cert != NULL) {
			 PRINT_ERROR ("\"SSLCertificateFile\" overlap: '%s' <- '%s'\n", vsrv->server_cert, yyvsp[0].string);
			 free (vsrv->server_cert);
	   }

	   vsrv->server_cert = yyvsp[0].string;

#else
	   PRINT_ERROR ("Ignoring SSL configuration entry: \"SSLCertificateFile\"\n");
#endif
}
    break;

  case 81:
#line 471 "read_config_grammar.y"
    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->server_key != NULL) {
			 PRINT_ERROR ("\"SSLCertificateKeyFile\" overlap: '%s' <- '%s'\n", vsrv->server_key, yyvsp[0].string);
			 free (vsrv->server_key);
	   }

	   vsrv->server_key = yyvsp[0].string;

#else
	   PRINT_ERROR ("Ignoring SSL configuration entry: \"SSLCertificateKeyFile\"\n");
#endif
}
    break;

  case 82:
#line 488 "read_config_grammar.y"
    {
#ifdef HAVE_TLS
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;

	   if (vsrv->ca_cert != NULL) {
			 PRINT_ERROR ("\"SSLCAListFile\" overlap: '%s' <- '%s'\n", vsrv->ca_cert, yyvsp[0].string);
			 free (vsrv->ca_cert);
	   }

	   vsrv->ca_cert = yyvsp[0].string;

#else
	   PRINT_ERROR ("Ignoring SSL configuration entry: \"SSLCAListFile\"\n");
#endif
}
    break;

  case 83:
#line 506 "read_config_grammar.y"
    {
	   ret_t ret;
	   cherokee_module_info_t *info;
	   cherokee_encoder_table_entry_t *enc;

	   /* Load the module
	    */
	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[0].string);
	   if (ret < ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load encoder module '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[0].string, &info);

	   /* Set the info in the new entry
	    */
	   cherokee_encoder_table_entry_new (&enc);
	   cherokee_encoder_table_entry_get_info (enc, info);

	   /* Set in the encoders table
	    */
	   cherokee_encoder_table_set (SRV(server)->encoders, yyvsp[0].string, enc);
	   current_encoder_entry = enc;
}
    break;

  case 84:
#line 532 "read_config_grammar.y"
    {
	   current_encoder_entry = NULL;
}
    break;

  case 87:
#line 540 "read_config_grammar.y"
    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = yyvsp[0].list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_allow (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 88:
#line 561 "read_config_grammar.y"
    {
	   linked_list_t *i;
	   cherokee_matching_list_t *matching;

	   cherokee_matching_list_new (&matching);
	   cherokee_encoder_entry_set_matching_list (current_encoder_entry, matching);

	   i = yyvsp[0].list;
	   while (i!=NULL) {
			 linked_list_t *prev;

			 cherokee_matching_list_add_deny (matching, i->string);

			 free(i->string);
			 prev = i;
			 i = i->next;
			 free(prev);
	   }
}
    break;

  case 89:
#line 582 "read_config_grammar.y"
    {
	   FILE *file;
	   CHEROKEE_TEMP(buffer, 10);

	   file = fopen (yyvsp[0].string, "w");
	   if (file == NULL) {
			 PRINT_ERROR ("Can't write PID file '%s'\n", yyvsp[0].string);
			 return 1;
	   }

	   snprintf (buffer, buffer_size, "%d\n", getpid());
	   fwrite (buffer, 1, strlen(buffer), file);
	   fclose (file);

	   free (yyvsp[0].string);
}
    break;

  case 90:
#line 601 "read_config_grammar.y"
    {
	   cherokee_list_add_tail (&SRV(server)->include_list, yyvsp[0].string);
}
    break;

  case 91:
#line 606 "read_config_grammar.y"
    {
	   if (SRV(server)->panic_action != NULL) {
			 PRINT_ERROR ("Warning: Overwriting panic action '%s' by '%s'\n", SRV(server)->panic_action, yyvsp[0].string);
			 free (SRV(server)->panic_action);
	   }

	   SRV(server)->panic_action = yyvsp[0].string;
}
    break;

  case 92:
#line 616 "read_config_grammar.y"
    {
	   SRV(server)->listen_queue = yyvsp[0].number;
}
    break;

  case 94:
#line 623 "read_config_grammar.y"
    {
	   SRV(server)->sendfile.min = yyvsp[0].number;
}
    break;

  case 95:
#line 628 "read_config_grammar.y"
    {
	   SRV(server)->sendfile.max = yyvsp[0].number;
}
    break;

  case 96:
#line 633 "read_config_grammar.y"
    {
	   SRV(server)->maxfds = yyvsp[0].number;
}
    break;

  case 97:
#line 638 "read_config_grammar.y"
    {
	   SRV(server)->chroot = yyvsp[0].string;
}
    break;

  case 98:
#line 644 "read_config_grammar.y"
    {
#ifdef HAVE_PTHREAD
	   SRV(server)->ncpus = yyvsp[-1].number;
#endif
}
    break;

  case 101:
#line 654 "read_config_grammar.y"
    {
#ifdef HAVE_PTHREAD
	   if (strcasecmp(yyvsp[0].string, "fifo") == 0) {
			 SRV(server)->thread_policy = SCHED_FIFO;
	   } else if (strcasecmp(yyvsp[0].string, "rr") == 0) {
			 SRV(server)->thread_policy = SCHED_RR;
	   } else if (strcasecmp(yyvsp[0].string, "other") == 0) {
			 SRV(server)->thread_policy = SCHED_OTHER;
	   } else {
			 PRINT_ERROR ("Error: unknown scheduling policy '%s'\n", yyvsp[0].string);
	   }
#endif
}
    break;

  case 102:
#line 670 "read_config_grammar.y"
    {
	   SRV(server)->ipv6 = yyvsp[0].number;
}
    break;

  case 103:
#line 675 "read_config_grammar.y"
    {
	   struct passwd *pwd;
	   
	   pwd = (struct passwd *) getpwnam (yyvsp[0].string);
	   if (pwd == NULL) {
			 PRINT_ERROR ("User '%s' not found in the system", yyvsp[0].string);
			 return 1;
	   }

	   SRV(server)->user = pwd->pw_uid;

	   free (yyvsp[0].string);
}
    break;

  case 104:
#line 690 "read_config_grammar.y"
    {
	   SRV(server)->user = yyvsp[0].number;
}
    break;

  case 105:
#line 695 "read_config_grammar.y"
    {
	   struct group *grp;

	   grp = (struct group *) getgrnam (yyvsp[0].string);
	   if (grp == NULL) {
			 PRINT_ERROR ("Group '%s' not found in the system", yyvsp[0].string);
			 return 1;
	   }

	   SRV(server)->group = grp->gr_gid;

	   free (yyvsp[0].string);
}
    break;

  case 106:
#line 710 "read_config_grammar.y"
    {
	   SRV(server)->group = yyvsp[0].number;
}
    break;

  case 107:
#line 715 "read_config_grammar.y"
    {
	   yyval.name_ptr.name = yyvsp[-3].string;
	   yyval.name_ptr.ptr = current_handler_table_entry;
}
    break;

  case 108:
#line 721 "read_config_grammar.y"
    {
	   yyval.name_ptr.name = yyvsp[0].string;
	   yyval.name_ptr.ptr = current_handler_table_entry;
}
    break;

  case 109:
#line 728 "read_config_grammar.y"
    {
	   cherokee_handler_table_entry_set (current_handler_table_entry, "url", yyvsp[0].string);
}
    break;

  case 110:
#line 733 "read_config_grammar.y"
    {
	   cherokee_handler_table_entry_set (current_handler_table_entry, "url", yyvsp[0].string);
}
    break;

  case 111:
#line 738 "read_config_grammar.y"
    {
	   cherokee_handler_table_entry_set (current_handler_table_entry, "filedir", yyvsp[0].string);
}
    break;

  case 112:
#line 743 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "bgcolor", yyvsp[0].string); }
    break;

  case 113:
#line 746 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "text", yyvsp[0].string); }
    break;

  case 114:
#line 749 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "link", yyvsp[0].string); }
    break;

  case 115:
#line 752 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "vlink", yyvsp[0].string); }
    break;

  case 116:
#line 755 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "alink", yyvsp[0].string); }
    break;

  case 117:
#line 758 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "headerfile", yyvsp[0].string); }
    break;

  case 118:
#line 761 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "socket", yyvsp[0].string); }
    break;

  case 119:
#line 764 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "about", NULL); }
    break;

  case 120:
#line 768 "read_config_grammar.y"
    {
	   linked_list_t *i;

	   i = yyvsp[0].list;
	   while (i != NULL) {
			 if ((!strncasecmp (i->string, "date",  4)) ||
				(!strncasecmp (i->string, "size",  4)) ||
				(!strncasecmp (i->string, "group", 5)) ||
				(!strncasecmp (i->string, "owner", 5)))
			 {
				    char *lower;

				    lower = new_string_to_lowercase (i->string);
				    free (i->string);
				    i->string = lower;

				    cherokee_handler_table_entry_set (current_handler_table_entry, i->string, i->string);				    
			 } else {
				    PRINT_ERROR ("Unknown parameter '%s' for \"Show\"", i->string);
			 }
				
			 i = i->next;
	   }

	   free_linked_list (yyvsp[0].list, free);
}
    break;

  case 123:
#line 799 "read_config_grammar.y"
    {
	   yyval.string = yyvsp[0].string;
}
    break;

  case 124:
#line 804 "read_config_grammar.y"
    {
	   linked_list_t *i = yyvsp[-1].list;
	   CHEROKEE_NEW(vsrv, virtual_server);
	   current_virtual_server = vsrv;

	   /* Add the virtual server to the list
	    */
	   list_add ((list_t *)vsrv, &SRV(server)->vservers);

	   /* Add default virtual server name
	    */
	   if (i->string != NULL) {
			 cherokee_buffer_t *name = current_virtual_server->name;

			 if (cherokee_buffer_is_empty (name)) {
				    cherokee_buffer_add_va (name, "%s", i->string);
			 }
	   }

	   /* Add all the alias to the table
	    */
	   while (i != NULL) {
			 cherokee_table_add (SRV(server)->vservers_ref, i->string, vsrv);
			 i = i->next;
	   }
	   free_linked_list (yyvsp[-1].list, NULL);

}
    break;

  case 125:
#line 831 "read_config_grammar.y"
    {

	   current_virtual_server = NULL;
}
    break;

  case 126:
#line 838 "read_config_grammar.y"
    {
	   /* Fill the tmp struct
	    */
	   directory_content_tmp.directory_name = yyvsp[-1].string;
	   directory_content_tmp.vserver        = auto_virtual_server;
	   directory_content_tmp.entry          = handler_table_entry_new ();       /* new! */
	   directory_content_tmp.handler_name   = NULL;
	   directory_content_tmp.document_root  = NULL;
}
    break;

  case 127:
#line 848 "read_config_grammar.y"
    {
	   /* Basic checks
	    */
	   if (directory_content_tmp.handler_name == NULL) {
			 PRINT_ERROR ("Directory %s needs a handler; this directory entry is ignored.\n", directory_content_tmp.directory_name);
			 goto out;
	   }

	   /* Set the document_root in the entry
	    */
	   if (directory_content_tmp.document_root != NULL) {
			 cherokee_buffer_make_empty(directory_content_tmp.entry->document_root);
			 cherokee_buffer_add_va (directory_content_tmp.entry->document_root, "%s",
								directory_content_tmp.document_root);
	   }

	   /* Load the module 
	    */
	   {
			 ret_t ret;
			 cherokee_module_info_t *info;

			 ret = cherokee_module_loader_load (SRV(server)->loader, directory_content_tmp.handler_name);
			 if (ret < ret_ok) {
				    PRINT_ERROR ("Error loading module '%s'\n", directory_content_tmp.handler_name);
				    return 1;
			 }

			 ret = cherokee_module_loader_get  (SRV(server)->loader, directory_content_tmp.handler_name, &info);
			 if (ret < ret_ok) {
				    PRINT_ERROR ("Error loading module '%s'\n", directory_content_tmp.handler_name);
				    return 1;
			 }

			 cherokee_handler_table_enty_get_info (directory_content_tmp.entry, info);
			 cherokee_handler_table_add (directory_content_tmp.vserver->plugins,
								    directory_content_tmp.handler_name, 
								    directory_content_tmp.entry);
	   }

	   /* Add to the virtual server "web_dir -> entry" table
	    */
 	   cherokee_virtual_server_set (directory_content_tmp.vserver, 
							  directory_content_tmp.directory_name, 
							  directory_content_tmp.handler_name,
							  directory_content_tmp.entry);

	   /* Clean
	    */
out:
	   if (directory_content_tmp.document_root != NULL) {
			 free (directory_content_tmp.document_root);
			 directory_content_tmp.document_root = NULL;
	   }
	   directory_content_tmp.vserver       = NULL;
	   directory_content_tmp.entry         = NULL;
	   directory_content_tmp.handler_name  = NULL;

	   current_handler_table_entry = NULL;
}
    break;

  case 128:
#line 911 "read_config_grammar.y"
    {	   
	   directory_content_tmp.handler_name = yyvsp[0].name_ptr.name;
}
    break;

  case 129:
#line 917 "read_config_grammar.y"
    {
	   if (directory_content_tmp.document_root != NULL) {
			 PRINT_ERROR ("Warning: Overwriting DocumentRoot '%s' by '%s'\n",
					    directory_content_tmp.document_root, yyvsp[0].string);

			 free (directory_content_tmp.document_root);
	   }

	   directory_content_tmp.document_root = make_slash_end (yyvsp[0].string);
}
    break;

  case 130:
#line 930 "read_config_grammar.y"
    {
	   linked_list_t                  *i     = yyvsp[-3].list;
	   cherokee_handler_table_entry_t *entry = directory_content_tmp.entry;

	   while (i != NULL) {
			 if (strncasecmp(i->string, "basic", 5) == 0) {
				    entry->authentication |= http_auth_basic;
			 } 
			 else if (strncasecmp(i->string, "digest", 6) == 0) {
				    entry->authentication |= http_auth_digest;			 
			 }
			 else {
				    PRINT_ERROR ("ERROR: Unknown authentication type '%s'\n", i->string);
				    return 1;
			 }

			 i = i->next;
	   }

	   free_linked_list (yyvsp[-3].list, free);
}
    break;

  case 131:
#line 954 "read_config_grammar.y"
    {
	   linked_list_t *i, *prev;
	   CHEROKEE_NEW(n, access);

	   i = yyvsp[0].list;
	   while (i != NULL) {
			 cherokee_access_add (n, i->string);
			 
			 free (i->string);
			 prev = i;
			 i = i->next;
			 free (prev);
	   }
	   directory_content_tmp.entry->access = n;
}
    break;

  case 132:
#line 972 "read_config_grammar.y"
    {
	   cherokee_buffer_t *realm;
	   realm = directory_content_tmp.entry->auth_realm;

	   cherokee_buffer_add (realm, yyvsp[0].string, strlen(yyvsp[0].string));
	   free (yyvsp[0].string);
}
    break;

  case 133:
#line 981 "read_config_grammar.y"
    {
	   ret_t ret;
	   cherokee_module_info_t *info;

	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[-1].string);
	   if (ret != ret_ok) {
			 PRINT_ERROR ("ERROR: Can't load validator module '%s'\n", yyvsp[-1].string);
			 return 1;
	   }

	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[-1].string, &info);

	   if (info->type != cherokee_validator) {
			 PRINT_ERROR ("ERROR: %s is not a validator module!!\n", yyvsp[-1].string);
	   }

	   directory_content_tmp.entry->validator_new_func = info->new_func;
}
    break;

  case 138:
#line 1010 "read_config_grammar.y"
    { cherokee_handler_table_entry_set (current_handler_table_entry, "file", yyvsp[0].string); }
    break;

  case 139:
#line 1015 "read_config_grammar.y"
    {
	   ret_t ret;
	   int   len;
	   cherokee_module_info_t         *info;
	   cherokee_handler_table_entry_t *dir;

	   /* Set the users public directory
	    */
	   len = strlen(yyvsp[-3].string);
	   SRV(server)->userdir = make_finish_with_slash (yyvsp[-3].string, &len);

	   /* Build the handler
	    */
	   dir = handler_table_entry_new ();

	   ret = cherokee_module_loader_load (SRV(server)->loader, yyvsp[-1].name_ptr.name);
	   if (ret != ret_ok) {
			 PRINT_ERROR ("ERROR: Can not load handler module '%s'\n", yyvsp[-1].name_ptr.name);
			 return 1;
	   }

	   cherokee_module_loader_get  (SRV(server)->loader, yyvsp[-1].name_ptr.name, &info);

	   cherokee_handler_table_enty_get_info (dir, info);
	   SRV(server)->userdir_handler = dir;

	   free (yyvsp[-1].name_ptr.name);
}
    break;

  case 140:
#line 1046 "read_config_grammar.y"
    {
	   linked_list_t *i = yyvsp[0].list;

	   while (i != NULL) {
			 cherokee_list_add_tail (&SRV(server)->index_list, i->string);
			 i = i->next;
	   }

	   free_linked_list (yyvsp[0].list, NULL);
}
    break;

  case 141:
#line 1058 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;
	   
	   if ((yyvsp[-1].number < 400) || (yyvsp[-1].number > 417))
	   {
			 PRINT_ERROR ("Error: Ignoring incorrect error code. Valid: 400..417. '%s'\n", yyvsp[0].string);
	   }

	   vsrv->error_document400[yyvsp[-1].number-400].file = yyvsp[0].string;
}
    break;

  case 142:
#line 1070 "read_config_grammar.y"
    {
	   cherokee_virtual_server_t *vsrv = auto_virtual_server;
	   
	   if ((yyvsp[-1].number < 400) || (yyvsp[-1].number > 417))
	   {
			 PRINT_ERROR ("Error: Ignoring incorrect error code. Valid: 400..417. '%s'\n", yyvsp[0].string);
	   }

	   vsrv->error_document400[yyvsp[-1].number-400].url = yyvsp[0].string;
}
    break;


    }

/* Line 999 of yacc.c.  */
#line 2406 "read_config_grammar.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 1081 "read_config_grammar.y"



