/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_GOTLS_HANDLER_H__
#define __CHEROKEE_GOTLS_HANDLER_H__

#include "common.h"
#include "buffer.h"
#include "handler.h"

typedef struct {
	cherokee_handler_t handler;

} cherokee_handler_gotls_t;

#define TLSHANDLER(x)  ((cherokee_handler_gotls_t *)(x))


/* Library init function
 */
void gotls_init (void);

ret_t cherokee_handler_gotls_new (cherokee_handler_t **hdl, void *cnt, cherokee_table_t *properties);

/* virtual methods implementation
 */
ret_t cherokee_handler_gotls_init        (cherokee_handler_gotls_t *dhdl);
ret_t cherokee_handler_gotls_free        (cherokee_handler_gotls_t *dhdl);
ret_t cherokee_handler_gotls_step        (cherokee_handler_gotls_t *dhdl, cherokee_buffer_t *buffer);
ret_t cherokee_handler_gotls_add_headers (cherokee_handler_gotls_t *dhdl, cherokee_buffer_t *buffer);

#endif /* __CHEROKEE_GOTLS_HANDLER_H__ */
