%{
/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "url_grammar.h"

#include <stdio.h>
#include <string.h>
%}

%option yylineno
%option nounput

ws              [ \t]+
integer         [-+]?[0-9]+
comment         #.*$
http            http(s)?\:\/\/[a-zA-Z0-9\$\:\-_\.\&\=\;\/\?]*
fpath           \/[^\"\{\}\n ]*
id              [\.\-_a-zA-Z0-9]+
id_wildcats     [\.\-_a-zA-Z0-9\*\?]+
nl              [\n\r]+
%%

{nl}            ;
{ws}            ;
{comment}       ;

"method"        { return T_METHOD; }
"keepalive"     { return T_KEEPALIVE; }
"no-keepalive"  { return T_NO_KEEPALIVE; }
"pipeline"      { return T_PIPELINE; }

{integer}       { yy_url_lval.number = atoi(yy_url_text);    return T_NUMBER; }
{http}          { yy_url_lval.string = strdup (yy_url_text); return T_HTTP_URL; }
{id}            { yy_url_lval.string = strdup (yy_url_text); return T_ID; }

<<EOF>>         { yyterminate(); }

.		      { return yy_url_text[0]; }


%%

int 
yy_url_wrap()
{
       return 1;
}

