/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_MIME_H__
#define __CHEROKEE_MIME_H__

#include "common.h"
#include "table.h"
#include "server.h"

typedef struct {
	cherokee_table_t mime_table;
	list_t           mime_list;
	list_t           name_list;
} cherokee_mime_t;

typedef struct {
	struct list_head   base;
	int                max_age;
	cherokee_buffer_t *mime_name;
} cherokee_mime_entry_t;


#define MIME(m)            ((cherokee_mime_t *)(m))
#define MIME_TABLE(m)      (&((cherokee_mime_t *)(m))->mime_table)
#define MIME_LIST(m)       (&((cherokee_mime_t *)(m))->mime_list)

#define MIME_ENTRY(m)      ((cherokee_mime_entry_t *)(m))
#define MIME_ENTRY_NAME(m) (((cherokee_mime_entry_t *)(m))->mime_name)
#define MIME_ENTRY_AGE(m)  (((cherokee_mime_entry_t *)(m))->max_age)

/* Mime methods
 */
ret_t cherokee_mime_init (cherokee_mime_t **mime);
ret_t cherokee_mime_free (cherokee_mime_t  *mime);

ret_t cherokee_mime_get_default (cherokee_mime_t **mime);
ret_t cherokee_mime_load        (cherokee_mime_t  *mime, char *filename);
ret_t cherokee_mime_get         (cherokee_mime_t  *mime, char *suffix, cherokee_mime_entry_t **entry);
ret_t cherokee_mime_add         (cherokee_mime_t  *mime, cherokee_mime_entry_t *entry);

/* Mime entry methods
 */
ret_t cherokee_mime_entry_new  (cherokee_mime_entry_t **mentry);
ret_t cherokee_mime_entry_free (cherokee_mime_entry_t  *mentry);


#endif /* __CHEROKEE_MIME_H__ */
