/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee Benchmarker
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001, 2002, 2003, 2004 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE_BENCH_H__
#define __CHEROKEE_BENCH_H__

#include "common.h"

#include <sys/time.h>
#include <time.h>

#include "list.h"
#include "thread.h"
#include "buffer.h"
#include "request.h"
#include "connection.h"


typedef struct {
	uint32_t number;
	uint32_t threads;
	uint32_t pipeline;
	uint32_t concurrency;
	cherokee_keepalive_t keepalive;

	list_t thread_list;

	list_t          request_list;
	pthread_mutex_t request_list_mutex;
	list_t         *request_list_current;

	struct {
		struct timeval start;
		struct timeval end;
	} time;

} cherokee_bench_t;


#define BENCH(b)           ((cherokee_bench_t *)(b))
#define BENCH_NUMBER(b)    (BENCH(b)->number)
#define BENCH_THREADS(b)   (BENCH(b)->threads)
#define BENCH_PIPELINE(b)  (BENCH(b)->pipeline)
#define BENCH_KEEPALIVE(b) (BENCH(b)->keepalive)
#define BENCH_CONCU(b)     (BENCH(b)->concurrency)

ret_t cherokee_bench_new  (cherokee_bench_t **bench);
ret_t cherokee_bench_free (cherokee_bench_t  *bench);

ret_t cherokee_bench_init       (cherokee_bench_t  *bench);
ret_t cherokee_bench_run        (cherokee_bench_t  *bench);
ret_t cherokee_bench_print_info (cherokee_bench_t *bench);

ret_t cherokee_bench_add_url       (cherokee_bench_t *bench, char *url);
ret_t cherokee_bench_read_url_file (cherokee_bench_t *bench, char *file);


/* Internal API, don't use it!
 */
ret_t _cherokee_bench_get_request (cherokee_bench_t *bench, cherokee_bench_request_t **url);
ret_t _cherokee_bench_add_request (cherokee_bench_t *bench, cherokee_bench_request_t  *req);

#endif /* __CHEROKEE_BENCH_H__ */

