/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "connection.h"
#include "handler_common.h"
#include "handler_file.h"
#include "handler_dirlist.h"


ret_t 
cherokee_handler_common_new (cherokee_handler_t **hdl, void *cnt)
{
	struct stat  info;
	char        *request;

	/* Yeah, yeah..
	 * This is very ugly, I know.. ;(
	 */
	request = CONN(cnt)->request_local;


	/* Request is a directory
	 */
	if ((stat (request, &info) == 0) && S_ISDIR(info.st_mode)) {
		char *new;
		int   len;
		ret_t ret;

		/* Look for an index file
		 */
		len = strlen (request);
		new = (char *) malloc (len + 12);
		sprintf (new, "%s/index.html", request);
		
		if ((stat (new, &info) == 0) && S_ISREG(info.st_mode)) {
			/* Sucks again :-((
			 */
			free (CONN(cnt)->request_local);
			CONN(cnt)->request_local = new;
			return cherokee_handler_file_new (hdl, cnt);
		} else {
			ret = cherokee_handler_dirlist_new (hdl, cnt);
		} 
		
		free (new);
		return ret;
	}


        /* File handler
	 */
	return cherokee_handler_file_new (hdl, cnt);
}



/* Library init function
 */

static int _common_is_init = 0;

void
common_init (void)
{
	if (_common_is_init)
		return;

	/* Init the dependences
	 */
	file_init();
	dirlist_init();

	_common_is_init = 1;
}
