/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2003 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE2_HANDLER_H__
#define __CHEROKEE2_HANDLER_H__

#include "common.h"
#include "buffer.h"
#include "http.h"


typedef enum {
	hstat_unset,
	hstat_sending,
	hstat_forbidden,
	hstat_file_not_found,
	hstat_error
} cherokee_handler_status_t;

typedef enum {
	hsupport_length = 1,        /* Know the length. Eg: for keep-alive */
	hsupport_range  = 1 << 1      /* Can handle "Range: bytes=" requests */
} cherokee_handler_support_t;


/* Callback function definitions
 */
typedef ret_t (* func_new_t)          (void **handler, void *cnt);
typedef ret_t (* func_init_t)         (void  *handler, char *request, char *request_local);
typedef ret_t (* func_free_t)         (void  *handler);
typedef ret_t (* func_step_t)         (void  *handler, cherokee_buffer_t *buffer);
typedef ret_t (* func_add_headers_t)  (void  *handler, cherokee_buffer_t *buffer);


typedef struct {
	cherokee_handler_support_t support;

	void            *connection;
	char            *redirect;
	
	/* 	Pure virtual methods
	 */
	func_init_t         init;
	func_free_t         free;
	func_step_t         step;
	func_add_headers_t  add_headers;
	   
} cherokee_handler_t;

#define HANDLER(x)       ((cherokee_handler_t *)(x))
#define HANDLER_CONN(h)  (CONN(HANDLER(h)->connection))


ret_t cherokee_handler_init_base   (cherokee_handler_t  *hdl);

ret_t cherokee_handler_init        (cherokee_handler_t  *hdl, char *request, char *request_local);
ret_t cherokee_handler_free        (cherokee_handler_t  *hdl);
ret_t cherokee_handler_step        (cherokee_handler_t  *hdl, cherokee_buffer_t *buffer);
ret_t cherokee_handler_add_headers (cherokee_handler_t  *hdl, cherokee_buffer_t *buffer);


#endif /* __CHEROKEE2_HANDLER_H__ */
