/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

#include <stdio.h>
#include "table.h"

/* Test tuple type
 */
typedef struct test_tuple_ test_tuple;
struct test_tuple_ {
	   char *name;
	   int   value;
};


/* Test array
 */
test_tuple test_array[] = 
{
	   {"nombre1", 0x00000000},
	   {"nombre2", 0xDEAD0000},
	   {"nombre3", 0x0000DEAD},
	   {"nombre4", 0x11111111},
	   NULL
};

char *unknown_entries_array[] = {
	   "no existe",
	   "no existe 2",
	   NULL
};


int
main (int arc, char **argv)
{
	   char *name;
	   int   i, value;
	   cherokee_table_t *table = NULL;
	   
	   /* TEST 1: Create table 
	    */
	   printf ("Before create the table: table=%p\n", table);
	   cherokee_table_new (&table);
	   printf ("After create the table:  table=%p\n", table);

	   
	   /* TEST 2: Insert in the table
	    */
	   for (i=0; test_array[i].name!=NULL; i++) {
			 name  = test_array[i].name;
			 value = test_array[i].value;

			 printf ("Inserting tuple ('%s', 0x%x)\n", name, value);
			 cherokee_table_add (table, name, (void *)value);
	   }

	   
	   /* TEST 3: Get unknown entries
	    */
	   for (i=0; unknown_entries_array[i]; i++) {
			 value = (int) cherokee_table_get (table,  unknown_entries_array[i]);
			 name  = unknown_entries_array[i];

			 printf ("Try to get an unknown entry '%s' from table: %p\n", name, value);
	   }


	   /* TEST 4: Get known entries
	    */
	   for (i=0; test_array[i].name!=NULL; i++) {
			 name  = test_array[i].name;
			 value = (int) cherokee_table_get (table, name);

			 printf ("Try to get a unkown entry ('%s', 0x%x)\n", name, value);
	   }

	   
	   /* TEST 5: Free the table avl-tree
	    * This is an internal function, you shouldn't use this.
	    */
	   printf ("Before destroy the table tree: avl-tree=%p\n", table->tree);
	   cherokee_table_clean (table);
	   printf ("After destroy the table tree:  avl-tree=%p\n", table->tree);


	   /* TEST 6: Free the avl-tree
	    * Due to cherokee architecture, the *_free() function can't set
	    * the pointer to NULL.  That's by a set it manually.
	    */
	   printf ("Before destroy the table: table=%p\n", table);
	   cherokee_table_free (table);
	   table = NULL;
	   printf ("After destroy the table:  table=%p\n", table);


	   return 0;
}
