/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __HTTP_H__
#define __HTTP_H__

typedef enum {
	   http_version_09,
	   http_version_10,
	   http_version_11,
	   http_version_unknown
} cherokee_http_version_t;

typedef enum {
	http_get,
	http_post,
	http_head,
	http_unknown
} cherokee_http_method_t;

typedef enum {
	   http_ok                = 200,
	   http_accepted          = 202,
	   http_partial_content   = 206,
	   http_moved_permanently = 301,
	   http_bad_request       = 400,
	   http_access_denied     = 403,
	   http_not_found         = 404,
	   http_internal_error    = 500
} cherokee_http_t;

/*                                      0        1         2         3         4         5         6         7
					1234567890123456789012345678901234567890123456789012345678901234567890 */
#define http_ok_string                 "200 OK"
#define http_accepted_string           "202 Accepted"
#define http_partial_content_string    "206 Partial Content"
#define http_moved_permanently_string  "301 Moved Permanently"
#define http_bad_request_string        "400 Bad Request"
#define http_access_denied_string      "403 Forbidden"
#define http_not_found_string          "404 Not Found"
#define http_internal_error_string     "500 Internal Server Error"

#define http_type_200(c)  ((c >= 200) && (c <= 300))
#define http_type_300(c)  ((c >= 300) && (c <= 400))
#define http_type_400(c)  ((c >= 400) && (c <= 500))
#define http_type_500(c)  ((c >= 500) && (c <= 600))


#endif /* __HTTP_H__ */
