/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE2_SERVER_H__
#define __CHEROKEE2_SERVER_H__

#include <time.h>

#include "common.h"
#include "list.h"
#include "fdpoll.h"
#include "plugin_table.h"
#include "server_config.h"


typedef struct {
	int    socket;
	time_t bogo_now;

	cherokee_server_conf_t  *config;
	cherokee_fdpoll_t       *fdpoll;
	cherokee_plugin_table_t *plugins;
	
	/* lists
	 */
	list_t active_list;
	list_t reuse_list;

} cherokee_server_t;


#define SRV(x) ((cherokee_server_t *)(x))


ret_t cherokee_server_new  (cherokee_server_t **srv);
ret_t cherokee_server_init (cherokee_server_t  *srv);
ret_t cherokee_server_free (cherokee_server_t  *srv);

ret_t cherokee_server_set  (cherokee_server_t  *srv, char *web_dir, char *handler);
void  cherokee_server_step (cherokee_server_t  *srv);

ret_t cherokee_server_log  (cherokee_server_t  *srv, int active);

#endif /* __CHEROKEE2_SERVER_H__ */
