/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CHEROKEE2_CONNECTION_HANDLER_FILE_H__
#define __CHEROKEE2_CONNECTION_HANDLER_FILE_H__

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include "common.h"
#include "buffer.h"
#include "handler.h"


typedef struct {
	cherokee_handler_t handler;
	
	int          fd;
	off_t        offset;
	struct stat  info;
	char        *mime;
} cherokee_handler_file_t;

#define FHANDLER(x)  ((cherokee_handler_file_t *)(x))


/* Library init function
 */
void file_init (void);


ret_t cherokee_handler_file_new   (cherokee_handler_t **hdl, void *cnt);

/* virtual methods implementation
 */
ret_t cherokee_handler_file_init        (cherokee_handler_file_t *hdl, char *req);
ret_t cherokee_handler_file_free        (cherokee_handler_file_t *hdl);
ret_t cherokee_handler_file_step        (cherokee_handler_file_t *hdl, cherokee_buffer_t *buffer);
ret_t cherokee_handler_file_add_headers (cherokee_handler_file_t *hdl, cherokee_buffer_t *buffer);

#endif /* __CHEROKEE2_CONNECTION_HANDLER_FILE_H__ */
