%{
/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "read_config_yacc.h"

#include <stdio.h>
#include <string.h>
%}

%option yylineno
%%

Port         return T_PORT;
DocumentRoot return T_DOCUMENT_ROOT;
Log          return T_LOG;
MimeFile     return T_MIME_FILE;
Directory    return T_DIRECTORY;
uses         return T_USES;

[0-9]+           { yylval = atoi(yytext);
                   return T_NUMBER; }

[a-zA-Z0-9\/.-]+ { yylval = yytext;
                   return T_STRING; }





\n           ; /* ignore EOL */
[ \t]+       ; /* ignore whitespace */
"#".*        ; /* ignore comments */

%%

int 
yywrap()
{
       return 1;
}

