#ifndef __CHEROKEE2_COMMON_H__
#define __CHEROKEE2_COMMON_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define DEFAULT_PAGE      "index.html"
#define DEFAULT_READ_SIZE 1024
#define MAX_HEADER_LEN    4096

#define CRLF  "\r\n"


/* Global mini-buffer:
 * for quick usage
 */
#define gbl_buffer_size 512
char    gbl_buffer[gbl_buffer_size];


typedef enum {
	   ret_ok,
	   ret_error,
	   ret_nomem,
	   ret_eof,
	   ret_file_not_found,
	   ret_eagain
} ret_t;

#define return_if_fail(expr,ret) \
	if (!(expr)) {                                                 \
		fprintf (stderr,                                          \
			    "file %s: line %d (%s): assertion `%s' failed\n",\
                   __FILE__,                                        \
                   __LINE__,                                        \
                   __PRETTY_FUNCTION__,                             \
                   #expr);                                          \
	     return (ret);                                             \
	};

#define SHOULDNT_HAPPEN \
	do { fprintf (stderr, "file %s: line %d (%s): this shouldn't happend\n", \
			            __FILE__, __LINE__, __PRETTY_FUNCTION__);          \
	} while (0);



#endif /* __CHEROKEE2_COMMON_H__ */
