/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "mime.h"

ret_t 
cherokee_mime_new  (cherokee_mime_t **mime)
{
	   cherokee_mime_t *n = (cherokee_mime_t *) malloc (sizeof(cherokee_mime_t));
	   return_if_fail (n!=NULL, ret_nomem);

	   cherokee_table_init(&n->table);

	   *mime = n;
	   return ret_ok;
}


ret_t 
cherokee_mime_free (cherokee_mime_t *mime)
{
	   cherokee_table_clean (&mime->table);

	   free(mime);

	   return ret_ok;
}


ret_t 
cherokee_mime_load (cherokee_mime_t *mime, char *filename)
{
	   FILE   *f;
	   char    buf[0xFF];
	   char    ext[32];
	   char    mime_string[80];

	   f = fopen (filename, "r");
	   return_if_fail (f!=NULL, ret_file_not_found);

	   while (!feof(f)) {
			 fgets (buf, 0xFF, f);

			 /* Empty
			  */
			 if (strlen(buf) < 3) 
				    continue;

			 /* Comments
			  */
			 if (buf[0] == '#')
				    continue;

			 /* Split the line
			  */
			 sscanf (buf, "%s\t%s",  &ext, &mime_string);

			 /* Add to table
			  */
			 cherokee_table_add (&mime->table, strdup(ext), strdup(mime_string));
	   }
	   
	   fclose(f);
	   return ret_ok;
}


char * 
cherokee_mime_get (cherokee_mime_t *mime, char *ext)
{
	   return cherokee_table_get (&mime->table, ext);
}



/* 	Library init function
 */

static int              _mime_is_init = 0;
static cherokee_mime_t *_mime_global  = NULL;

void
mime_init (void)
{
	   if (_mime_is_init) 
			 return;

	   cherokee_mime_new (&_mime_global);
	   cherokee_mime_load (_mime_global, CHEROKEE_PLUGINDIR"/mime_types.txt");
	   
	   _mime_is_init = 1;
}
