/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <stdlib.h>
#include <string.h>

#include "handler.h"


ret_t
cherokee_handler_init (cherokee_handler_t *hdl)
{
	   hdl->status   = http_ok;
	   hdl->redirect = NULL;
	   
	   /* Pure virtual methods
	    */
	   hdl->free               = NULL;
	   hdl->step               = NULL;
	   hdl->get_content_length = NULL;

	   return ret_ok;
}



/* 	Virtual method hidding layer
 */

ret_t
cherokee_handler_free (cherokee_handler_t *hdl)
{
	   if (hdl->redirect) {
			 free (hdl->redirect);
			 hdl->redirect = NULL;
	   }

	   if (hdl->free)
			 return hdl->free (hdl);

	   return ret_error;
}


ret_t
cherokee_handler_step (cherokee_handler_t *hdl, cherokee_buffer_t *buffer)
{
	   if (hdl->step)
			 return hdl->step (hdl, buffer);

	   return ret_error;
}


int
cherokee_handler_get_content_length (cherokee_handler_t *hdl)
{
	   if (hdl->get_content_length)
			 return hdl->get_content_length (hdl);

	   return -1;
}
