/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/* Cherokee
 *
 * Authors:
 *      Alvaro Lopez Ortega <alvaro@alobbs.com>
 *
 * Copyright (C) 2001-2002 Alvaro Lopez Ortega
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <string.h>

#include "buffer.h"

ret_t
cherokee_buffer_new  (cherokee_buffer_t **buf)
{
	   cherokee_buffer_t *n = (cherokee_buffer_t *) malloc(sizeof(cherokee_buffer_t));
	   return_if_fail (n != NULL, ret_nomem);

	   n->buf  = NULL;
	   n->size = 0;
	   n->len  = 0;
	   
	   *buf = n;
	   
	   return ret_ok;
}


ret_t
cherokee_buffer_free (cherokee_buffer_t *buf)
{
	   if (buf->buf)
			 free (buf->buf);

	   free (buf);

	   return ret_ok;
}


ret_t
cherokee_buffer_clean (cherokee_buffer_t *buf)
{
	   return cherokee_buffer_make_empty (buf);
}


ret_t
cherokee_buffer_add (cherokee_buffer_t  *buf, char *txt, int size)
{	   
	   int free = buf->size - buf->len;

	   /* Get memory
	    */
	   if (free <= size) {
			 buf->buf = (char *) realloc(buf->buf, buf->size + size - free);
			 return_if_fail (buf->buf, ret_nomem);

			 buf->size += size - free;
	   }
	   
	   /* Copy	
	    */
	   memcpy (buf->buf + buf->len, txt, size);

	   buf->len  += size;

	   buf->buf[buf->len] = '\0';
	   
	   return ret_ok;
}


int
cherokee_buffer_is_empty (cherokee_buffer_t *buf)
{
	   return (buf->len == 0);
}


ret_t
cherokee_buffer_make_empty (cherokee_buffer_t *buf)
{
	   buf->len = 0;
	   return ret_ok;
}


ret_t
cherokee_buffer_move_to_begin (cherokee_buffer_t *buf, int pos)
{
	   return_if_fail (pos <= buf->size, ret_error);

	   if (pos < buf->len) {
			 memcpy (buf->buf, buf->buf+pos, buf->size-pos);
			 buf->len -= pos;
	   }
	   
	   return ret_ok;
}


ret_t
cherokee_buffer_ensure_size (cherokee_buffer_t *buf, int size)
{
	   if (size > buf->size) {
			 buf->buf = (char *) realloc(buf->buf, size);
			 return_if_fail (buf->buf, ret_error);
			 buf->size = size;
	   }
	   
	   return ret_ok;
}
